<div class="tab-pane fade" id="company-information" role="tabpanel">
    <div class="form_content_inner">
        <form name='company-information'>
            @csrf
            <div class="edit_form">
                <a href="javascript:void(0);" class="edit-button-company-information">Edit</a>
            </div>
            <div class="form_group">
                <label for="">Company Name<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" class="edit-field-company-information" name="company" id="company" value="{{Auth::user()->company}}" maxlength="100" placeholder="Company Name*">
                </div>
            </div>
            <div class="form_group">
                <label for="">Country<span style="color: red;">*</span></label>
                <div class="form_feild">
                    @php $country=Auth::user()->country; @endphp
                    <select class="country-select AllCounteryList edit-field-company-information" name="country" id="country" ></select>
                    <label id="country-error-div" style="display: none;" class="error" for="country">Please select country name</label>
                </div>
            </div>
            @php $stateName=Auth::user()->state; @endphp
            <div class="form_group"  id="state_div" @if(!$stateName) style="display: none"  @endif >
                <label for="">State<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <select name="statelist" class="form-control edit-field-company-information" id="statelist" >
                        <option value="">Please Select State</option>
                        @foreach ($state_list as $state)
                            <option value="{{$state->code}}" @if($stateName==$state->code) selected @endif>{{$state->name}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form_group">
                <label for="">City<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" placeholder="City*" class="edit-field-company-information" value="{{Auth::user()->city}}" name="city" id="city" maxlength="50">
                </div>
            </div>
            <div class="form_group">
                <label for="">Address Line 1*<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" placeholder="Address Line 1*" class="edit-field-company-information" value="{{Auth::user()->address}}" name="address" id="address" maxlength="100">
                </div>
            </div>
            <div class="form_group">
                <label for="">Address Line 2<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" placeholder="Address Line 2*" class="edit-field-company-information" value="{{$data['address_2']}}" name="address_2" id="address_2" maxlength="100">
                </div>
            </div>
            <div class="form_group pincode-div">
                <label for="">Pincode<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" placeholder="Pincode" class="edit-field-company-information" value="{{Auth::user()->pincode}}" name="pincode" id="pincode" maxlength="6">
                </div>
            </div>

            <div class="form_group">
                @php $company_calling_code=$data['company_calling_code']; @endphp
                <label for="">Contact Number<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="hidden" name="company_calling_code" class="company_calling_code" value="{{$company_calling_code}}" id="company_calling_code">
                    <input type="text" value="{{$data['company_phone']}}" class="edit-field-company-information" class="form-control" placeholder="Contact Number*" maxlength="15" name="company_phone" id="company_phone">
                    <span class="text-danger error-calling_code">Please enter International Calling code.</span>
                </div>
            </div>
            <div class="form_group">
                <label for="">What is your primary business domain focus?<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text"  class="edit-field-company-information"  placeholder="What is your primary business domain focus?*"  value="{{@$data['what_is_your_primary_business_domain_focus']}}" name="what_is_your_primary_business_domain_focus" id="what_is_your_primary_business_domain_focus"  maxlength="20">
                </div>
            </div>
            <div class="form_group ">
                <label for="">Primary Company Website or Social Media Page<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text"  class="edit-field-company-information" name="primary_company_website_or_social_media_page" value="{{$data['primary_company_website_or_social_media_page']}}" id="primary_company_website_or_social_media_page" placeholder="Primary Company Website or Social Media Page*"  maxlength="50">
                </div>
            </div>
            <div class="form_group ">
                <label for="">Short Description<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <textarea name="short_description_of_your_company" class="edit-field-company-information" maxlength="500" id="short_description_of_your_company" cols="30" rows="5" placeholder="Short Description*">{{$data['short_description_of_your_company']}}</textarea>
                </div>
            </div>
            <div class="save_discard div-button-company-information">
                <button type="button" class="discard_btn discard-button-company-information" >DISCARD</button>
                <button type="submit" class="save_btn save-button-company-information" >SAVE</button>
            </div>
        </form>
    </div>
</div>


<script>
$("document").ready(function () {
    // -----Country Code Selection
    $("#company_phone").intlTelInput({
        initialCountry: "{{(@$company_calling_code)?@$company_calling_code:'auto'}}",
        separateDialCode: true,
    });
});
$('.error-calling_code').hide();
$('#state_div').hide();
</script>
<script>
    var oldCompanyInformation=$("form[name='company-information']").serialize();

    function editFieldCompanyInformation(status){
        const editFields = document.querySelectorAll('.edit-field-company-information');
        editFields.forEach((element) => {
            element.disabled = status;
        });
        if(status==false){
            $('.edit-button-company-information').hide();
            $('.div-button-company-information').show();
            $('#f_name').focus();
        }else{
            $('.edit-button-company-information').show();
            $('.div-button-company-information').hide();
        }
    }
    //default
    editFieldCompanyInformation(true);
    //edit button
    $(document).on('click', '.edit-button-company-information', function(){
        editFieldCompanyInformation(false);
    });

    //data submit
    jQuery(function() {
        // Add custom validation method for country field
        $.validator.addMethod("validCountry", function (value) {
            if(value !== "-1"){
                $('#country-error-div').hide();
            }else{
                $('#country-error-div').show();
            }
            return value !== "-1";
        }, "Please select country name.");
        // Custom validation method for checking Calling Code
        $.validator.addMethod("CallingCode", function(value, element) {
            return ($('#company_calling_code').val())?true:false;
        }, "Please select Calling code.");

        jQuery("form[name='company-information']").validate({
            rules: {
                company:{
                    required: true,
                    maxlength:101,
                    minlength:2
                },
                city:{
                    required: true,
                    maxlength:51
                },
                address:{
                    required: true,
                    maxlength:101
                },
                address_2:{
                    required: true,
                    maxlength:101
                },
                country: {
                    validCountry: true
                },
                company_phone:{
                    CallingCode:true,
                    required:true,
                    digits:true
                },
                pincode:{
                    required:function() {
                        if($("#country").val()=='AE'){
                            return false;
                        }
                        return true;
                    },
                    digits:true
                },
                statelist:{required:
                    function() {
                        if($("#country").val()=='IN'){
                            return true;
                        }
                        return false;
                    }
                },
                what_is_your_primary_business_domain_focus:'required',
                primary_company_website_or_social_media_page:'required',
                short_description_of_your_company:'required'
            },
            // Specify validation error messages
            messages: {
                city:{
                    maxlength: "City name must be less then 50 characters long.",
                    required: "Please enter city name."
                },
                address:{
                    maxlength: "address must be less then 100 characters long.",
                    required: "Please enter address line 1."
                },
                address_2:{
                    maxlength: "address must be less then 100 characters long.",
                    required: "Please enter address line 2."
                },
                company:{
                    required: "Please enter company name",
                    maxlength: "Company name must be less then 100 characters long.",
                    minlength: "Company name must be greater then 2 characters long."
                },
                country:"Please select country name",
                calling_code:{
                    required:"Please enter International Calling code."
                },
                pincode: {
                    required: "Please enter Pincode/Zipcode",
                    minlength: "Pincode/Zipcode must be 6 digits long."
                },
                company_phone: {
                    required: "Please enter phone number.",
                    minlength: "Your phone number must be at least 10 digits long",
                    maxlength: "Your phone number must be less or equal 15 digits long"
                },
                statelist : "Please Select State",
                what_is_your_primary_business_domain_focus : "Please enter What is your primary business domain focus",
                primary_company_website_or_social_media_page : "Please enter Primary Company Website or Social Media Page",
                short_description_of_your_company : "Please enter Short Description"
            },
            submitHandler: function(form) {
                var formData = $("form[name='company-information']").serialize();
                $.ajax({
                    type: "POST",
                    url: "{{route('partner.profile.company-information.update')}}",
                    data: formData,
                    success: function(response) {
                        oldCompanyInformation=formData;
                        editFieldCompanyInformation(true);
                        AlertMassage(response.message);
                        // $('#company-information-value').val(10);
                        // ProgressGraphStatus();
                    },
                    error: function(xhr, status, error) {
                        AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);
                    }
                });
            }
        });
    });
    //discard button
    $(document).on('click', '.discard-button-company-information', function(){
        var params = new URLSearchParams(oldCompanyInformation);

        // Set values for each form field using the extracted values
        setFieldValue("company", params.get("company"));
        setFieldValue("city", params.get("city"));
        setFieldValue("address", params.get("address"));
        setFieldValue("address_2", params.get("address_2"));
        setFieldValue("country", params.get("country"));
        setFieldValue("company_phone", params.get("company_phone"));
        setFieldValue("pincode", params.get("pincode"));
        setFieldValue("statelist", params.get("statelist"));
        setFieldValue("what_is_your_primary_business_domain_focus", params.get("what_is_your_primary_business_domain_focus"));
        setFieldValue("primary_company_website_or_social_media_page", params.get("primary_company_website_or_social_media_page"));
        setFieldValue("short_description_of_your_company", params.get("short_description_of_your_company"));
        
        editFieldCompanyInformation(true);
    });

    $(document).ready(function(){
        $('body').on('change', '#country', function(){
            $('#country_code').val($(this).val());
            if($(this).val() == 'AE'){
                $('.pincode-div').hide();
            } else {
                $('.pincode-div').show();
            }
            if($(this).val() == 'IN'){
                $('#state_div').show();
            } else {
                $('#state_div').hide();
            }
            $('#country-error').hide();
            $('#country-error-div').hide();
        });
    });

    //Dealer Name
    jQuery(document).on('keypress', '#company', function(event) {
        jQuery('.error-country').hide();
        $(this).css({'text-transform': 'capitalize'});
        var regex = new RegExp("^[a-zA-Z 0-9 .-]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key) && event.which !== 13) {
            event.preventDefault();
            return false;
        }
    });
    //Dealer Name
    jQuery(document).on('keypress', '#city', function(event) {
        jQuery('.error-city').hide();
        $(this).css({'text-transform': 'capitalize'});
        var regex = new RegExp("^[a-zA-Z 0-9 ,'-]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key) && event.which !== 13) {
            event.preventDefault();
            return false;
        }
        var phone_no=$('#city').val();
        if(phone_no.length>50){
            return false;
        }
    });
    //phone
    jQuery(document).on('keypress', '#pincode,#company_phone', function(event) {
        var regex = new RegExp("^[0-9]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key) && event.which !== 13) {
            event.preventDefault();
            return false;
        }
    });
    //Street  Address
    jQuery(document).on('keypress', '#address,#address_2,#what_is_your_primary_business_domain_focus,#short_description_of_your_company', function(event) {
        jQuery('.error-address').hide();
        $(this).css({'text-transform': 'capitalize'});
        var regex = new RegExp("^[a-zA-Z0-9 .' ,-]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key) && event.which !== 13) {
            event.preventDefault();
            return false;
        }
    });
    
    // change calling code
    $('body').on('click keydown keypress touchstart pointerdown', '.iti__country.iti__standard', function() {
        var flagElement = $(this).find('.iti__flag').attr('class');
        var newText = flagElement.replace("iti__flag iti__", "");
        $('#company_calling_code').val(newText);
        
    });
    @if(@$country)
        setTimeout(() => {
            $("#country").val("<?=@$country?>").change();
            $("#statelist").val("<?=@$stateName?>").change();
        }, 1000);
    @endif
</script>
