@php
 $footer_sign_up_for_free_trial = true;
    $add_class_header = 'show-nav';
@endphp
@extends('frontend.user.includes.master')
@section('body')
    <section class="step_screen_wrap company-financial">
        <div class="container">
            <div class="step__title">
                <h1><?=@$partner_page_data->title?></h1>
            </div>
            <div class="form_border Financial__Info__form">
                <div class="left_grid">
                    <div class="number_list">
                        <ul>
                            <li><a href="{{route('become-a-partner.login-information')}}">1</a></li>
                            <li><a href="{{route('become-a-partner.basic-information')}}">2</a></li>
                            <li><a href="{{route('become-a-partner.company-information')}}">3</a></li>
                            <li class="active">4</li>
                            <li><a href="{{route('become-a-partner.company-financial-information2')}}">5</a></li>
                            <li><a href="{{route('become-a-partner.company-documents-upload')}}">6</a></li>
                            <!-- <li><a href="{{route('become-a-partner.thank-you')}}">7</a></li> -->
                            <li><a href="{{route('become-a-partner.profile-verification-summary')}}">7</a></li>
                            <li><a href="{{route('become-a-partner.partner-contract')}}">8</a></li>
                            <li><a href="{{route('become-a-partner.contract-verification')}}">9</a></li>
                        </ul>
                    </div>
                    <div class="form_grid_inner">
                        <div class="left_title">
                            <h2>{{ HelperServiceProvider::GetLanguageText('company_financial_information')}}</h2>
                        </div>
                        <form action="{{route('become-a-partner.company-financial-information.store')}}" name="patner_registration"  method="POST" autocomplete="off">
                            @csrf
                            <div class="form_group full_label resp_spacing">
                                <label>{{ HelperServiceProvider::GetLanguageText('what_was_the_total_sales_and_services')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    @php $total_sales=PartnerRegistrationProvider::PartnerRegistration('what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year') @endphp
                                    <select name="what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year" id="what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year">
                                        <option value="">Select</option>
                                        <option value="Less than 20,000">Less than 20,000</option>
                                        <option value="Less than 50,000">Less than 50,000</option>
                                        <option value="Less than 100,000">Less than 100,000</option>
                                        <option value="Less than 200,000">Less than 200,000</option>
                                        <option value="More than 200,000">More than 200,000</option>
                                    </select>
                                    @error('what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label">
                                <label>{{ HelperServiceProvider::GetLanguageText('what_percentage_of_your_revenue_directly_results')}}</label>
                            </div>
                            <div class="form_group full_label half_grid face-field">
                                <label>{{ HelperServiceProvider::GetLanguageText('face-to-face_field_sales')}}</label>
                                <div class="form_feild">
                                    <input type="text" name="face_to_face_field_sales" value="{{PartnerRegistrationProvider::PartnerRegistration('face_to_face_field_sales')}}" id="face_to_face_field_sales" placeholder="">
                                    @error('face_to_face_field_sales')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label half_grid face-field">
                                <label>{{ HelperServiceProvider::GetLanguageText('telephone_based_consultative_sales_resources')}}</label>
                                <div class="form_feild">
                                    <input type="text" placeholder="" name="telephone_based_consultative_sales_resources" id="telephone_based_consultative_sales_resources" value="{{PartnerRegistrationProvider::PartnerRegistration('telephone_based_consultative_sales_resources')}}" >
                                    @error('telephone_based_consultative_sales_resources')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label half_grid face-field">
                                <label>{{ HelperServiceProvider::GetLanguageText('via_internet_with_limited_human_interference')}}</label>
                                <div class="form_feild">
                                    <input type="text" placeholder="" name="via_internet_with_limited_human_interference" id="via_internet_with_limited_human_interference"  value="{{PartnerRegistrationProvider::PartnerRegistration('via_internet_with_limited_human_interference')}}" >
                                    @error('via_internet_with_limited_human_interference')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label half_grid radio-btn">
                                <label>{{ HelperServiceProvider::GetLanguageText('do_you_have_a_single_primary_vertical_market?')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    @php $do_you_have_a_single_primary_vertical_market=PartnerRegistrationProvider::PartnerRegistration('do_you_have_a_single_primary_vertical_market') @endphp
                                    <div class="radio-sec">
                                        <div class="radio-btn-sec">
                                            <input type="radio" name="do_you_have_a_single_primary_vertical_market" @if($do_you_have_a_single_primary_vertical_market=='Yes') checked @endif  value="Yes"> <label>{{ HelperServiceProvider::GetLanguageText('yes')}}</label>
                                        </div>
                                        <div class="radio-btn-sec">
                                            <input type="radio" name="do_you_have_a_single_primary_vertical_market" @if($do_you_have_a_single_primary_vertical_market=='No') checked @endif  value="No"> <label>{{ HelperServiceProvider::GetLanguageText('no')}}</label>
                                            <span class="checkmarker"></span>
                                        </div>
                                    </div>
                                    @error('do_you_have_a_single_primary_vertical_market')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label half_grid face-field select-opt">
                                <label>{{ HelperServiceProvider::GetLanguageText('what_is_your_companys_primary_vertical_market_focus?')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    @php $what_is_your_company_primary_vertical_market_focus = PartnerRegistrationProvider::PartnerRegistration('what_is_your_company_primary_vertical_market_focus') @endphp
                                    <select name="what_is_your_company_primary_vertical_market_focus" id="what_is_your_company_primary_vertical_market_focus">
                                        <option value="">select </option>
                                            @if(!$market_sectors_lists->isEmpty())
                                                @foreach ($market_sectors_lists as $item)
                                                    <option value="{{$item->name}}">{{$item->name}}</option>
                                                @endforeach
                                            @endif
                                    </select>
                                    @error('what_is_your_company_primary_vertical_market_focus')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_btn_grid">
                                <button type="submit" class="btn_cta">{{ HelperServiceProvider::GetLanguageText('save_and_next')}}</button>
                                <button type="reset" class="btn_cta">{{ HelperServiceProvider::GetLanguageText('clear_all')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="right_grid">
                    <div class="right_gray_bg basice_information Financial-Information">
                        <div class="right__side_img">
                            <img src="{{url($partner_page_data->page_4_image)}}" alt="Financial-Information">
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('script')
<script>
    jQuery(function() {
      jQuery("form[name='patner_registration']").validate({
        rules: {
            what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year:'required',
            do_you_have_a_single_primary_vertical_market:'required',
            what_is_your_company_primary_vertical_market_focus:'required'
        },
        // Specify validation error messages
        messages: {
            what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year : "Please select Please select What was the total sales and services revenue generated by your company in its last fiscal year (USD).",
            do_you_have_a_single_primary_vertical_market : "Please select Please select Do you have a single primary vertical market?.",
            what_is_your_company_primary_vertical_market_focus : "Please select Please select What is your company’s primary vertical market focus."
        },
        submitHandler: function(form) {
            form.submit();
        }
      });
    });
    setTimeout(() => {
        $("#what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year").val("<?=@$total_sales?>").change();
        $("#what_is_your_company_primary_vertical_market_focus").val("<?=@$what_is_your_company_primary_vertical_market_focus?>").change();
    }, 1000);
</script>
@endsection
