@php
    $add_class_header = 'show-nav';
    $footer_sign_up_for_free_trial = true;
@endphp
@extends('frontend.user.includes.master')
@section('body')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <style>
        .error{color: red;}
    </style>
    <section class="step_screen_wrap company-financial screen_six screen_seven">
        <div class="container">
            <div class="step__title">
                <h1><?=@$partner_page_data->title?></h1>
            </div>
            <div class="form_border Financial__Info__form left left_side_profile">
                <div class="left_grid">
                    <div class="number_list">
                        <ul>
                            <li><a href="{{route('become-a-partner.login-information')}}">1</a></li>
                            <li><a href="{{route('become-a-partner.basic-information')}}">2</a></li>
                            <li><a href="{{route('become-a-partner.company-information')}}">3</a></li>
                            <li><a href="{{route('become-a-partner.company-financial-information')}}">4</a></li>
                            <li><a href="{{route('become-a-partner.company-financial-information2')}}">5</a></li>
                            <li class="active">6</li>
                            <!-- <li><a href="{{route('become-a-partner.thank-you')}}">7</a></li> -->
                            <li><a href="{{route('become-a-partner.profile-verification-summary')}}">7</a></li>
                            <li><a href="{{route('become-a-partner.partner-contract')}}">8</a></li>
                            <li><a href="{{route('become-a-partner.contract-verification')}}">9</a></li>
                        </ul>
                    </div>
                    <div class="form_grid_inner">
                        <div class="left_title profile_title">
                            <h2>{{ HelperServiceProvider::GetLanguageText('company_documents_upload')}} </h2>
                        </div>
                        <form action="{{route('become-a-partner.company-documents-upload.store')}}" name="patner_registration" id="patner_registration" enctype="multipart/form-data" method="POST" autocomplete="off">
                            @csrf
                            <div class="form_group full_label resp_spacing prof_spacing">
                                <label><strong>{{ HelperServiceProvider::GetLanguageText('country')}} : {{$country}}</strong></label>
                            </div>
                            <input type="hidden" name="country_code" value="{{$country_code}}">
                            @if(strtolower($country_code)=='in')
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('gst_number')}}<span style="color: red;">*</span></label>
                                    <div class="form_feild">
                                        <input type="text" name="gst_number" value="{{PartnerRegistrationProvider::PartnerRegistration('gst_number')}}" id="gst_number" placeholder="">
                                        @error('gst_number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('pan_number')}}<span style="color: red;">*</span></label>
                                    <div class="form_feild">
                                        <input type="text" name="pan_number" value="{{PartnerRegistrationProvider::PartnerRegistration('pan_number')}}" id="pan_number" placeholder="">
                                        @error('pan_number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('pan_card_copy')}}<span style="color: red;">*</span></label>
                                    <div class="form_feild">
                                        <label class="filelabel">
                                            <span class="title">+Attach</span>
                                            <i class="fa fa-paperclip" aria-hidden="true"></i>
                                            <input class="FileUpload1" id="FileInput" name="pan_card_copy" type="file" />
                                        </label>
                                        @error('pan_card_copy')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                        <span class="error" style="display: none;">PAN Card Copy.</span>
                                    </div>
                                </div>
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('aadhar_card_number')}}<span style="color: red;">*</span></label>
                                    <div class="form_feild">
                                        <input type="text" name="aadhar_card_number" value="{{PartnerRegistrationProvider::PartnerRegistration('aadhar_card_number')}}" id="aadhar_card_number" placeholder="">
                                        @error('aadhar_card_number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('aadhar_card_copy')}}<span style="color: red;">*</span></label>
                                    <div class="form_feild">
                                        <label class="filelabel">
                                            <span class="title">+Attach</span>
                                            <i class="fa fa-paperclip" aria-hidden="true"></i>
                                            <input class="FileUpload1" id="FileInput1" name="aadhar_card_copy" type="file" />
                                        </label>
                                        @error('aadhar_card_copy')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                        <span class="error" style="display: none;">Aadhar Card Copy.</span>
                                    </div>
                                </div>
                            @elseif (strtolower($country_code)=='sg')
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('gst_number')}}<span style="color: red;">*</span></label>
                                    <div class="form_feild">
                                        <input type="text" name="gst_number" value="{{PartnerRegistrationProvider::PartnerRegistration('gst_number')}}" id="gst_number" placeholder="">
                                        @error('gst_number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('acra_number')}}<span style="color: red;">*</span></label>
                                    <div class="form_feild">
                                        <input type="text" name="acra_number" value="{{PartnerRegistrationProvider::PartnerRegistration('acra_number')}}" id="acra_number" placeholder="">
                                        @error('acra_number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('acra_profile_copy')}}<span style="color: red;">*</span></label>
                                    <div class="form_feild">
                                        <label class="filelabel">
                                            <span class="title">+Attach</span>
                                            <i class="fa fa-paperclip" aria-hidden="true"></i>
                                            <input class="FileUpload1" id="FileInput" name="acra_profile_copy" type="file" />
                                        </label>
                                        <span class="error" style="display: none;">Please upload the ACRA profile copy.</span>
                                    </div>
                                </div>
                            @elseif (strtolower($country_code)=='ae')
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('trn_number')}}<span style="color: red;">*</span></label>
                                    <div class="form_feild">
                                        <input type="text" name="trn_number" value="{{PartnerRegistrationProvider::PartnerRegistration('trn_number')}}" id="trn_number" placeholder="">
                                        @error('trn_number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('tax_registration_number')}}<span style="color: red;">*</span></label>
                                    <div class="form_feild">
                                        <input type="text" name="tax_registration_number" value="{{PartnerRegistrationProvider::PartnerRegistration('tax_registration_number')}}" id="tax_registration_number" placeholder="">
                                        @error('tax_registration_number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('tax_registration_document')}}<span style="color: red;">*</span></label>
                                    <div class="form_feild">
                                        <label class="filelabel">
                                            <span class="title">+Attach</span>
                                            <i class="fa fa-paperclip" aria-hidden="true"></i>
                                            <input class="FileUpload1" id="FileInput" name="tax_registration_document"  type="file" />
                                        </label>
                                        @error('tax_registration_document')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                        <span class="error" style="display: none;">Please upload the tax registration document.</span>
                                    </div>
                                </div>
                            @elseif (strtolower($country_code)=='id')
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('npwp_number')}}<span style="color: red;">*</span></label>
                                    <div class="form_feild">
                                        <input type="text" name="npwp_number" value="{{PartnerRegistrationProvider::PartnerRegistration('npwp_number')}}" id="npwp_number" placeholder="">
                                        @error('npwp_number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('tax_registration_number')}}<span style="color: red;">*</span></label>
                                    <div class="form_feild">
                                        <input type="text" name="tax_registration_number" value="{{PartnerRegistrationProvider::PartnerRegistration('tax_registration_number')}}" id="tax_registration_number" placeholder="">
                                        @error('tax_registration_number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form_group full_label half_grid face-field profile_check">
                                    <label>{{ HelperServiceProvider::GetLanguageText('tax_registration_document')}}<span style="color: red;">*</span></label>
                                    <div class="form_feild">
                                        <label class="filelabel">
                                            <span class="title">+Attach</span>
                                            <i class="fa fa-paperclip" aria-hidden="true"></i>
                                            <input class="FileUpload1" id="FileInput" name="tax_registration_document"  type="file" />
                                        </label>
                                        @error('tax_registration_document')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                        <span class="error" style="display: none;">Please upload the tax registration document.</span>
                                    </div>
                                </div>
                            @endif
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('company_address_proof')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <label class="filelabel">
                                        <span class="title">+Attach</span>
                                        <i class="fa fa-paperclip" aria-hidden="true"></i>
                                        <input class="FileUpload1" id="FileInput2" name="company_address_proof" type="file" />
                                    </label>
                                    <span class="error" style="display: none;">Please upload the Company Address Proof.</span>
                                </div>
                                @error('company_address_proof')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('company_registration_number')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <input type="text" name="company_registration_number" value="{{PartnerRegistrationProvider::PartnerRegistration('company_registration_number')}}" id="company_registration_number" placeholder="">
                                    @error('company_registration_number')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('company_registration_copy')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <label class="filelabel">
                                        <span class="title">+Attach</span>
                                        <i class="fa fa-paperclip" aria-hidden="true"></i>
                                        <input class="FileUpload1" id="FileInput3" name="company_registration_copy" type="file" />
                                    </label>
                                    <span class="error" style="display: none;">Please upload the Company Registration Copy.</span>
                                    @error('company_registration_copy')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('passport_number')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <input type="text" name="passport_number" value="{{PartnerRegistrationProvider::PartnerRegistration('passport_number')}}" id="passport_number" placeholder="">
                                    @error('passport_number')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('passport_copy')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <label class="filelabel">
                                        <span class="title">+Attach</span>
                                        <i class="fa fa-paperclip" aria-hidden="true"></i>
                                        <input class="FileUpload1" id="FileInput4" name="passport_copy" type="file" />
                                    </label>
                                    <span class="error" style="display: none;">Please upload the Passport Copy.</span>
                                    @error('passport_copy')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('passport_size_photo')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <label class="filelabel">
                                        <span class="title">+Attach</span>
                                        <i class="fa fa-paperclip" aria-hidden="true"></i>
                                        <input class="FileUpload1" id="FileInput5" name="passport_size_photo" type="file" />
                                    </label>
                                    <span class="error" style="display: none;">Please upload the Passport Size Photo.</span>
                                    @error('passport_size_photo')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('partners_signature_copy')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <label class="filelabel">
                                        <span class="title">+Attach</span>
                                        <i class="fa fa-paperclip" aria-hidden="true"></i>
                                        <input class="FileUpload1" id="FileInput6" name="partners_signature_copy" type="file" />
                                    </label>
                                    <span class="error" style="display: none;">Please upload the Partners Signature Copy.</span>
                                    @error('partners_signature_copy')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('kyc_form')}}<span style="color: red;">*</span></label>
                                <div class="form_feild anchor">
                                @if($partner_page_data->kyc_form && $partner_page_data->kyc_form_text)
                                    <a href="{{url($partner_page_data->kyc_form)}}" download="KYC Form"><?=$partner_page_data->kyc_form_text?></a>
                                @endif
                                </div>
                            </div>
                            <div class="form_group full_label half_grid face-field profile_check">
                                <label>{{ HelperServiceProvider::GetLanguageText('upload_kyc_form')}}<span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <label class="filelabel">
                                        <span class="title">+Attach</span>
                                        <i class="fa fa-paperclip" aria-hidden="true"></i>
                                        <input class="FileUpload1" id="FileInput7" name="kyc_form" type="file" />
                                    </label>
                                    <span class="error" style="display: none;">Please upload the KYC Form.</span>
                                    @error('kyc_form')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="check_section">
                                <div class="check_confirm">
                                    <input type="checkbox" name="partner_agrement_and_confirm" >
                                    <p>{{ HelperServiceProvider::GetLanguageText('on_the_behalf_of_the_company')}}</p>
                                </div>
                                @if($partner_page_data->view_terms_of_use_text && $partner_page_data->view_terms_of_use_link)
                                    <div class="terms_sec"><a href="{{url($partner_page_data->view_terms_of_use_link)}}" target="_blank"><?=$partner_page_data->view_terms_of_use_text?></a></div>
                                @endif
                            </div>
                            <div class="form_btn_grid">
                                <button class="btn_cta" type="button" onclick="PreviewDetails();">{{ HelperServiceProvider::GetLanguageText('preview_details')}}</button>
                                <button type="submit" class="btn_cta">{{ HelperServiceProvider::GetLanguageText('submit')}}</button>
                                <button type="reset" class="btn_cta">{{ HelperServiceProvider::GetLanguageText('clear_all')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="right_grid right_side_profile seven_screen_rightside">
                    <div class="right_gray_bg basice_information Financial-Information">
                        <div class="right__side_img">
                            <img src="{{url($partner_page_data->page_6_image)}}" alt="Financial-Information">
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('script')
    <script>
        jQuery(function() {
            // Add custom validation method for country field
                $.validator.addMethod("validFile", function (value) {
                    var count=0;
                    $('.FileUpload1').each(function(){
                        if($(this).val()==''){
                            $(this).parent().css({ 'border': ' 2px solid red' });
                            $(this).parent().parent().find('.error').show();
                            count++;
                        }
                    });
                    return count==0;
                },'');
            jQuery("form[name='patner_registration']").validate({
                rules: {
                    company_registration_number: {
                        validFile : true,
                        required: true
                    },
                    passport_number:'required',
                    gst_number:'required',
                    pan_number:'required',
                    aadhar_card_number:'required',
                    acra_number:'required',
                    trn_number:'required',
                    tax_registration_number:'required',
                    npwp_number:'required',
                    partner_agrement_and_confirm:'required'
                },
                // Specify validation error messages
                messages: {
                    company_address_proof: {
                        required: "Please upload the Company Address Proof.",
                        accept: "Please upload a valid PDF, JPG,JPEG or PNG file."
                    },
                    company_registration_copy: {
                        required: "Please upload the Company Registration Copy.",
                        accept: "Please upload a valid PDF, JPG,JPEG or PNG file."
                    },
                    passport_copy: {
                        required: "Please upload the Passport Copy.",
                        accept: "Please upload a valid PDF, JPG,JPEG or PNG file."
                    },
                    passport_size_photo: {
                        required: "Please upload the Passport Size Photo.",
                        accept: "Please upload a valid PDF, JPG,JPEG or PNG file."
                    },
                    partners_signature_copy: {
                        required: "Please upload the Partners Signature Copy.",
                        accept: "Please upload a valid PDF, JPG,JPEG or PNG file."
                    },
                    kyc_form: {
                        required: "Please upload the KYC Form.",
                        accept: "Please upload a valid PDF, JPG,JPEG or PNG file."
                    },
                    pan_card_copy: {
                        required: "Please upload the PAN Card Copy.",
                        accept: "Please upload a valid PDF, JPG,JPEG or PNG file."
                    },
                    aadhar_card_copy: {
                        required: "Please upload the Aadhar Card Copy.",
                        accept: "Please upload a valid PDF, JPG,JPEG or PNG file."
                    },
                    acra_profile_copy: {
                        required: "Please upload the ACRA profile copy.",
                        accept: "Please upload a valid PDF, JPG,JPEG or PNG file."
                    },
                    tax_registration_document: {
                        required: "Please upload the tax registration document.",
                        accept: "Please upload a valid PDF, JPG,JPEG or PNG file."
                    },
                    company_registration_number : {
                        required:"Please Enter Company Registration Number."
                    },
                    passport_number : "Please Enter Passport Number.",
                    gst_number : "Please Enter GST Number.",
                    pan_number : "Please Enter PAN Number.",
                    aadhar_card_number : "Please Enter Aadhar Card Number.",
                    acra_number : "Please Enter ACRA Number.",
                    trn_number : "Please Enter TRN Number.",
                    npwp_number : "Please Enter NPWP Number.",
                    partner_agrement_and_confirm : "Please accept term and condition.",
                    tax_registration_number : "Please Enter tax registration number."
                },
                submitHandler: function(form) {
                    form.submit();
                }
            });
        });
    </script>
    <script>
        // document.getElementById('patner_registration').addEventListener('change', function (event) {
        $( document ).ready(function() {
            var fileInputs = document.querySelectorAll('input[type="file"]');
            var allowedExtensions = ['png', 'jpg', 'pdf'];
            fileInputs.forEach(function (fileInput) {
                fileInput.addEventListener('change', function () {
                    var fileName = this.value.split('\\').pop(); // Get the file name from the path
                    // Check if the file extension is allowed
                    var fileExtension = fileName.split('.').pop().toLowerCase();
                    if (allowedExtensions.indexOf(fileExtension) === -1) {
                        // alert('Invalid file type. Allowed types are PNG, JPG, and PDF.');
                        this.value = ''; // Clear the input field
                        $(this).parent().find(".title").text('+Attach');
                        // color
                        $(this).parent().find("i").removeClass().addClass('fa fa-paperclip');
                        $(this).parent().find("i, .title").css({
                            'color': 'black'
                        });
                        $(this).parent().parent().find('.error').show();
                        $(this).parent().css({
                            'border': ' 2px solid red'
                        });
                    } else {
                        var labelVal = $(this).parent().find(".title").text();
                        var oldfileName = $(this).val();
                        var extension = fileName.split('.').pop();
                        if (fileName) {
                            if (fileName.length > 10) {
                                $(this).parent().find(".title").text(fileName.slice(0, 4) + '...' + extension);
                            } else {
                                $(this).parent().find(".title").text(fileName);
                            }
                        } else {
                            $(this).parent().find(".title").text(labelVal);
                        }
                        // color
                        $(this).parent().find("i").removeClass().addClass('fa fa-file-image-o');
                        $(this).parent().find("i, .title").css({
                            'color': '#208440'
                        });
                        $(this).parent().css({
                            'border': ' 2px solid #208440'
                        });
                        $(this).parent().parent().find('.error').hide();
                    }
                });
            });
        });
    </script>
    <script>
        function PreviewDetails(){
            $.ajax({
            type: "GET",
            url: "{{route('become-a-partner.preview-details')}}",
            success: function(response) {
                if(response){
                    $('.add-preview-details-html').html(response);
                    $('#preview-details').modal('show');
                }
            }
        });
        }
    </script>
      {{-- model Preview Details --}}
      <div class="modal fade" id="preview-details" tabindex="-1" role="dialog" aria-labelledby="preview-details" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Preview Details</h5>
                </div>
                <div class="modal-body add-preview-details-html">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" onclick="$('#preview-details').modal('hide');">Close</button>
                </div>
            </div>
        </div>
    </div>
@endsection
