@php
$meta_title = 'Aurobees | Subscription';
$meta_description = '';
$meta_keywords = '';
$add_class_header='show-nav';
$footer_sign_up_for_free_trial=true;
$active_page='customer-subscription';
@endphp
@extends('frontend.user.includes.master')
@section('body')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
<div class="dashboard_bg">
    <section class="usr_dashboard_user">
        <div class="container">
            <div class="row">
                <div class="col-md-3"></div>
                <div class="col-md-9">
                    <div class="usr_dashboard_title">
                        <h1>Subscriptions</h1>
                        <div class="d-flex">
                            <div class="log_out_btn">
                                <a href="javascript:void(0);" onclick="$('#logout-form').submit();">Log Out</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    @include('frontend.customer.includes.body.sidebar')
                </div>
                <div class="col-md-9">
                    <div class="scroll_screen">
                        <div class="dashboard_right ">
                            <div class="data_table_wrap">
                                <table id="DataTable" class="table table-striped nowrap">
                                    <thead>
                                        <tr>
                                            <th>Sr No.</th>
                                            <th>Subscriptions BOB Type</th>
                                            <th>Subscriptions Type</th>
                                            <th>Subscriptions Plan</th>
                                            <th>No of Users</th>
                                            <th>Email</th>
                                            <th colspan="2">Subscription</th>
                                            <th>Subscription Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if($datas)
                                        @foreach ($datas as $key => $data)
                                        <tr>
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $data['Pricing']['LOB']['title'] }}</td>
                                            <td><?= @$data->plan_name ?></td>
                                            @php if($data->plan_duration=='YLY'){ $plan_duration=365; }elseif($data->plan_duration=='QTR'){ $plan_duration=90; }elseif($data->plan_duration=='MTH'){ $plan_duration=30; }else{ $plan_duration=15; } @endphp
                                            <td><?=$plan_duration?> Days</td>
                                            <td><?=(@$data->plan_name=='Ecommerce')?1:@$data->quantity ?></td>
                                            @php $email=''; @endphp
                                            @if($data['OrderMeta'])
                                                @foreach ($data['OrderMeta'] as $item)
                                                    @if($item->key=='email')
                                                        @php $email=$item->value; @endphp
                                                        @break
                                                    @endif
                                                @endforeach
                                            @endif
                                            <td>{{$email}}</td>
                                            <td>{{ $data->start_at }}</td>
                                            <td>{{ $data->end_at }}</td>
                                            <td>
                                                <?php $currentDate=date('Y-m-d H:i:s'); echo ($data->status=='Active' && $data->end_at<$currentDate)?'Expired':@$data->status ?>
                                                <?php $featureDate= date('Y-m-d H:i:s', strtotime($currentDate. ' + '.$subscription_upgrade_days .'days')); ?>
                                                @if ($data->upgrade_status =='0' && $data->plan_name=='Free-Trial')
                                                    <p>If you want to upgrade to paid version, Kindly <a href="javascript:void(0);" onclick="subscriptionUpgrade('{{Crypt::encrypt($data->id)}}');">Upgrade now</a></p>
                                                @elseif($featureDate>=$data->end_at && $data->upgrade_status =='0' && $data->status=='Active' && $data->plan_name!='Free-Trial')
                                                    <p>
                                                        <?=($data->status=='Active' && $data->end_at<$currentDate)?'If you want to paid version, Kindly ':''?>
                                                        <a href="javascript:void(0);" onclick="subscriptionPay('{{Crypt::encrypt($data->id)}}');">Pay now</a>
                                                    </p>
                                                @elseif($data->payment_mode=='auropay' && $data->status=='Pending')
                                                    <a href="{{route('customer.subscription.payment.auropay',Crypt::encrypt($data->id))}}">Pay now</a>
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('frontend.customer.includes.body.help-center-mobile')
        </div>
    </section>
</div>
{{-- model subscription upgrade --}}
<div class="modal fade" id="subscription-upgrade" tabindex="-1" role="dialog" aria-labelledby="subscription-upgrade"
    aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body add-subscription-upgrade-html">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary"
                    onclick="$('#subscription-upgrade').modal('hide');">Close</button>
            </div>
        </div>
    </div>
</div>
{{-- model --}}
<div class="modal fade" id="subscription-pay" tabindex="-1" role="dialog" aria-labelledby="subscription-pay" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered " role="document">
        <div class="modal-content">
            <div class="modal-header"></div>
            <div class="modal-body add-subscription-pay-html">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="$('#subscription-pay').modal('hide');">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script>
    window.addEventListener('load', function () {
        @if (Session:: has('message'))
    AlertMassage(`<?= Session::get('message') ?>`);
    @endif
    });
</script>
<script>
    $(document).ready(function () {
        $('.data_table_wrap .dataTables_wrapper table').wrap('<div class="scroll_table" />');
        setTimeout(() => {
            $('select[name="DataTable_length"]').change().val(10)
        }, 1000);
    });
    new DataTable('#DataTable');
    function subscriptionUpgrade(token) {
        $.ajax({
            type: "GET",
            url: "{{route('customer.subscription.upgrade')}}",
            data: { 'token': token },
            success: function (response) {
                if (response) {
                    $('.add-subscription-upgrade-html').html(response);
                    $('#subscription-upgrade').modal('show');
                } else {
                    AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);
                }
            },
            error: function (xhr, status, error) {
                AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);
            }
        });
    }
    function subscriptionPay(token) {
        $.ajax({
            type: "GET",
            url: "{{route('customer.subscription.pay.popup')}}",
            data: { 'token': token },
            success: function (response) {
                if (response) {
                    $('.add-subscription-pay-html').html(response);
                    $('#subscription-pay').modal('show');
                } else {
                    AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);
                }
            },
            error: function (xhr, status, error) {
                AlertMassage(`{{ \App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong') }}`);
            }
        });
    }
     
</script>
@endsection
