@php
$meta_keywords = 'Aurobees | Forget Password';
$meta_description = 'Aurobees | Forget Password';
$meta_keywords = 'Aurobees | Forget Password';
@endphp
@extends('frontend.new_user.includes.master')
@section('body')

    <style>
        .form_wrap {
            max-width: 1500px;
            padding: 60px 0px;
        }
        @media only screen and (max-width: 1600px) {
          .form_wrap {
            padding: 30px 0px;
          }
    </style>
    <section class="form_wrap">
        <div class="row g-0">
            <div class="col-md-7">
                <div class="screen_video">
                    <div class="video_grid">
                        @php $change_password_thumbnail_image = HelperServiceProvider::ForgotPasswordPageManagement('change_password_thumbnail_image'); @endphp
                        @php $change_password_video = HelperServiceProvider::ForgotPasswordPageManagement('change_password_video'); @endphp
                        @if($change_password_thumbnail_image && $change_password_video)
                          <video id="myVideo" poster="{{url($change_password_thumbnail_image)}}">
                              <source src="{{url($change_password_video)}}" type="video/mp4">
                          </video>
                          <div class="content">
                              <button id="myBtn" onclick="myFunction()"><i class="fas fa-play"></i></button>
                          </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="col-md-5 otp_screen">
                <div class="login_grid forgot_password">
                    <div class="form_title">
                        <h1>{{ HelperServiceProvider::GetLanguageText('change_password')}}</h1>
                    </div>

                    <div class="form_tabs ">
                        <div class="tab-content">
                            <div class="tab-pane fade show active" role="tabpanel">
                                <form name="customer_registration" id="customer_registration" method="post" autocomplete="off" action="{{route('change-password.store')}}">
                                    @csrf
                                    <div class="form_group">
                                        <div class="form_feild">
                                            <input type="password" placeholder="{{ HelperServiceProvider::GetLanguageText('password')}}" value="{{old('password')}}" name="password" id="password">
                                            <span class="password-toggle" onclick="togglePasswordVisibility()">
                                                <i id="eyeIcon" class="fa fa-eye"></i>
                                            </span>
                                            <div id="password-strength-status"></div>
                                            @error('password')
                                                <span class="text-danger error-password">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form_group">
                                        <div class="form_feild">
                                            <input type="password" placeholder="{{ HelperServiceProvider::GetLanguageText('confirm_password')}}" value="{{old('password_confirmation')}}" name="password_confirmation" id="password_confirmation" onpaste="return false;">
                                            <span class="password-toggle" onclick="togglePasswordVisibility1()">
                                                <i id="eyeIcon1" class="fa fa-eye"></i>
                                            </span>
                                            <div id="password_confirmation-strength-status"></div>
                                            @error('password_confirmation')
                                                <span class="text-danger error-password-confirmation">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form_feild">
                                        <div class="btn_grid">
                                            <div class="form_feild">
                                                <input type="submit" id="submit_button" value="{{ HelperServiceProvider::GetLanguageText('submit')}}">
                                            </div>
                                            <div class="form_feild">
                                                <button class="clear" onclick="document.getElementById('customer_registration').reset();">{{ HelperServiceProvider::GetLanguageText('clear_all')}}</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('script')
<script>


jQuery(function() {
  // Add custom password validation method
  jQuery.validator.addMethod("password", function(value, element) {
    let password = value;
    if (!(/^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[@#$%&])(.{8,14}$)/.test(password))) {
      return false;
    }
    return true;
  }, function(value, element) {
    let password = $(element).val();
    if (!(/^(.{8,14}$)/.test(password))) {
      return 'Password must be between 8 to 14 characters long.';
    } else if (!(/^(?=.*[A-Z])/.test(password))) {
      return 'Password must contain at least one uppercase letter.';
    } else if (!(/^(?=.*[a-z])/.test(password))) {
      return 'Password must contain at least one lowercase letter.';
    } else if (!(/^(?=.*[0-9])/.test(password))) {
      return 'Password must contain at least one digit.';
    } else if (!(/^(?=.*[@#$%&])/.test(password))) {
      return 'Password must contain at least one special character from @#$%&.';
    }
    return false;
  });

  jQuery("form[name='customer_registration']").validate({
    rules: {
      password: {
        required: true,
        minlength: 8,
        maxlength:13,
        password: true // Use the custom password validation method
      },
      password_confirmation: {
        required: true,
        minlength: 8,
        maxlength:13,
        equalTo: "#password"
      }
    },
    // Specify validation error messages
    messages: {
      password: {
        required: "Please provide a password",
        minlength: "Your password must be at least 8 characters long",
        maxlength: "Password must be between 8 to 12 characters long."
      },
      password_confirmation: {
        required: "Please provide a password",
        minlength: "Your password must be at least 8 characters long",
        maxlength: "Password must be between 8 to 12 characters long.",
        equalTo: "Password and Confirm Password must be the same"
      }
    },
    submitHandler: function(form) {
      form.submit();
    }
  });
});











  function togglePasswordVisibility() {
    const passwordField = document.getElementById("password");
    const eyeIcon = document.getElementById("eyeIcon");

    if (passwordField.type === "password") {
      passwordField.type = "text";
      eyeIcon.classList.remove("fa-eye");
      eyeIcon.classList.add("fa-eye-slash");
    } else {
      passwordField.type = "password";
      eyeIcon.classList.remove("fa-eye-slash");
      eyeIcon.classList.add("fa-eye");
    }
  }

  function togglePasswordVisibility1() {
    const passwordField = document.getElementById("password_confirmation");
    const eyeIcon = document.getElementById("eyeIcon1");

    if (passwordField.type === "password") {
      passwordField.type = "text";
      eyeIcon.classList.remove("fa-eye");
      eyeIcon.classList.add("fa-eye-slash");
    } else {
      passwordField.type = "password";
      eyeIcon.classList.remove("fa-eye-slash");
      eyeIcon.classList.add("fa-eye");
    }
  }
  jQuery(document).on('keypress', '#password', function(event) {
        jQuery('.error-password').hide();
        jQuery('.error-password-confirmation').hide();
        var phone_no=$('#password').val();
        if(phone_no.length>14){
            return false;
        }
    });
  jQuery(document).on('keypress', '#password_confirmation', function(event) {
        jQuery('.error-password').hide();
        jQuery('.error-password-confirmation').hide();
        var phone_no=$('#password_confirmation').val();
        if(phone_no.length>14){
            return false;
        }
    });
</script>
@endsection

