@php
$meta_keywords = 'Aurobees | Login';
$meta_description = 'Aurobees | Login';
$meta_keywords = 'Aurobees | Login';
@endphp
@extends('frontend.new_user.includes.master')
@section('body')

<style>
    .form_wrap {
        padding: 60px 0px;
        max-width: 1500px;
    }
    .global_content .modal-dialog {
	    max-width: 340px;
    }
    .global_content .modal-body {
    	height: auto !important;
    	min-height: 250px !important;
    }
    .global_content .modal-content .modal-body {
        height: auto !important;
        min-height: auto !important;
    }
    @media only screen and (max-width: 1600px) {
        .global_content .modal-content {
            height: auto !important;
    	    min-height: 250px !important;
        }
    }
    
    
</style>

<script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <section class="form_wrap">
        <div class="row g-0 login_sec">
            <div class="col-md-6">
                <div class="login_bg">
                    <img src="{{url('frontend/images/login_bg.png')}}" alt="login_bg">
                </div>
            </div>
            <div class="col-md-6">
                <div class="login_grid">
                    <div class="form_title">
                        <h1>{{ HelperServiceProvider::GetLanguageText('login')}}</h1>
                    </div>
                    <form method="POST" name="customer_registration" id="customer_registration" action="{{ route('login-test') }}">
                        @csrf
                        <div class="form_tabs">
                            <!-- <ul class="nav nav-pills" role="tablist">
                                <li><button class="nav-link active" data-bs-toggle="pill" data-bs-target="#User" type="button" role="tab">{{ HelperServiceProvider::GetLanguageText('user')}}</button> </li>
                                <li><button class="nav-link" data-bs-toggle="pill" data-bs-target="#Partner" type="button" role="tab">{{ HelperServiceProvider::GetLanguageText('partner')}}</button></li>
                            </ul> -->
                            <div class="tab-content">
                                <div class="tab-pane fade show active"  role="tabpanel">
                                    <div class="form_feild">
                                        <input type="email" name="email" id="email" @if(Cookie::get('aurobees_email')) value="{{Cookie::get('aurobees_email')}}" @endif placeholder="example@domain.com">
                                        @error('email')
                                            <span class="text-danger">
                                                @if ($message=='These credentials do not match our records.')
                                                    {{ HelperServiceProvider::ChangeLanguage('Wrong email or password, Kindly try again.') }}
                                                @else
                                                    {{ HelperServiceProvider::ChangeLanguage($message) }}
                                                @endif
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form_feild">
                                        <input type="password" placeholder="**********" name="password" @if(Cookie::get('aurobees_password')) value="{{Cookie::get('aurobees_password')}}" @endif id="password">
                                        <span class="password-toggle" onclick="togglePasswordVisibility()">
                                            <i id="eyeIcon" class="fa fa-eye"></i>
                                        </span>
                                        @error('password')
                                            <span class="text-danger">{{ HelperServiceProvider::ChangeLanguage($message) }}</span>
                                        @enderror
                                    </div>
                                    <div class="form_feild">
                                        <div class="g-recaptcha" data-sitekey="<?=env("RECAPTCHA","6Lfd62QlAAAAAH-Fqd6ec9hH4apRfEN-VR1AbQ0l")?>"></div>
                                        <div class="text-danger recaptcha-show-error"> Please click recaptcha</div>
                                    </div>
                                    <div class="form_feild remember-div">
                                        <div class="row">
                                            <div class="col-6">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="remember" name="remember">
                                                    <label class="form-check-label" for="remember">{{ HelperServiceProvider::GetLanguageText('remember_me')}}</label>
                                                </div>
                                            </div>
                                            <div class="col-6">
                                                <label for=""><a href="{{route('forget.password.get')}}">{{ HelperServiceProvider::GetLanguageText('forgot_password?')}}</a></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form_feild">
                                        <input type="submit" value="{{ HelperServiceProvider::GetLanguageText('login')}}">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form_footer">
                            <div class="row">
                                <div class="col-sm-6">
                                    <p class="text-left"><a href="{{route('customer.create')}}">{{ HelperServiceProvider::GetLanguageText('sign_up_as_user')}}</a></p>
                                </div>
                                <div class="col-sm-6">
                                    <p class="text-right"><a href="{{route('become-a-partner.index')}}">{{ HelperServiceProvider::GetLanguageText('sign_up_as_partner')}}</a></p>
                                </div>
                                <div class="col-md-12">
                                    <p class="text-left"> <strong>{{ HelperServiceProvider::GetLanguageText('email_not_validated')}} </strong> <a href="{{route('resend.otp')}}">{{ HelperServiceProvider::GetLanguageText('validate_email')}}</a></p>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('script')
<script>
    window.addEventListener('load', function() {
        @if (session('status'))
            AlertMassage(`<?= session('status') ?>`);
        @endif
        @if (Session::has('message'))
            AlertMassage(`<?= Session::get('message') ?>`);
        @endif
    });
</script>
<script>
    $('.recaptcha-show-error').hide();
    window.onload = function() {
        var recaptcha = document.querySelector('#g-recaptcha-response');
        if(recaptcha) {
            $('#g-recaptcha-response').attr("required", "required");
        }
    }
</script>
<script>
    jQuery(function() {
        // Custom validation method for checking email format
        $.validator.addMethod("customEmail", function(value, element) {
            return this.optional(element) || /^[a-zA-Z0-9_.-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/i.test(value);
        }, "Please enter a valid email address.");
      jQuery("form[name='customer_registration']").validate({
        rules: {
          email: {
            required: true,
            email: true,
            customEmail: true
          },
          password: {
            required: true,
            minlength: 8
          }
        },
        // Specify validation error messages
        messages: {
          password: {
            required: "Please provide a password",
            minlength: "Password must be between 8 to 12 characters long."
          },
          email: "Please enter a valid business email address"
        },
        submitHandler: function(form) {
            if(grecaptcha.getResponse()){
                form.submit();
            }else{
                $('.recaptcha-show-error').show();
                $('.recaptcha-show-error').delay(5000).hide(0);
            }
        }
      });
    });
     //email
     jQuery(document).on('keypress', '#email', function(event) {
        $(".text-danger").hide();
        var regex = new RegExp("^[a-zA-Z.0-9.@]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        $('.text-danger').hide();
        if (!regex.test(key) && event.which !== 13) {
            event.preventDefault();
            return false;
        }
    });
    function togglePasswordVisibility() {
        const passwordField = document.getElementById("password");
        const eyeIcon = document.getElementById("eyeIcon");

        if (passwordField.type === "password") {
            passwordField.type = "text";
            eyeIcon.classList.remove("fa-eye");
            eyeIcon.classList.add("fa-eye-slash");
        } else {
            passwordField.type = "password";
            eyeIcon.classList.remove("fa-eye-slash");
            eyeIcon.classList.add("fa-eye");
        }
    }

</script>
@endsection
