@php
$meta_keywords = 'Aurobees | OTP';
$meta_description = 'Aurobees | OTP';
$meta_keywords = 'Aurobees | OTP';
@endphp
@extends('frontend.new_user.includes.master')
@section('body')

<style>
    .form_wrap {
        padding: 60px 0px;
        max-width: 1500px;
    }
    .global_content .modal-dialog {
	    max-width: 340px;
    }
    .global_content .modal-body {
    	height: auto !important;
    	min-height: 250px !important;
    }
    .global_content .modal-content .modal-body {
        height: auto !important;
        min-height: auto !important;
    }
    @media only screen and (max-width: 1600px) {
        .global_content .modal-content {
            height: auto !important;
    	    min-height: 250px !important;
        }
    }
    
    
</style>


    <section class="form_wrap">

        <div class="row g-0">
            <div class="col-md-7">
                <div class="screen_video">
                    <div class="video_grid">
                        @php $otp_thumbnail_image = HelperServiceProvider::ForgotPasswordPageManagement('otp_thumbnail_image'); @endphp
                        @php $otp_video = HelperServiceProvider::ForgotPasswordPageManagement('otp_video'); @endphp
                        @if($otp_thumbnail_image && $otp_video)
                          <video id="myVideo" poster="{{url($otp_thumbnail_image)}}">
                              <source src="{{url($otp_video)}}" type="video/mp4">
                          </video>
                          <div class="content">
                              <button id="myBtn" onclick="myFunction()"><i class="fas fa-play"></i></button>
                          </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="col-md-5 otp_screen">

                <form name="customer_registration" id="customer_registration" method="POST" autocomplete="off" action="{{route('forget-password.otp')}}">
                    @csrf
                    <input type="hidden" name="token" id="token" value="{{$token}}">
                    <input type="hidden" name="email" id="email" value="{{$email}}">
                    <div class="login_grid">
                        <div class="form_title">
                            <h1>{{ HelperServiceProvider::GetLanguageText('otp_verification')}}</h1>
                        </div>
                        <div class="otp_input">
                            <input type="text" name="otp" id="otp" placeholder="">
                        </div>
                        <div class="email_title">
                            <p>{{ HelperServiceProvider::GetLanguageText('enter_the_otp_shared_over_registered_email_id')}}</p>
                        </div>

                        <div class="submit__query">
                            <button type="submit" class="btn_query" >{{ HelperServiceProvider::GetLanguageText('submit')}}</button>
                            <button class="btn_query" type="button" id="request_new_otp" >{{ HelperServiceProvider::GetLanguageText('request_new_otp')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
@endsection
@section('script')
<script>
    window.addEventListener('load', function() {
        @if (Session::has('message'))
            AlertMassage(`<?= Session::get('message') ?>`);
        @endif
        @if (Session::has('message1'))
            AlertMassage(`<?= Session::get('message1') ?>`);
        @endif
        @if (@$successmessage)
            AlertMassage(`<?= @$successmessage ?>`);
        @endif
        @if (@$message)
            AlertMassage(`<?= @$message ?>`);
        @endif
    });
</script>
<script>
    jQuery(function() {
      jQuery("form[name='customer_registration']").validate({
        rules: {
            otp: {
                required:true,
                digits:true,
                minlength: 5
          }
        },
        // Specify validation error messages
        messages: {
            otp: "Please enter otp"
        },
        submitHandler: function(form) {
          form.submit();
        }
      });
    });

    jQuery(document).on('keypress', '#otp', function(event) {
        var regex = new RegExp("^[0-9]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
        var phone_no=$('#otp').val();
        if(phone_no.length>=5){
            return false;
        }
    });

    jQuery(document).on('click','#request_new_otp',function(){
        $('#modal-loader').modal('show');
        $.ajax({
            type: 'post',
            url: "{{route('forget.password.post.ajax')}}",
            data:{
                email:"{{$email}}",
                _token:$("[name='_token']").val()
            },
            success: function (data) {
                if(data['token'] && data['email']){
                    $('#token').val(data['token']);
                    $('#email').val(data['email']);
                    $('#modal-loader').modal('hide');
                    $('#otp_sent').modal('show');
                }else{
                    location.reload();
                }
            }
        });
    });

</script>
@endsection
