<?php
$footer_sign_up_for_free_trial=true;
$add_class_header='show-nav';
?>

<?php $__env->startSection('body'); ?>
<?php
function limitSentence($sentence, $wordLimit) {
    $words = explode(" ", $sentence);
    if (count($words) > $wordLimit) {
        $limitedWords = array_slice($words, 0, $wordLimit);
        $limitedSentence = implode(" ", $limitedWords) . "...";
    } else {
        $limitedSentence = $sentence;
    }
    return $limitedSentence;
}
?>
<?php if($datas): ?>
    <section class="blog_section">
        <div class="container">
            <div class="blog_heading">
                <h1><?php echo e(HelperServiceProvider::GetLanguageText('all_blogs')); ?></h1>
                <input type="hidden" value="<?php echo e($countPost); ?>" id="no_of_post">
            </div>
            <div class="blog_crum">
                <ul class="nav_list <?=(@$_GET['order']!='asc')?'active':''?>">
                    <li><a href="<?php echo e(route('post.page.list')); ?>?order=desc"><?php echo e(HelperServiceProvider::GetLanguageText('newest')); ?> <img src="<?php echo e(asset('frontend/images/green_arrow.png')); ?>" alt="arrow_icons"></a></li>
                </ul>
                <ul class="nav_list <?=(@$_GET['order']=='asc')?'active':''?>">
                    <li><a href="<?php echo e(route('post.page.list')); ?>?order=asc"><?php echo e(HelperServiceProvider::GetLanguageText('oldest')); ?> <img src="<?php echo e(asset('frontend/images/green_arrow.png')); ?>" alt="arrow_icons"></a></li>
                </ul>
            </div>
            <div class="row all_blog_wrap">
                <div class="col-md-9">
                    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="outer_shadow">
                            <div class="blog__wrap">
                                <div class="full_blog_img">
                                    <?php if($post->media_type=='Image' && $post->image): ?>
                                        <?php if($post->language!='en' && $post->default_language_page && @$post['DefaultLanguagePage']['post_slug']): ?>
                                            <a href="<?php echo e(route('post.page.single',$post['DefaultLanguagePage']['post_slug'])); ?>">
                                        <?php elseif($post->post_slug): ?>
                                            <a href="<?php echo e(route('post.page.single',$post->post_slug)); ?>">
                                        <?php else: ?>
                                            <a href="">
                                        <?php endif; ?>
                                            <img src="<?php echo e(url($post->image)); ?>"  alt="<?php echo e($post->post_title); ?>" title="<?php echo e($post->post_title); ?>">
                                        </a>
                                    <?php elseif($post->media_type=='Video'): ?>
                                        <?php if($post->video_type=='MP4' && $post->video): ?>
                                            <video width="100%" height="100%" autoplay muted loop>
                                                <source src="<?php echo e(url($post->video)); ?>" type="video/mp4">
                                            </video>
                                        <?php elseif($post->video_type=='Youtube' && $post->youtube): ?>
                                            <iframe width="100%" height="100%" src="<?php echo e($post->youtube); ?>"></iframe>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                                <div class="full_blog_content">
                                    <h2>
                                        <?php if($post->language !='en' && $post->default_language_page && @$post['DefaultLanguagePage']['post_slug']): ?>
                                            <a href="<?php echo e(route('post.page.single',$post['DefaultLanguagePage']['post_slug'])); ?>">
                                        <?php elseif($post->post_slug): ?>
                                            <a href="<?php echo e(route('post.page.single',$post->post_slug)); ?>">
                                        <?php else: ?>
                                            <a href="">
                                        <?php endif; ?>
                                            <?php echo e($post->post_title); ?></a></h2>
                                    <p><?=limitSentence(@$post->post_content,20);?></p>
                                    <div class="post_bottom">
                                        <div class="blog_views">
                                            <a href="javascript:void(0);"><img src="<?php echo e(asset('frontend/images/eyes-icon.png')); ?>" alt="img"> <?php echo e($post->total_post_view); ?> views</a>
                                        </div>
                                        <div class="read_post">
                                            <?php $word_count= str_word_count(@$post->post_content);
                                                $time=ceil($word_count/100);
                                                echo $time." min read";
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php break; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="col-md-3">
                    <div class="related_article" id="related_article">
                        <div class="article_title">
                            <h2><?php echo e(HelperServiceProvider::GetLanguageText('related_articles')); ?></h2>
                        </div>
                        <?php $i=0; ?>
                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $i++; ?>
                            <?php if($i==1): ?> <?php continue; ?>; <?php endif; ?>
                            <div class="article_content">
                                <div class="date__title">
                                    <?=date('F d, Y',strtotime($post->created_at))?>
                                </div>
                                <h4>
                                    <?php if($post->language !='en' && $post->default_language_page && @$post['DefaultLanguagePage']['post_slug']): ?>
                                        <a href="<?php echo e(route('post.page.single',$post['DefaultLanguagePage']['post_slug'])); ?>">
                                    <?php elseif($post->post_slug): ?>
                                        <a href="<?php echo e(route('post.page.single',$post->post_slug)); ?>">
                                    <?php else: ?>
                                        <a href="">
                                    <?php endif; ?>
                                        <?php echo e($post->post_title); ?></a></h4>
                                <p><?=limitSentence(@$post->post_content,20);?></p>
                            </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php if($countPost>10){ ?>
                        <div class="load_more">
                            <a href="javascript:void(0)" id="loadMore" onClick="LoadMorePost()"><?php echo e(HelperServiceProvider::GetLanguageText('load_more')); ?></a>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
function LoadMorePost(){
    var dataShowDiv=$(".article_content").length +1;
    var no_of_post=$('#no_of_post').val();
    if(dataShowDiv<no_of_post){
        $.ajax({
            url: "<?php echo e(route('post-data-load')); ?>",
            type: "POST",
            data: { _token : "<?php echo csrf_token() ?>", no_of_row: dataShowDiv, order:'<?=@$_GET['order']?>' },
            async: false,
            success: function(response) {
                if(response){
                    response.map((data) => {
                        var appenddata = `<div class="article_content">
                            <div class="date__title">
                                ${data.date}
                            </div>
                            <h4><a href="${data.link}">${data.title}</a></h4>
                            <p>${data.description}</p>
                        </div>`;
                        $('#related_article').append(appenddata);
                    });
                    var dataShowDiv=$(".article_content").length+1;
                    if(dataShowDiv>=no_of_post){
                        $('.load_more').hide();
                    }
                }else{
                    $('.load_more').hide();
                }
            }
        });
    }else{
        $('.load_more').hide();
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.user.includes.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/projectsdemo/public_html/aurobees/resources/views/frontend/user/post/list.blade.php ENDPATH**/ ?>