<div class="tab-pane fade" id="Documents" role="tabpanel">
    <div class="form_content_inner">
        <form name="customer_document" id="customer_document" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="edit_form">
                <a href="javascript:void(0);" class="edit-button-documents">Edit</a>
            </div>
            <div class="form_group singapore_document india_document all_document">
                <label>GST Number</label>
                <div class="form_feild">
                    <input type="text" class="edit-field-documents" name='gst_number' id="gst_number" value="<?php echo e(@$data->gst_number); ?>">
                </div>
            </div>
            <div class="form_group india_document all_document">
                <label for="">Pan Card Number</label>
                <div class="form_feild">
                    <input type="text" class="edit-field-documents" name='pan_number' id="pan_number" value="<?php echo e(@$data->pan_number); ?>">
                </div>
            </div>
            <div class="form_group uae_document all_document">
                <label>TRN Number</label>
                <div class="form_feild">
                    <input type="text" class="edit-field-documents" name='trn_number' id="trn_number" value="<?php echo e(@$data->trn_number); ?>">
                </div>
            </div>
            <div class="form_group singapore_document all_document">
                <label>ACRA Number</label>
                <div class="form_feild">
                    <input type="text" class="edit-field-documents" name='acra_number' id="acra_number" value="<?php echo e(@$data->acra_number); ?>">
                </div>
            </div>
            <div class="form_group indonesia_document all_document">
                <label for="">NPWP Number</label>
                <div class="form_feild indonesia_document uae_document all_document">
                    <input type="text" class="edit-field-documents" name='npwp_number' id="npwp_number" value="<?php echo e(@$data->npwp_number); ?>">
                </div>
            </div>
            <div class="form_group indonesia_document uae_document all_document">
                <label for="">Tax Registration Number</label>
                <div class="form_feild indonesia_document uae_document all_document">
                    <input type="text" class="edit-field-documents" name='tax_registration_number' id="tax_registration_number" value="<?php echo e(@$data->tax_registration_number); ?>">
                </div>
            </div>

            <div class="form_group other_document all_document">
                <label>Company Registration Number</label>
                <div class="form_feild">
                    <input type="text" class="form-control edit-field-documents" name='company_registration_number' id="company_registration_number" value="<?php echo e(@$data->company_registration_number); ?>">
                </div>
            </div>
            <div class="form_group  singapore_document all_document">
                <label>ACRA Profile Copy</label>
                <div class="form_feild">
                    <label class="filelabel">
                        <span class="title">+Attach</span>
                        <img src="<?php echo e(url('frontend/images/attachment-icon.png')); ?>" alt="img">
                        <input type="file" name="acra_profile_copy" accept="image/jpeg, image/png, image/jpg, image/gif, application/pdf" id="FileInput1" class="FileUpload1 edit-field-documents" />
                    </label>
                </div>
                <div class="col-3 acra_profile_copy_download" >
                    <?php if(@$data->acra_profile_copy): ?>
                        <a href="<?php echo e(route('home').'/'.@$data->acra_profile_copy); ?>" download="ACRA Profile Copy">ACRA Profile Copy</a>
                    <?php endif; ?>
                </div>
                <div class="col-3 acra_profile_copy_view" >
                    <?php if(@$data->acra_profile_copy): ?>
                        <a href="<?php echo e(route('home').'/'.@$data->acra_profile_copy); ?>" target="_blank">View</a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="form_group  indonesia_document uae_document all_document">
                <label>Tax Registration Document</label>
                <div class="form_feild">
                    <label class="filelabel">
                        <span class="title">+Attach</span>
                        <img src="<?php echo e(url('frontend/images/attachment-icon.png')); ?>" alt="img">
                        <input type="file" name="tax_registration_document" accept="image/jpeg, image/png, image/jpg, image/gif, application/pdf" id="FileInput5" class="FileUpload1 edit-field-documents" />
                    </label>
                </div>
                <div class="col-3 tax_registration_document_download" >
                    <?php if(@$data->tax_registration_document): ?>
                        <a href="<?php echo e(route('home').'/'.@$data->tax_registration_document); ?>" download="ACRA Profile Copy">ACRA Profile Copy</a>
                    <?php endif; ?>
                </div>
                <div class="col-3 tax_registration_document_view" >
                    <?php if(@$data->tax_registration_document): ?>
                        <a href="<?php echo e(route('home').'/'.@$data->tax_registration_document); ?>" target="_blank">View</a>
                    <?php endif; ?>
                </div>
            </div>

            <div class="save_discard div-button-documents">
                <button type="button" class="discard_btn discard-button-documents" >Discard</button>
                <button type="button" class="save_btn save-button-documents" >Save</button>
            </div>
        </form>
    </div>
</div>

<script>
    var oldDocuments=$("form[name='customer_document']").serialize();

    function editFieldDocuments(status){
        $('.remove-row').html('');
        $('.document').val('');
        const editFields = document.querySelectorAll('.edit-field-documents');
        editFields.forEach((element) => {
            element.disabled = status;
        });
        if(status==false){
            $('.edit-button-documents').hide();
            $('.div-button-documents').show();
        }else{
            $('.edit-button-documents').show();
            $('.div-button-documents').hide();
        }
    }
    //default
    editFieldDocuments(true);
    //edit button
    $(document).on('click', '.edit-button-documents', function(){
        editFieldDocuments(false);
    });
    //discard button
    $(document).on('click', '.discard-button-documents', function(){
        editFieldDocuments(true);
        var params = new URLSearchParams(oldDocuments);

        // Set values for each form field using the extracted values
        setFieldValue("gst_number", params.get("gst_number"));
        setFieldValue("pan_number", params.get("pan_number"));
        setFieldValue("trn_number", params.get("trn_number"));
        setFieldValue("acra_number", params.get("acra_number"));
        setFieldValue("npwp_number", params.get("npwp_number"));
        setFieldValue("tax_registration_number", params.get("tax_registration_number"));
        setFieldValue("company_registration_number", params.get("company_registration_number"));
    });
    //append data
    function loadDocumentData(dataList){
        const url="<?php echo e(route('home')); ?>";
        console.log(dataList);
        if(dataList && dataList.acra_profile_copy){
            $('.acra_profile_copy_download').html(`<a href="${url+'/'+dataList.acra_profile_copy}" download="ACRA Profile Copy">ACRA Profile Copy</a>`);
            $('.acra_profile_copy_view').html(`<a href="${url+'/'+dataList.acra_profile_copy}" target="_blank">View</a>`);
        }else{
            $('.acra_profile_copy_download').html('');
            $('.acra_profile_copy_view').html('');
        }
        if(dataList  && dataList.tax_registration_document){
            $('.tax_registration_document_download').html(`<a href="${url+'/'+dataList.tax_registration_document}" download="Tax Registration Document">Tax Registration Document</a>`);
            $('.tax_registration_document_view').html(`<a href="${url+'/'+dataList.tax_registration_document}" target="_blank">View</a>`);
        }else{
            $('.tax_registration_document_download').html('');
            $('.tax_registration_document_view').html('');
        }
    }
    //store document
    $(document).on('click', '.save-button-documents', function(){
        var newDocuments=$("form[name='customer_document']").serialize();
        var  formDocument = $('#customer_document')[0];
        var formDocumentData = new FormData(formDocument); // Create a new FormData object with the form data.
        $.ajax({
            type: "POST",
            url: "<?php echo e(route('customer.profile.document.update')); ?>",
            data: formDocumentData,
            processData: false,
            contentType: false,
            success: function (response) {
                loadDocumentData(response.documentsList);
                oldDocuments=newDocuments;
                editFieldDocuments(true);
                AlertMassage(response.message);
                $('#documents-value').val(20);
                ProgressGraphStatus();
            },
            error: function (error) {
                AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong')); ?>`);
            }
        });
    });



    //document show country wise
    var select_billing_country=$('#billing_country').val();
    if(select_billing_country == 'IN'){
        $('.all_document').hide();
        $('.india_document').show();
    }else if(select_billing_country == 'SG'){
        $('.all_document').hide();
        $('.singapore_document').show();
    }else if(select_billing_country == 'AE'){
        $('.all_document').hide();
        $('.uae_document').show();
    }else if(select_billing_country == 'ID'){
        $('.all_document').hide();
        $('.indonesia_document').show();
    }else{
        $('.all_document').hide();
        $('.other_document').show();
    }
</script>
<?php /**PATH /home/projectsdemo/public_html/aurobees/resources/views/frontend/customer/profile/documents.blade.php ENDPATH**/ ?>