<div class="tab-pane fade" id="billing_information" role="tabpanel">
    <div class="form_content_inner">
        <form name='customer_billing-information'>
            <?php echo csrf_field(); ?>
            <div class="edit_form">
                <a href="javascript:void(0);" class="edit-button-billing-information">Edit</a>
            </div>
            <div class="form_group">
                <label for="">Registered Company Name<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" class="edit-field-billing-information" name='billing_company_name' id="billing_company_name" value="<?php echo e((@$data->billing_company_name)?@$data->billing_company_name:Auth::user()->company); ?>">
                </div>
            </div>
            <div class="form_group">
                <label for="">Company Code<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" class="form-control" disabled value="<?php echo e(Auth::user()->code); ?>">
                </div>
            </div>
            <div class="form_group">
                <label>Country<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <select name="billing_country" id="billing_country" class="country-select edit-field-billing-information">
                        <option value="">Select Country</option>
                        <?php $__currentLoopData = $country_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($country->code); ?>" <?php if((@$data->billing_country ==$country->code)): ?> selected <?php endif; ?> ><?php echo e($country->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="form_group billing-state-div" <?php if(@$data->billing_country && @$data->billing_country !=='IN'): ?> style="display:none" <?php endif; ?>>
                <label>State<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <select name="billing_state" class="country-select edit-field-billing-information" id="billing_state">
                        <option value="">Please Select State</option>
                        <?php $__currentLoopData = $state_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($state->code); ?>" <?php if(@$data->billing_state ==$state->code): ?> selected <?php endif; ?>><?php echo e($state->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="form_group">
                <label>City<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" class="edit-field-billing-information" name='billing_city' id="billing_city" value="<?php echo e(@$data->billing_city); ?>">
                </div>
            </div>
            <div class="form_group">
                <label>Address<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" class="edit-field-billing-information" name='billing_address' id="billing_address" value="<?php echo e(@$data->billing_address); ?>">
                </div>
            </div>
            <div class="form_group billing_pincode-div"  <?php if(@$data->billing_country && @$data->billing_country !=='IN'): ?> style="display:none" <?php endif; ?> >
                <label>Zipcode/Postalcode<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="number" class="edit-field-billing-information" name='billing_pincode' id="billing_pincode" value="<?php echo e(@$data->billing_pincode); ?>">
                </div>
            </div>
            <div class="form_group">
                <label>Email<span style="color: red;">*</span> </label>
                <div class="form_feild">
                    <input type="text" class="edit-field-billing-information" name='billing_email' id="billing_email" value="<?php echo e(@$data->billing_email); ?>">
                </div>
            </div>
            <div class="form_group">
                <label>Contact<span style="color: red;">*</span> </label>
                <div class="form_feild" style="width: unset;">
                    <input type="hidden" name="billing_calling_code" id="billing_calling_code" class="calling_code edit-field-billing-information" value="<?php echo e(@$data->billing_calling_code); ?>">
                    <input type="text" class="edit-field-billing-information" name='billing_phone' id="billing_phone" value="<?php echo e(@$data->billing_phone); ?>">
                </div>
            </div>
            <div class="save_discard div-button-billing-information">
                <button type="button" class="discard_btn discard-button-billing-information">DISCARD</button>
                <button type="submit" class="save_btn save-button-billing-information">SAVE</button>
            </div>
        </form>
    </div>
</div>
<script>
    $("document").ready(function () {
        // -----Country Code Selection
        $("#billing_phone").intlTelInput({
            initialCountry: "<?php echo e((@$data->billing_calling_code)?@$data->billing_calling_code:'auto'); ?>",
            separateDialCode: true,
        });
    });
    </script>
<script>
    var oldBillingInformation = $("form[name='customer_billing-information']").serialize();

    function editFieldBillingInformation(status) {
        const editFields = document.querySelectorAll('.edit-field-billing-information');
        editFields.forEach((element) => {
            element.disabled = status;
        });
        if (status == false) {
            $('.edit-button-billing-information').hide();
            $('.div-button-billing-information').show();
            $('#billing_company_name').focus();
        } else {
            $('.edit-button-billing-information').show();
            $('.div-button-billing-information').hide();
        }
    }
    //default
    editFieldBillingInformation(true);
    //edit button
    $(document).on('click', '.edit-button-billing-information', function() {
        editFieldBillingInformation(false);
    });
    //data submit
    jQuery(function() {
        $.validator.addMethod("billing_calling_code", function(value, element) {
            return (($('#billing_calling_code').val() && !value)||(!$('#billing_calling_code').val() && value))?false:true;
        }, "Please select Calling code.");
        jQuery("form[name='customer_billing-information']").validate({
            rules: {
                billing_company_name: {
                    required: true,
                    maxlength: 101,
                    minlength: 2
                },
                billing_country: "required",
                billing_state: {
                    required: function() {
                        if ($("#billing_country").val() == 'IN') {
                            return true;
                        }
                        return false;
                    }
                },
                billing_city: {
                    required: false,
                    minlength: 2,
                    maxlength: 51
                },
                billing_address: {
                    required: false,
                    minlength: 2,
                    maxlength: 101
                },
                billing_phone: {
                    billing_calling_code:true,
                    required: false,
                    digits: true
                },
                billing_pincode: {
                    required:function() {
                        if($("#billing_country").val()=='AE'){
                            return false;
                        }
                        return true;
                    },
                    digits: true
                }
            },
            // Specify validation error messages
            messages: {
                billing_company_name: {
                    required: "Please enter registered company name",
                    maxlength: "Registered company name must be less then 100 characters long.",
                    minlength: "Registered company name must be greater then 2 characters long."
                },
                billing_country: "Please select country",
                billing_state: "Please select state",
                billing_city: {
                    required: "Please enter city name",
                    maxlength: "City name must be less then 50 characters long.",
                    minlength: "City name must be greater then 2 characters long."
                },
                billing_address: {
                    required: "Please enter address",
                    maxlength: "Address must be less then 50 characters long.",
                    minlength: "Address must be greater then 2 characters long."
                },
                billing_phone: {
                    // minlength: "Your alternate phone number must be at least 10 digits long",
                    minlength: $.validator.format("Your phone number must be at least {0} digits long."),
                    maxlength: "Your alternate phone number must be less or equal 15 digits long",
                    digits: "Alternate phone number must be digits."
                },
                billing_pincode: {
                    required: "Please enter Pincode/Zipcode",
                    minlength: "Pincode/Zipcode must be 6 digits long.",
                    maxlength: "Pincode/Zipcode must be 6 digits long.",
                    digits: "Pincode/Zipcode must be digits."
                }
            },
            submitHandler: function(form) {
                var formData = $("form[name='customer_billing-information']").serialize();
                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('customer.profile.billing-information.update')); ?>",
                    data: formData,
                    success: function(response) {
                        oldBillingInformation = formData;
                        editFieldBillingInformation(true);
                        AlertMassage(response.message);
                        $('#billing-information-value').val(20);
                        ProgressGraphStatus();
                    },
                    error: function(xhr, status, error) {
                        AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong')); ?>`);
                    }
                });
            }
        });
    });
    //discard button
    $(document).on('click', '.discard-button-billing-information', function() {
        var params = new URLSearchParams(oldBillingInformation);

        // Set values for each form field using the extracted values
        setFieldValue("billing_company_name", params.get("billing_company_name"));
        setFieldValue("billing_country", params.get("billing_country"));
        setFieldValue("billing_state", params.get("billing_state"));
        setFieldValue("billing_city", params.get("billing_city"));
        setFieldValue("billing_address", params.get("billing_address"));
        setFieldValue("billing_pincode", params.get("billing_pincode"));
        setFieldValue("billing_email", params.get("billing_email"));
        setFieldValue("billing_phone", params.get("billing_phone"));
        setFieldValue("billing_calling_code", params.get("billing_calling_code"));

        editFieldBillingInformation(true);
    });

    //state hide
    if ($('#billing_country').val() == 'IN') {
        $('.billing-state-div').show();
    } else {
        $('.billing-state-div').hide();
    }
    
    function callingCodeSelect(countryCode){
        var countryCode = countryCode.toLowerCase();
        $('#billing_information').find('li.iti__country').each(function() {
            let country_code=$(this).data('country-code');
            if(countryCode==country_code){
                let dial_code = $(this).data('dial-code');
                let country_name = $(this).find('.iti__country-name').html();

                $('#billing_calling_code').val(country_code);
                // Update selected dial code
                $('#billing_information').find('.iti__selected-dial-code').html('+' + dial_code);

                // Update selected flag title
                $('#billing_information').find('.iti__selected-flag').attr('title', country_name + ' +' + dial_code);

                // Remove previous classes and add new classes to the selected flag
                $('#billing_information').find('.iti__selected-flag .iti__flag').removeClass(function(index, className) {
                    return (className.match(/(^|\s)iti__\S+/g) || []).join(' ');
                }).addClass('iti__flag iti__' + country_code);
            }
        });
    }
    
    
    $('#billing_country').on('change', function() {
        if ($(this).val() == 'IN') {
            $('.billing-state-div').show();
        } else {
            $('.billing-state-div').hide();
        }
        if($(this).val()=='AE'){
            $('.billing_pincode-div').hide();
        }else{
            $('.billing_pincode-div').show();
        }

        if($(this).val() == 'IN'){
            $('.all_document').hide();
            $('.india_document').show();
        }else if($(this).val() == 'SG'){
            $('.all_document').hide();
            $('.singapore_document').show();
        }else if($(this).val() == 'AE'){
            $('.all_document').hide();
            $('.uae_document').show();
        }else if($(this).val() == 'ID'){
            $('.all_document').hide();
            $('.indonesia_document').show();
        }else{
            $('.all_document').hide();
            $('.other_document').show();
        }
        var select_billing_country=$(this).val();
        //------------------------------------------------------------------
        callingCodeSelect($(this).val());
        //------------------------------------------------------------------
    });
    
    <?php if(!@$data->billing_calling_code): ?>
        $(document).ready(function() {
            $('#billing_information .iti__selected-flag .iti__flag').addClass('dummy-flag-icon');
        });
    <?php endif; ?>
</script>
<?php /**PATH /home/projectsdemo/public_html/aurobees/resources/views/frontend/customer/profile/billing-information.blade.php ENDPATH**/ ?>