<?php
    $header_title = 'Aurobees  | Subscription';
    $header_name = 'lob_subscription_management';
    $page_name = 'lob_subscription';
?>

<?php $__env->startSection('admin'); ?>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Subscription</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Subscription</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">All Subscription</h3>
                            <div style="float: right"><a href="<?php echo e(route('lob.subscription.excel')); ?>" class="btn btn-primary btn-rounded">Download</a></div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body" style="overflow-x: scroll;">
                            <form style="display:none;" action="<?php echo e(route('lob.subscription.excel')); ?>">
                                <div class="row">
                                    <div class="col col-2">
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select name="subscription_status" onchange="changeFilter();" id="subscription_status" class="form-control">
                                                <option value="">All</option>
                                                <option value="Active">Active</option>
                                                <option value="Canceled">Canceled</option>
                                                <option value="Pending">Pending</option>
                                                <option value="Processing">Processing</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col col-2">
                                        <div class="form-group">
                                            <label>LOB</label>
                                            <select name="subscription_lob" onchange="changeFilter();" id="subscription_lob" class="form-control">
                                                <option value="">All</option>
                                                <option value="7">Distribution</option>
                                                <option value="4">E-commerce Fulfillment</option>
                                                <option value="2">Freight Forwarding</option>
                                                <option value="1">Manufacturing</option>
                                                <option value="5">Trading</option>
                                                <option value="3">Transportation</option>
                                                <option value="6">Warehousing</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col col-2">
                                        <div class="form-group">
                                            <label>Plan Name</label>
                                            <select name="subscription_plan_name" onchange="changeFilter();" id="subscription_plan_name" class="form-control">
                                                <option value="">All</option>
                                                <option value="Free-Trial">Free Trial</option>
                                                <option value="Basic">Basic</option>
                                                <option value="Advance">Advance</option>
                                                <option value="Ecommerce">E-commerce</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col col-2">
                                        <div class="form-group">
                                            <label>Plan Duration</label>
                                            <select name="subscription_plan_duration" onchange="changeFilter();" id="subscription_plan_duration" class="form-control">
                                                <option value="">All</option>
                                                <option value="15 days">15 days</option>
                                                <option value="QTR">QTR</option>
                                                <option value="MTH">MTH</option>
                                                <option value="YLY">YLY</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col col-2">
                                        <div class="form-group">
                                            <label>From Date</label>
                                            <input type="date" name="subscription_from_date" onchange="changeFilter();" id="subscription_from_date" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col col-2">
                                        <div class="form-group">
                                            <label>To Date</label>
                                            <input type="date" name="subscription_to_date" onchange="changeFilter();" id="subscription_to_date" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col col-2">
                                        <div class="form-group">
                                            <label>Partner Code</label>
                                            <input type="text" name="subscription_partner_code" onchange="changeFilter();" id="subscription_partner_code" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col col-2">
                                        <div class="form-group">
                                            <label>User Code</label>
                                            <input type="text" name="subscription_user_code" onchange="changeFilter();" id="subscription_user_code" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col col-2">
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary btn-rounded">Download</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            
                            <table id="daterange_table" class="table table-striped table-bordered table-sm " cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>User</th>
                                        <th>Partner Code</th>
                                        <th>Lob</th>
                                        <th>Serial Number</th>
                                        <th>Start Date</th>
                                        <th>End Date</th>
                                        <th>Status</th>
                                        <th>Country Code</th>
                                        <th>Plan Name</th>
                                        <th>Plan Duration</th>
                                        <th>Currency Code</th>
                                        <th>Rate</th>
                                        <th>No. of User</th>
                                        <th>Total Rate</th>
                                        <th>Tax</th>
                                        <th>Grand Amount</th>
                                        <th style="min-width: 120px;">Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>

<div class="modal fade show" id="modal-lob" aria-modal="true" role="dialog">
    <div class="modal-dialog modal-lg modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Edit Subscription</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">×</span>
          </button>
        </div>
        <div class="modal-body">
            <input type="hidden" name="model-id" id="model-id">
            <div class="form-group">
                <label>Status</label>
                <select name="model-status" id="status-select" class="form-control">
                    <option value="Active">Active</option>
                    <option value="Canceled">Canceled</option>
                    <option value="Processing">Processing</option>
                    <option value="Pending">Pending</option>
                </select>
            </div>
            <div class="form-group">
                <label>Remarks</label>
                <textarea name="remarks" id="model-remarks" class="form-control"></textarea>
            </div>
        </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
          <button type="button" id="lob-model-submit" class="btn btn-primary">Save changes</button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<div class="modal fade show" id="modal-lob-new" aria-modal="true" role="dialog">
    <div class="modal-dialog modal-lg modal-dialog-centered" id="modal-lob-new-main-box">
        
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    
    <script>
        // Function to update the modal form fields with the data
        function populateModalFields(id, status, remarks) {
            $('#model-id').val(id);
            $('#model-remarks').val(remarks);
            $('#status-select option[value="' + status + '"]').prop('selected', true);
            $('#modal-lob').modal('show');
        }

        // Event listener for the button click
        $('body').on('click', '.lob-subscription-model-button', function() {
            var id = $(this).data('id');
            var status = $(this).data('status');
            var remarks = $(this).data('remarks');
            populateModalFields(id, status, remarks);
        });

        $(document).on('click', '#lob-model-submit', function() {
            // $('#modal-loader').modal('show');
            let id = $('#model-id').val(); // Corrected selector
            let status = $('#status-select').val(); // Corrected selector
            let remarks = $('#model-remarks').val(); // Corrected selector
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('lob.subscription.edit.ajax')); ?>",
                data: {
                    _token: "<?php echo csrf_token() ?>",
                    id: id,
                    status: status,
                    remarks: remarks // Corrected assignment operator
                },
                async: false, // Make the request synchronous
                success: function(response) {
                    // $('#modal-loader').modal('hide');
                    var response_type=response['alert-type'];
                    // Handle the successful response
                    if (response_type == 'success') { // Use camelCase for property name
                        $('#modal-lob').modal('hide');
                        $('#model_' + id).data('status', status);
                        $('#model_' + id).data('remarks', remarks);
                        $('#model_' + id).closest('tr').find('.badge').text(status);
                        var badgesInClosestTr = $('#model_' + id).closest('tr').find('.badge');
                        badgesInClosestTr.removeClass();
                        if(status=='Active'){
                            badgesInClosestTr.addClass('badge badge-success');
                        }else if(status=='Pending' ||status=='Processing'){
                            badgesInClosestTr.addClass('badge badge-warning');
                        }else{
                            badgesInClosestTr.addClass('badge badge-danger');
                        }
                    }
                    AlertMessage(response);
                    changeFilter();
                },
                error: function(xhr, status, error) {
                    // Handle the error response
                    console.log(error);
                }
            });
        });

        $('#example').dataTable( {
            "autoWidth": false
        });
    </script>

    
    <script>
        $(document).ready(function () {
            $('#dtHorizontalVerticalExample').DataTable({
                "scrollX": true,
                "scrollY": 500,
            });
            $('.dataTables_length').addClass('bs-select');
        });
    </script>
    <script>
        
        var table;
        $(function () {
            table = $('#daterange_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "<?php echo e(route('lob.subscription.list')); ?>",
                    data : function(data){
                        data.subscription_status = $('#subscription_status').val();
                        data.subscription_lob = $('#subscription_lob').val();
                        data.subscription_plan_name = $('#subscription_plan_name').val();
                        data.subscription_plan_duration = $('#subscription_plan_duration').val();
                        data.subscription_from_date = $('#subscription_from_date').val();
                        data.subscription_to_date = $('#subscription_to_date').val();
                        data.subscription_partner_code = $('#subscription_partner_code').val();
                        data.subscription_user_code = $('#subscription_user_code').val();
                    }
                },
                columns: [
                    { data: 'DT_RowIndex', name: 'subscriptions.id', searchable: false },  // Row index (key + 1)
                    { data: 'name', name: 'users.f_name' },
                    { data: 'partner_code', name: 'users.partner_code' },
                    { data: 'industry_title', name: 'industries.title' },
                    { data: 'serial_number', name: 'subscriptions.serial_number' },

                    { data: 'start_at', name: 'subscriptions.start_at', render: function(data, type, row) {
                        return moment(data).format('H:mm:ss DD-MM-YYYY'); // Format start date with time
                    }},
                    { data: 'end_at', name: 'subscriptions.end_at', render: function(data, type, row) {
                        return moment(data).format('H:mm:ss DD-MM-YYYY'); // Format end date with time
                    }},
                    { data: 'status', name: 'subscriptions.status' }, // Leave status as it is
                    { data: 'country_code', name: 'subscriptions.country_code' }, // Leave country code as it is
                    { data: 'plan_name', name: 'subscriptions.plan_name' }, // Leave plan name as it is
                    { data: 'plan_duration', name: 'subscriptions.plan_duration'},
                    { data: 'currency_code', name: 'subscriptions.currency_code' }, // Leave currency code as it is
                    { data: 'rate', name: 'subscriptions.rate', render: $.fn.dataTable.render.number(',', '.', 2) }, // Format as currency (rate)
                    { data: 'quantity', name: 'subscriptions.quantity', render: function(data, type, row) {
                        return data.toString(); // Convert quantity to string if necessary
                    }},
                    { data: 'total_rate', name: 'subscriptions.total_rate', render: $.fn.dataTable.render.number(',', '.', 2) }, // Format as currency (total rate)
                    { data: 'tax', name: 'subscriptions.tax', render: $.fn.dataTable.render.number(',', '.', 2) }, // Format as currency (tax)
                    { data: 'grand_amount', name: 'subscriptions.grand_amount', render: $.fn.dataTable.render.number(',', '.', 2) }, // Format as currency (grand total)

                    { data: 'action', name: 'action', orderable: false, searchable: false }  // Action buttons (Edit, Gallery, Delete)
                ],
                order: [[0, 'desc']] 
            });
        });

        function changeFilter(){
            table.draw();
        }
    </script>

    
    <script>
        // Event listener for the button click
        $('body').on('click', '.lob-subscription-model-button-new', function() {
            $('#modal-lob-new-main-box').html('');
            var id = $(this).data('id');
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('lob.subscription.edit.popup')); ?>",
                data: {
                    _token: "<?php echo csrf_token() ?>",
                    id: id
                },
                async: false, 
                success: function(response) {
                    $('#modal-lob-new-main-box').append(response);
                    $('#modal-lob-new').modal('show');
                }
            });
        });

    </script>
    
    <script>
        // Event listener for the button click
        $('body').on('click', '.lob-subscription-model-next-billing', function() {
            $('#modal-lob-new-main-box').html('');
            var id = $(this).data('id');
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('lob.subscription.edit.next-billing')); ?>",
                data: {
                    _token: "<?php echo csrf_token() ?>",
                    id: id
                },
                async: false, 
                success: function(response) {
                    $('#modal-lob-new-main-box').append(response);
                    $('#modal-lob-new').modal('show');
                }
            });
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.admin_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/projectsdemo/public_html/aurobees/resources/views/backend/operation/subscription/index.blade.php ENDPATH**/ ?>