<div class="modal-content">
    <form id="subscription-form-edit" onsubmit="return subscriptionPopupFormSubmit(this);">
        <?php echo csrf_field(); ?>
        <div class="modal-header">
            <h4 class="modal-title">Edit Subscription (<?php echo e($data->serial_number); ?>)</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">×</span>
            </button>
        </div>
        <div class="modal-body">
            <input type="hidden" name="id" value="<?php echo e($data->id); ?>">
            <div class="form-group">
                <label>Status</label>
                <select name="status" id="status" class="form-control">
                    <option value="Active" <?php if($data->status=='Active'): ?> selected <?php endif; ?> >Active</option>
                    <option value="Canceled" <?php if($data->status=='Canceled'): ?> selected <?php endif; ?> >Canceled</option>
                    <option value="Processing" <?php if($data->status=='Processing'): ?> selected <?php endif; ?> >Processing</option>
                    <option value="Pending" <?php if($data->status=='Pending'): ?> selected <?php endif; ?> >Pending</option>
                </select>
            </div>

            <div class="form-group">
                <label>Start Date</label>
                <input type="datetime" name="start_at" id="start_at" class="form-control" value="<?php echo e($data->start_at); ?>"/>
            </div>
            <div class="form-group">
                <label>End Date</label>
                <input type="datetime" name="end_at" id="end_at" class="form-control" value="<?php echo e($data->end_at); ?>"/>
            </div>
            <div class="form-group">
                <label>Number of User</label>
                <input type="number" name="quantity" id="quantity" class="form-control" value="<?php echo e($data->quantity); ?>" required/>
            </div>
            <div class="form-group">
                <label>Grand Amount (<?php echo e($data->currency_code); ?>)</label>
                <input type="number" step="0.01" name="grand_amount" id="grand_amount" class="form-control" value="<?php echo e($data->grand_amount); ?>" required />
            </div>
            <div class="form-group">
                <label>Payment Status</label>
                <select name="payment_status" id="payment_status" class="form-control">
                    <option value="Pending" <?php if($transaction->status=='Pending'): ?> selected <?php endif; ?> >Pending</option>
                    <option value="Success" <?php if($transaction->status=='Success'): ?> selected <?php endif; ?> >Success</option>
                </select>
            </div>
            <div class="form-group">
                <label>Transaction ID</label>
                <input type="text" name="transaction_id" id="transaction_id" class="form-control" value="<?php echo e($transaction->transaction_id); ?>"/>
            </div>
            <div class="form-group">
                <label>Payment Date</label>
                <input type="date" name="payment_date" id="payment_date" class="form-control" value="<?php echo e($transaction->payment_date); ?>"/>
            </div>
            <div class="form-group">
                <label>Remarks</label>
                <textarea name="remarks" id="remarks" class="form-control"><?php echo e($data->remarks); ?></textarea>
            </div>

        </div>
        <div class="modal-footer justify-content-between">
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Save changes</button>
        </div>
    </form>
  </div>

<script>
    function subscriptionPopupFormSubmit(th){
        $.ajax({
            type: "POST",
            url: "<?php echo e(route('lob.subscription.update.popup')); ?>",
            data: $(th).serialize(),
            async: false, 
            success: function(response) {
                var response_type=response['alert-type'];
                if (response_type == 'success') {
                    $('#modal-lob-new').modal('hide');
                    changeFilter();
                }
                AlertMessage(response);
            }
        });
        return false;
    }
</script><?php /**PATH /home/projectsdemo/public_html/aurobees/resources/views/backend/operation/subscription/popup.blade.php ENDPATH**/ ?>