<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
/**
 *
 * Section Title Widget .
 *
 */
class Webteck_Section_Title_v4 extends Widget_Base {

	public function get_name() {
		return 'webtecksectiontitlev4';
	}
	public function get_title() {
		return __( 'Section Title v4', 'webteck' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Section Titlee', 'webteck' ), 
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		webteck_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One'] );

		
		
		webteck_general_fields( $this, 'section_subtitle', 'SubTitle', 'TEXT', 'Subtitle' );

		$this->add_control(
			'section_subtitle_tag', 
			[
				'label' 	=> __( 'SubTag', 'webteck' ),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'span'  => 'span',
				],
				'default' => 'span',
			]
        );
		webteck_general_fields( $this, 'section_title', 'Title', 'TEXTAREA', 'Title Here' );
		
        $this->add_control(
			'section_title_tag', 
			[
				'label' 	=> __( 'Title Tag', 'webteck' ),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'h1' => 'H1',
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
					'span'  => 'span',
				],
				'default' => 'h2',
			]
        );

		webteck_general_fields( $this, 'section_desc', 'Description', 'TEXTAREA', '' );

        $this->add_responsive_control(
			'section_align',
			[
				'label' 		=> __( 'Alignment', 'webteck' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 	=> [
						'title' 		=> __( 'Left', 'webteck' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' 		=> __( 'Center', 'webteck' ),
						'icon' 			=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' 		=> __( 'Right', 'webteck' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 	=> '',
				'toggle' 	=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .title-area' => 'text-align: {{VALUE}};',
                ]
			]
		);

		webteck_general_fields( $this, 'wrap_class', 'Wraper Extra Class', 'TEXT', '' );
		webteck_general_fields( $this, 'section_subtitle_class', 'Subtitle Extra Class', 'TEXT', '' );
		webteck_general_fields( $this, 'section_title_class', 'Title Extra Class', 'TEXT', '' );
		webteck_general_fields( $this, 'section_desc_class', 'Description Class', 'TEXT', '' );

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------------------------General Style-----------------------//
        $this->start_controls_section(
			'general_style_section',
			[
				'label' => __( 'General Style', 'webteck' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		webteck_dimensions_fields($this, 'menu_margin', 'Margin', 'margin', '{{WRAPPER}} .title-area');

		$this->end_controls_section();

		//-------Title Style-------
		webteck_common_style_fields($this, 'title', 'Title', '{{WRAPPER}} .sec-title');
		webteck_common_style_fields($this, 'subtitle', 'Subtitle', '{{WRAPPER}} .sub-title');
		//-------Description Style-------
		webteck_common_style_fields($this, 'desc', 'Description', '{{WRAPPER}} p');

	}

	protected function render() {

	$settings = $this->get_settings_for_display();


	

	if (array_key_exists('section_align', $settings)) {
	    if ($settings['section_align'] == 'left') {
	        $wrap_align_class = 'text-left';
	    } elseif ($settings['section_align'] == 'center') {
	        $wrap_align_class = 'text-center';
	    } elseif ($settings['section_align'] == 'right') {
	        $wrap_align_class = 'text-right';
	    } else {
	        $wrap_align_class = '';
	    }
	} else {
	    $wrap_align_class = 'text-left';
	}
	
	$this->add_render_attribute( 'subtitle_args', 'class', 'sub-title sub-title8 '. $settings['section_subtitle_class'] );

	$this->add_render_attribute( 'title_args', 'class', 'sec-title sec-title3 '. $settings['section_title_class']  );

	?>
		<div class="title-area <?php echo esc_attr($wrap_align_class . ' ' . $settings['wrap_class']); ?>">
			<?php	
				
				if ( !empty($settings['section_subtitle' ]) ){

					printf( '<%1$s %2$s>%3$s</%1$s>',
					$settings['section_subtitle_tag'],
					$this->get_render_attribute_string( 'subtitle_args' ),
					wp_kses_post( $settings['section_subtitle' ] )
					);
				}
				if ( !empty($settings['section_title' ]) ){
					printf( '<%1$s %2$s>%3$s</%1$s>',
					$settings['section_title_tag'],
					$this->get_render_attribute_string( 'title_args' ),
					wp_kses_post( $settings['section_title' ] )
					);
				}

				if( ! empty( $settings['section_desc'] ) ){
					echo webteck_paragraph_tag( array(
						'text'	=> wp_kses_post( $settings['section_desc'] ),
						'class'	=> esc_attr($settings['section_desc_class']),
					) );
				}

			?>
		</div>

	<?php
		
	}
}