jQuery(document).ready(function ($) {
	const order_id = phpVariables.order_id;
	const ajax_url = phpVariables.ajax_url;

	window.tracking_shipment = function () {
		var tracking_awb_number = $("#tracking_awb_number").val().trim();
		var shipping_provider = $("#shipping_provider").val().trim();

		$(".error-message").empty();
		jQuery("#errMsgTrackNumber").text("");
		jQuery("#errMsgShippingProvider").text("");

		let hasError = false;

		if (tracking_awb_number === "") {
			jQuery("#errMsgTrackNumber").text("AWB Number is missing or not found.");
			jQuery("#tracking_awb_number").focus();
			hasError = true;
		}

		if (shipping_provider === "") {
			jQuery("#errMsgShippingProvider").text(
				"Shipping provider is missing or not found."
			);
			if (!hasError) {
				jQuery("#shipping_provider").focus();
			}
			hasError = true;
		}

		if (hasError) {
			return false;
		} else {
			var $button = $('button[name="tracking_btn"]');
			var originalText = $button.text();
			$button.prop("disabled", true).html("Please Wait...");

			$.ajax({
				type: "POST",
				url: ajax_url,
				dataType: "json",
				cache: false,
				data: {
					action: "ajax_tracking_shipment",
					order_id: order_id,
					tracking_action: "tracking_shipment",
				},
				success: function (result) {
					$button.prop("disabled", false).html(originalText);
					console.log(result);
					if (result.success) {
						$(".error-message").empty();
						$(".tracking-details").html("");
						var specific_statuses = [
							"PickupCancelled",
							"ReturnInitiated",
							"Rejected",
							"Undeliverable",
							"Lost",
							"Delivered",
						];

						var shipping_status = result.data.shipping_data.shipping_status;

						var html =
							'<div class="tracking-details"><ul>' +
							'<li><label for="tracking_details"><strong>Tracking details:</strong></label></li>' +
							'<li class="form-field flex-center-align">' +
							'<label for="tracking_awb_number"><strong>Current Status:</strong></label>' +
							'<span id="shipping_status">' +
							shipping_status +
							"</span>" +
							"</li>";

						if (!specific_statuses.includes(shipping_status)) {
							html +=
								'<li class="form-field flex-center-align">' +
								'<label for="estimated_delivery_date"><strong>Estimated Delivery:</strong></label>' +
								'<span id="estimated_delivery_date">' +
								result.data.shipping_data.estimated_delivery_date +
								"</span>" +
								"</li>";
						}

						html +=
							"</ul>" +
							"<ul>" +
							"<li>" +
							'<label for="tracking_history"><strong>Tracking History:</strong></label>' +
							"</li>" +
							'<div id="tracking-container">';

						var tracking_history_arr = JSON.parse(
							result.data.shipping_data.tracking_history
						);

						var tracking_event_code = [
							"ReadyForReceive",
							"PickupDone",
							"Delivered",
							"Departed",
							"DeliveryAttempted",
							"Lost",
							"OutForDelivery",
							"ArrivedAtCarrierFacility",
							"Rejected",
							"Undeliverable",
							"PickupCancelled",
							"ReturnInitiated",
							"AvailableForPickup",
						];

						// Loop through each tracking event code
						$.each(tracking_event_code, function (index, event_code) {
							if (tracking_history_arr.payload) {
								$.each(
									tracking_history_arr.payload.eventHistory,
									function (i, event_history) {
										if (event_history.eventCode === event_code) {
											var formateddate = new Date(event_history.eventTime);
											var event_date =
												formateddate.getDate().toString().padStart(2, "0") +
												"-" +
												(formateddate.getMonth() + 1)
													.toString()
													.padStart(2, "0") +
												"-" +
												formateddate.getFullYear();

											html +=
												'<li class="flex-center-align"><label for="tracking_awb_number"><strong>' +
												event_code +
												": </strong></label> ";
											html += "<span>" + event_date + "</span></li>";
											return false; // Break the inner loop
										}
									}
								);
							}
						});

						html += "</div></ul></div>";
						$(".tracking-details").html(html);

						if (result.data.email_data) {
							// Asynchronously send the email
							sendEmailTrackingAsync(order_id, result.data.email_data);
						}
						location.reload();
					} else {
						$button.prop("disabled", false).html(originalText);
						$(".error-message").empty();
						$("#postbox-container-1").prepend(
							'<span class="error-message"><strong>' +
								result.data.message +
								" " +
								result.data.detail_error_message +
								"</strong></span>"
						);
					}
				},
				error: function (error) {
					console.log("Error:", error);
					$button.prop("disabled", false).html(originalText);
				},
			});
		}
	};

	// Send email asynchronously
	function sendEmailTrackingAsync(order_id, email_data) {
		$.ajax({
			type: "POST",
			url: ajax_url,
			dataType: "json",
			cache: false,
			data: {
				action: "send_email_async",
				order_id: order_id,
				email_data: email_data,
			},
			success: function (response) {
				console.log("Email sent:", response);
			},
			error: function (error) {
				console.log("Email sending failed:", error);
			},
		});
	}
});
