<!-- templates/package-label-form.php -->
<div>
    <div class="options_group padding-bottom-10">
        <p class="form-field _weight_field">
            <label for="auroship_weight"><?php esc_html_e( 'Gross Weight (g)*', 'auroship' );?></label>
            <span class="woocommerce-help-tip tip-title" tabindex="0" title="<?php esc_attr_e( 'Weight in decimal form', 'auroship' );?>" aria-label="<?php esc_attr_e( 'Weight in decimal form', 'auroship' );?>"></span>
            <input type="text" class="short wc_input_decimal" name="auroship_weight" id="auroship_weight" value="<?php echo esc_attr( $data['product_weight'] ); ?>" placeholder="<?php esc_attr_e( '0', 'auroship' );?>">
            <p id="errMsgWeight" class="error-message"></p>
        </p>
        <div class="form-field dimensions_field">
            <label for="auroship_product_length"><?php esc_html_e( 'Dimensions LxWxH (cm)*', 'auroship' );?></label>
            <span class="woocommerce-help-tip tip-title" tabindex="0" title="<?php esc_attr_e( 'LxWxH in decimal form', 'auroship' );?>" aria-label="<?php esc_attr_e( 'LxWxH in decimal form', 'auroship' );?>"></span>
            <div class="flex right-section-fields gap-5">
                <input id="auroship_product_length" placeholder="<?php esc_attr_e( 'Length', 'auroship' );?>" class="input-text wc_input_decimal" size="6" type="text" name="auroship_product_length" value="<?php echo esc_attr( $data['package_length'] ); ?>">
                <input id="auroship_product_width" placeholder="<?php esc_attr_e( 'Width', 'auroship' );?>" class="input-text wc_input_decimal" size="6" type="text" name="auroship_product_width" value="<?php echo esc_attr( $data['package_width'] ); ?>">
                <input id="auroship_product_height" placeholder="<?php esc_attr_e( 'Height', 'auroship' );?>" class="input-text wc_input_decimal last" size="6" type="text" name="auroship_product_height" value="<?php echo esc_attr( $data['package_height'] ); ?>">
            </div>
            <div>
                <p id="errMsgLength" class="error-message"></p>
                <p id="errMsgWidth" class="error-message"></p>
                <p id="errMsgHeight" class="error-message"></p>
            </div>
        </div>
    </div>
    <div class="no-border">
        <ul class="order-button">
            <li class="wide" id="awb_number"><?php echo $data['awbtext']; ?></li>
            <li class="wide">
                <div class="package_label_pdf" id="package_label_pdf_div"><?php echo $data['pdfurltext']; ?></div>
                <button type="button" <?php echo esc_html( $data['btn_disabled'] ); ?> onclick="generate_label()" class="button save_order button-primary" name="package_label" id="package_label"><?php echo esc_html( $data['btntext'] ); ?></button>
            </li>
        </ul>
    </div>
</div>
