<?php

/**
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PHP version 5
 *
 * @category  Microsoft
 *
 * @author    Azure PHP SDK <azurephpsdk@microsoft.com>
 * @copyright Microsoft Corporation
 * @license   http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 *
 * @link      https://github.com/WindowsAzure/azure-sdk-for-php
 */

namespace WindowsAzure\MediaServices\Authentication;

/**
 * Enumerate types of Azure AD Credentials
 *
 * @category  Microsoft
 *
 * @author    Azure PHP SDK <azurephpsdk@microsoft.com>
 * @copyright Microsoft Corporation
 * @license   http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 *
 * @version   Release: 0.5.0_2016-11
 *
 * @link      https://github.com/WindowsAzure/azure-sdk-for-php
 */
class AzureAdTokenCredentialType {

    /**
     * User Credential by prompting user for user name and password.
     */
    const USER_CREDENTIAL = 0;

    /**
     * User Secret Credential by providing user name and password via configuration.
     */
    const USER_SECRET_CREDENTIAL = 1;

    /**
     * Service Principal with the symmetric key credential.
     */
    const SERVICE_PRINCIPAL_WITH_CLIENT_SYMMETRIC_KEY = 2;

    /**
     * Service Principal with the certificate credential.
     */
    const SERVICE_PRINCIPAL_WITH_CERTIFICATE = 3;
}
