<?php


function register_order_routes() {

    //update status of order
    register_rest_route( 'wc/api/v1/', 'orderstatus', 
        array(
            'methods' => 'POST',
            'callback' => 'update_order_status',
            'args' => array(
                'id' => array( 
                    'validate_callback' => function( $param, $request, $key ) {
                        return true;
                    }
                ),
            ),
            'permission_callback' => function($param) {
                return authenticate_order_request($param);
            }, 
        )
    );

    //update quantity of product and tracking number - stock
    register_rest_route( 'wc/api/v1/', 'orderquanity', 
        array(
            'methods' => 'POST',
            'callback' => 'update_order_product_quantity',
            'args' => array(
                'id' => array( 
                    'validate_callback' => function( $param, $request, $key ) {
                        return true;
                    }
                ),
            ),
            'permission_callback' => function($param) {
                return authenticate_order_request($param);
            }, 
        )
    );

    //update product stock
    register_rest_route( 'wc/api/v1/', 'productstock', 
        array(
            'methods' => 'POST',
            'callback' => 'update_order_product_stock',
            'args' => array(
                'id' => array( 
                    'validate_callback' => function( $param, $request, $key ) {
                        return true;
                    }
                ),
            ),
            'permission_callback' => function($param) {
                return authenticate_order_request($param);
            }, 
        )
    );
}


function authenticate_order_request() {
    $headers = getallheaders();
    $token = $headers['apikey'];
    
    if($token==WC_SCM_ACCESSKEY) {
        return true;
    } else {
        return false;
    }
}

function update_order_status($data) {

    //get data
    $data = $data['basicDetails'];
    $order_id          = $data['bookingNo'];
    $status            = $data['status']; //Waiting or Allocated
    $timestamp         = $data['timestamp'];
    //$action            = $data['action'];
    Cust_Functions::log("calling api: update_order_status");
    Cust_Functions::log("order_id:".$data['bookingNo']);
    Cust_Functions::log("status:".$data['status']);
    //update order
    $order = wc_get_order( $order_id );
    
    if ( ! $order_id || ! $order ) {
        $response = "Fail";
        $error = "Order not found";
		$code = "400";
       
    } else {

        //check action
        if( $status != 'Waiting' && $status != 'Allocated') {  //check status
            $response = "Fail";
            $error = "Invalid status";
			$code = "400";
        } else {
            $map_status = array ('Waiting' => 'on-hold','Allocated' => 'processing');
            $order->update_status($map_status[$status]);
            $order->set_date_modified($timestamp);
            $response = "SUCCESS";
			$code = "200";
            $error = null;
        }
    }
    return rest_ensure_response( array('message'=>$response,'code'=>$code));
}

//for Goods issue
function update_order_product_quantity($data) {

    //get data
    $basic_details     = $data['basicDetails'];
    $order_id          = $basic_details['bookingNo'];
    $timestamp         = $basic_details['timestamp'];
    $awb               = $basic_details['AWB']; 
    //$action            = $basic_details['action'];
    $products          = $data['products'];
	Cust_Functions::log("calling api: update_order_product_quantity");
    Cust_Functions::log("order_id:".$basic_details['bookingNo']);
    
    
    //update order
    $order = wc_get_order( $order_id );
    $order->update_status('shipped');
    if ( ! $order_id || ! $order ) {
        $response = "Fail";
        $error = "Order not found";
		$code = "400";
       
    } else {
        //check action
        foreach($products as $product) {
            $product_id = $product['productCode'];
            $quantity = $product['quantity']['value'];

            // Get an instance of the WC_Product object
            $product_details = new WC_Product( $product_id );
            //print_r($product_details);exit;
            if( $product_details) {
                $stock_quantity = $product_details->get_stock_quantity();
                //$updated_quanity = $stock_quantity - $quantity;
				$updated_quanity = $stock_quantity;
                $product_details->set_stock_quantity($updated_quanity);
                $product_details->save();
                
            }
        }

        $response = "SUCCESS";
		$code = "200";
        $error = null;
		
        
    }
    return rest_ensure_response(array('message'=>$response,'code'=>$code));
}

// for GRN 
function update_order_product_stock($data) {

    //get data
    $basic_details     = $data['basicDetails'];
    $order_id          = $basic_details['bookingNo'];
    $timestamp         = $basic_details['timestamp'];
    //$action            = $basic_details['action'];
	Cust_Functions::log("calling api: update_order_product_stock");
    Cust_Functions::log("order_id:".$basic_details['bookingNo']);

    $products = $data['products'];
    //echo "<pre>";print_r($products);die;
    //update order
   // $order = wc_get_order( $order_id );
    
    //if ( ! $order_id || ! $order ) {
        //$response = "Fail";
        //$error = "Order not found";
       
   // } else {
        //TODO: check if PO no already exist
        foreach($products as $product) {

            //check status
            if($product['status'] == 'Normal') {
                // get the product ID from the SKU
                //$product_id = $wpdb->get_var( $wpdb->prepare( "SELECT post_id FROM $wpdb->postmeta WHERE meta_key='_sku' AND meta_value='%s' LIMIT 1", $sku ) );
                $product_id = $product['productCode'];
                $quantity = $product['quantity']['value'];

                // Get an instance of the WC_Product object
                $product_details = new WC_Product( $product_id );

                if($product_details) {
                    // Get product stock quantity and stock status
                    $stock_quantity = $product_details->get_stock_quantity();
                    //$stock_status   = $product->get_stock_status();
                    $updated_quanity = $stock_quantity + $quantity;
                    // Set product stock quantity (zero) and stock status (out of stock)
                    $product_details->set_stock_quantity($updated_quanity);
                    //$product->set_stock_status('outofstock');
                    //save
                    $product_details->save();
                }
            }
        }

        $response = "SUCCESS";
		$code = "200";
        $error = null;
		
        
    //}
    return rest_ensure_response( array('message'=>$response,'code'=>$code));
}
?>