<?php 

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Cust_Functions {
	/** Log
	 *
	 * @param $message
	 * @param string $level
	 *     'emergency': System is unusable.
	 *     'alert': Action must be taken immediately.
	 *     'critical': Critical conditions.
	 *     'error': Error conditions.
	 *     'warning': Warning conditions.
	 *     'notice': Normal but significant condition.
	 *     'info': Informational messages.
	 *     'debug': Debug-level messages.
	*/
	public static function log( $message, $level = 'info' ) {

		//$options = get_option( 'woocommerce_scmprofit_settings' );
		//$logging = $options['logging'];
		$logging = true;
		if ($logging) {
			$log = wc_get_logger();
			$log->log( $level, $message);
		}
	}
	
	 public static function convert_to_xml_product($product_id,$data) { 
		//echo "<pre>";print_r($data);die;
		$message_version = self::get_message_version($product_id);
		$message_identifier = self::get_message_unique_identifier();
		$message_datetime = date('YmdHis');
		if($data['action'] == 'Edit' || $data['action'] == 'Delete')
		{
			$xml_array = array(
				'Header' => array(
					'MessageType'       => 'Normal',
					'MessageVersion'    => $message_version,
					'MessageIdentifier' => $message_identifier,
					'MessageDateTime'   => $message_datetime
				),	
			'Products' => array(
				'Product' => array(
					'Action' => $data['action'],
					'BasicInformation' => array(
						'ProductCode' => $data['ProductCode'],
						'ProductDescription'   => $data['ProductDescription'],
						'Category' => array(
								'Code' => $data['category_id'],
								'Name' => $data['category_name'],								
						),
						'SubCategory' => '',
						'BrandName' => '',
						'SubBrandName' => '',
						'AirCommodityCode' => '',
						'Active' => '1',
						'EANCode' => '',												
						'Barcode' => $data['ProductCode'],												
					),
					'Measurements' => array(
						'BaseUOM' => $data['BaseUOM'],	
						'UnitDimension' => '',
						'UnitVolume' => '',
						'UnitWeight' => '',
						'UnitRate' => array(
									'Value' => '',
									'Currency' => '',
									)						
					),
					'CargoAttributes' => array(
						'Perishable' => 'false',	
						'InsuranceRequired' => 'true',
						'Expirable' => 'true',
						'Hazardous' => 'false',
						'StorageInstruction' => '',
						'HandlingInstruction' => '',						
					),
					'HazardousInformation' => array(
						'HSECCNCode' => '',	
						'HSIMOCode' => '',
						'Description' => '',
						'UNNo' => '',
						'Class' => '',
						'FlashPoint' => '',
						'TemperatureRange' => '',
						'IMDGNo' => '',
						'UNDGNo' => '',
						'EMSNo' => '',
						'HazardousGoodsType' => '',						
					),
					'Packages' => '',
					'ExtendedAttributes' => '',
					'Clients' => array(
						'Client' => array(
							'Code' => $data['Code'],
						)
					),
					'Offices' => array(
						'Office' => array(
							'Code' => $data['Code'],
							'Name' => '',
						)
					),
					'BillOfMaterials' => '',
					'VendorProductInformations' => '',
				)
			)				
		);
		}
		else
		{
			$xml_array = array(
				'Header' => array(
					'MessageType'       => 'Normal',
					'MessageVersion'    => $message_version,
					'MessageIdentifier' => $message_identifier,
					'MessageDateTime'   => $message_datetime
				),	
			'Products' => array(
				'Product' => array(
					'Action' => $data['action'],
					'BasicInformation' => array(
						'ProductCode' => $data['ProductCode'],
						'ProductDescription'   => $data['ProductDescription'],
						'Category' => array(
								'Code' => $data['category_id'],
								'Name' => $data['category_name'],								
						),
						'SubCategory' => '',
						'BrandName' => '',
						'SubBrandName' => '',
						'AirCommodityCode' => '',
						'Active' => '1',
						'EANCode' => '',												
						'Barcode' => $data['ProductCode'],												
					),
					'Measurements' => array(
						'BaseUOM' => $data['BaseUOM'],	
						'UnitDimension' => '',
						'UnitVolume' => '',
						'UnitWeight' => '',
						'UnitRate' => array(
									'Value' => '',
									'Currency' => '',
									)						
					),
					'CargoAttributes' => array(
						'Perishable' => 'false',	
						'InsuranceRequired' => 'true',
						'Expirable' => 'true',
						'Hazardous' => 'false',
						'StorageInstruction' => '',
						'HandlingInstruction' => '',						
					),
					'HazardousInformation' => array(
						'HSECCNCode' => '',	
						'HSIMOCode' => '',
						'Description' => '',
						'UNNo' => '',
						'Class' => '',
						'FlashPoint' => '',
						'TemperatureRange' => '',
						'IMDGNo' => '',
						'UNDGNo' => '',
						'EMSNo' => '',
						'HazardousGoodsType' => '',						
					),
					'Packages' => '',
					'ExtendedAttributes' => '',
					'Clients' => array(
						'Client' => array(
							'Code' => $data['Code'],
						)
					),
					'Offices' => array(
						'Office' => array(
							'Code' => $data['Code'],
							'Name' => '',
						)
					),
					'BillOfMaterials' => '',
					'VendorProductInformations' => '',
				)
			)				
		);
		}	
		
		
		//echo "<pre>";print_r($xml_array);die;
		$xml = new SimpleXMLElement('<Message/>');
		self::to_xml($xml, $xml_array);

		//format prodcuts
		//echo "<pre>";print_r($data['products']);die;
		$xml = $xml->asXML();
		
		
		//echo $xml;		die;
		return $xml;
    }
	
    public static function convert_to_xml($order_id,$data) { 

		$message_version = self::get_message_version($order_id);
		$message_identifier = self::get_message_unique_identifier();
		$message_datetime = date('YmdHis');

		$xml_array = array(
			'Header' => array(
				'MessageType'       => 'Normal',
				'MessageVersion'    => $message_version,
				'MessageIdentifier' => $message_identifier,
				'MessageDateTime'   => $message_datetime
			),
			'Bookings' => array(
				'Booking' => array(
					'Action' => $data['action'],
					'BasicDetails' => array(
						'BookingType' => 'Normal',
						'BookingNo'   => $data['booking_no'],
						'BookingDate' => $data['booking_date'],
						'ServiceClass'=> array(
							'Code' => 'Urgent',
						),
						'Client'    => array(
							'Code' => $data['client_code'],
						),
						'Shipper' => array(
							'Code' => $data['shipper_code'],
						),
						'Marketplace' => $data['marketplace'],
						'CustomerReferenceNo' => $data['cust_ref_no'],
						'Consignee' => array(
							'Code' => 'CUSTOMER',
						),
						'PONo' => '',
						'PODate' => '',
						'DueDate' => array(
							'Date' => $data['due_date'],
							'Time' => $data['due_date_time'],
							'TimeZone' => $data['due_date_timezone'],
							
						),
						'Courier' => $data['courier'],
						'CourierServiceType'  => $data['courier_service_type'],
						'AWBNumber'  => $data['tracking_number'],
						'Movement' => array(
							'PlaceOfDelivery'  => array(
								'Code' => '',
							),
							'ShipmentType'  => '',
						),						
						'PackageSummary' => array(
							'TotalPackages'  => array(
								'Value' => '',
								'Uom' => '',
							)							
						),
						'SystemInformation' => array(
							'BookingOffice'  => array(
								'Code' => $data['booking_office'],
							)
						),
						'ServiceTemplateName' => 'WHOB',
						'Barcode1Label' => '',
						'Barcode1Type' => '',
						'Barcode1Value' => '',
						'Barcode2Label' => '',
						'Barcode2Type' => '',
						'Barcode2Value' => '',
						'Barcode3Label' => '',
						'Barcode3Type' => '',
						'Barcode3Value' => '',
						'Barcode4Label' => '',
						'Barcode4Type' => '',
						'Barcode4Value' => '',
						'Barcode5Label' => '',
						'Barcode5Type' => '',
						'Barcode5Value' => '',
						'ExtraText1Label' => '',
						'ExtraText1Text' => '',
						'ExtraText2Label' => '',
						'ExtraText2Text' => '',
						'ExtraText3Label' => '',
						'ExtraText3Text' => '',
						'ExtraText4Label' => '',
						'ExtraText4Text' => '',
						'ExtraText5Label' => '',
						'ExtraText5Text' => '', 
						'PackageDescription'  => '',
						'ShippingCost' => $data['shippingcost'],
						'Notes'  => '',
					),
					'Parties' => array(
						'Party' => array(
							'PartyName'=> array(
								'Code' => 'CUSTOMER',
								'Name' => $data['party_name'],
							),
							'PartyType' => 'Consignee',
							'AddressInformation' => array(
								'AddressLine1' =>$data['address1'],
								'City' => $data['city'],
								'StateProvince' => $data['state'],
								'ZipCode' => $data['zipcode'],
								'Country' => array(
									'Code' =>  $data['country_code'],
								),
							),
							'Contacts' => array(
								'Contact' => array(
									'ContactNos' => array(
										'Type' => 'Main',
										'Number' => $data['contact_number'],
									)
								)
							),
						),
					),
					'Products' => array(
						$data['products'],
					)
				)
			)
		);
		
		//echo "<pre>";print_r($xml_array);die;
		$xml = new SimpleXMLElement('<Message/>');
		self::to_xml($xml, $xml_array);

		//format prodcuts
		//echo "<pre>";print_r($data['products']);die;
		$xml = $xml->asXML();
		
		for($i=0;$i<count($data['products']);$i++) {
			$xml = str_replace("<".$i.">","",$xml);
			$xml = str_replace("</".$i.">","",$xml);			
		}
		//echo $xml;die;		
		return $xml;
    }

	public static function to_xml(SimpleXMLElement $object, array $data)
	{
		$attr = "Attribute_";
		foreach ($data as $key => $value) {
			if (is_array($value)) {
				$new_object = $object->addChild($key);
				self::to_xml($new_object, $value);
			} else {
				if(strpos($key, $attr) !== false){
					$object->addAttribute(substr($key, strlen($attr)), $value);
				}else{
					$object->addChild($key, $value);
				}
			}
		}
	}

    public static function get_message_version($order_id) { 
        if( get_post_meta($order_id, '_scm_message_version', true)) {
            $version = get_post_meta($order_id, '_scm_message_version', true);
            return $version++;
        } else {
            update_post_meta($order_id, '_scm_message_version', 1);
            return 1;
        }
        return $data;
    }

    public static function get_message_unique_identifier() { 
       	if (function_exists('com_create_guid') === true)
        return trim(com_create_guid(), '{}');
		$data = openssl_random_pseudo_bytes(16);
		$data[6] = chr(ord($data[6]) & 0x0f | 0x40); // set version to 0100
		$data[8] = chr(ord($data[8]) & 0x3f | 0x80); // set bits 6-7 to 10
		return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
    }

	public static function get_csv_file_data() { 

		$mapping_file = get_option('scm-shipping-mapping-file');
		$shipping_providers_array = array();

		if($mapping_file) {

			$file = fopen($mapping_file, 'r');
			
			while (($result = fgetcsv($file)) !== false)
			{
				$csv[] = $result;
			}

			fclose($file);

			$shipping_providers_array = array();
			for($i=1;$i<count($csv);$i++) {
				$key = $csv[$i][1];
				$shipping_providers_array[$csv[$i][0]] = array(
					$key => array(
						'shipping_provider_name' => $csv[$i][2],
						'shipping_service_type' => $csv[$i][3],
						'shipping_tracking_number' => $csv[$i][4]
					),
				);
			}
		}
		return $shipping_providers_array;
	}
}
		