<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'rest_api_init', 'register_order_routes');
add_action('woocommerce_thankyou', 'order_created');
add_action( 'woocommerce_order_status_cancelled', 'order_cancelled', 10, 1 ); 
add_action('woocommerce_process_shop_order_meta', 'order_updated');
add_filter( 'manage_edit-shop_order_columns', 'add_scmlog_status_column_header', 20 );
add_action( 'manage_shop_order_posts_custom_column' , 'manage_scmlog_status_column_value', 20, 2 );

add_action('transition_post_status', 'product_save_scm', 10, 3);
add_action( 'wp_trash_post', 'delete_for_product', 99 );
add_action( 'delete_post', 'delete_for_product', 99 );
add_action( 'cron_schedules', 'order_custom_cron_schedule' );

function order_custom_cron_schedule( $schedules ) {
    /*$schedules['every_six_hours'] = array(
        'interval' => 21600, // Every 6 hours
        'display'  => __( 'Every 6 hours' ),
    );*/
	$schedules['every_ten_minute'] = array(
        'interval' => 600, 
        'display'  => __( 'Every 10 Minute' ),
    );
    return $schedules;
}

//Schedule an action if it's not already scheduled
if ( ! wp_next_scheduled( 'woo_to_scm_order_upload_hook' ) ) {
    wp_schedule_event( time(), 'every_ten_minute', 'woo_to_scm_order_upload_hook' );
}

///Hook into that action that'll fire every six hours
 add_action( 'woo_to_scm_order_upload_hook', 'woo_to_scm_order_upload');
function woo_to_scm_order_upload()
{  
	//wp_mail( 'nilay.parekh@aurionpro.com', 'Cloudways Cron', 'Cloudways - a Managed Cloud Hosting!' );
	require_once(ABSPATH.'wp-content/plugins/woocommerce/woocommerce.php');
	require_once( $_SERVER['DOCUMENT_ROOT'] . '/wp-blog-header.php' );	
	 
	global $wpdb, $woocommerce, $post, $wc_order_types;
	$wc_order_types["shop_order"] = "shop_order";
	
	$query = "SELECT DISTINCT order_items.order_id FROM wp_woocommerce_order_items as order_items LEFT JOIN wp_woocommerce_order_itemmeta as order_item_meta ON order_items.order_item_id = order_item_meta.order_item_id LEFT JOIN wp_posts AS posts ON order_items.order_id = posts.ID WHERE posts.post_type = 'shop_order' AND order_items.order_item_type = 'line_item'";
	$results_order = $wpdb->get_results($query);
	
	foreach($results_order as $orderdata)
	{
		$orderdata_array = (array) $orderdata;		
		$order_id =  $orderdata_array['order_id'];		
		$order = new WC_Order( $order_id );
		$date1 = current_time('Y-m-d');		
		$createDate = new DateTime($order->order_date);
		$strip = $createDate->format('Y-m-d');
		
		$timestamp1 = strtotime($date1);
		$timestamp2 = strtotime($strip);
		
		if($order->created_via !="checkout" && $timestamp1 == $timestamp2)
		{				
						
			//set order status on hold
			//$order = wc_get_order( $order_ids );
			//echo "<pre>";print_r($order_details);die;
			
			//echo "<pre>";print_r($order);die;
			
			//if( $order->get_status() == 'processing' ) {
				$order_ids = $order->id;
				//$order->update_status( 'on-hold' );
				$order_details = generate_xml_cron_order($order_ids,'Add') ;
				
				//order is created - so now integrate and send order details to SCM using azure service
				AzureServices::sync_data($order_details);				
				
			//}	
						
		}		
	}	
}
//do_action('woo_to_scm_order_upload_hook');
function  generate_xml_cron_order($order_id,$action) {
	//ger order data
	$order_data = get_order_data_cron($order_id,$action);

	//convert data to xml
	$xml = Cust_Functions::convert_to_xml($order_id,$order_data);
	return $xml;

}

function get_order_data_cron($order_id,$action) {

	$order = new WC_Order( $order_id );
	
	//get order basic details
	$client_shipper_code = get_option('wc_settings_scmprofit_shipper_code');
	$marketplace		 = get_option('wc_settings_scmprofit_shipper_code'); //"WooCommerce";
	$due_date 			 = get_option('wc_settings_scmprofit_due_date');
	$due_date_timezone 	 = get_option('wc_settings_scmprofit_due_date_timezone');
	$UOM 				 = get_option('wc_settings_scmprofit_uom');
	$booking_office 	 = get_option('wc_settings_scmprofit_booking_office');// fetch from setings

	//calculate order due date time
	$order_date 			= date('Y-m-d H:i:s', strtotime(get_post($order->get_id())->post_date));
	$order_due_date_dt 		= strtotime($order_date."+ ".$due_date." days");
	$order_due_date 		=  date("Ymd",$order_due_date_dt);
	$order_due_date_time 	=  date("Hi",$order_due_date_dt);

	//get shiiping provider details
	$shipping_provider_details = get_shipping_provider_details($order_id);

	/*$courier 				= "BDX";
	$courier_service_type 	= "reguler";
	$tracking_number 		= "1234567";*/

	$courier 				= $shipping_provider_details['name'];
	$courier_service_type 	= $shipping_provider_details['type'];
	$tracking_number 		= $shipping_provider_details['number'];

	//get product array
	$line_items = array();
	
	foreach ( $order->get_items() as $id => $item ) {
		$product = $item->get_product();		
		$line_item['Action']= $action;
		$line_item['ProductCode'] = $item->get_product_id(); //substr( $product->get_id(), 0, 31 );
		$line_item['Quantity'] = array (
			'Value' => $item->get_quantity(),
			'Uom' => $UOM,
		);
		$line_item['UnitVolume'] = array('Value' => $order->get_item_total( $item ));
		$line_item['BrandSeller']= $client_shipper_code;
		$line_item['OrderDetails'] = array('SKULineNo' => $item->get_id() ); ////substr( $product->get_id(), 0, 31 )
		
		$line_items[]['Product'] = $line_item;
	}
	//echo "<pre>";
	//print_r($order);
	//print_r($order->get_billing_country());
	//print_r($order->get_shipping_country());die;
	if($order->get_shipping_country() != '')
	{
		$code = $order->get_shipping_country();
	}
	else
	{
		$code = $order->get_billing_country();
	}
	
	$code = ucfirst($code);

	if(strlen($code)>2)
	{		
		$country_code =  code_to_country( $code );
	}
	else
	{		
		$country_code = $order->get_shipping_country();
	}

	$order_data = array(
		'action' 				=> $action,
		'booking_no' 			=> $order_id,
		'booking_date' 			=> date('Ymd', strtotime(get_post($order->get_id())->post_date)),
		'client_code' 			=> $client_shipper_code,
		'shipper_code' 			=> $client_shipper_code,
		'cust_ref_no' 			=> $order_id,
		'marketplace'		    => $marketplace,
		'due_date' 				=> $order_due_date,
		'due_date_time' 		=> $order_due_date_time,
		'due_date_timezone' 	=> $due_date_timezone,
		'courier' 				=> $courier,
		'courier_service_type'  => $courier_service_type,
		'tracking_number' 		=> $tracking_number,
		'booking_office' 		=> $booking_office,
		'party_name' 			=> $order->get_billing_first_name()." ".$order->get_billing_last_name(),
		'address1'				=> $order->get_billing_address_1(),
		'city' 					=> $order->get_billing_city(),
		'state' 				=> $order->get_billing_state(),
		'zipcode' 				=> $order->get_billing_postcode(),
		'country_code' 			=> $country_code,
		'contact_number' 		=> $order->get_billing_phone(),
		'products' 				=> $line_items,
		'shippingcost' 			=> $order->get_shipping_total(),
	);
	//echo "<pre>";print_r($order);
	//echo "<pre>";print_r($order_data);die;
    return $order_data;
}



function code_to_country( $code ){

   // $code = strtoupper($code);

    $countryList = array(
        'AF' => 'Afghanistan',
        'AX' => 'Aland Islands',
        'AL' => 'Albania',
        'DZ' => 'Algeria',
        'AS' => 'American Samoa',
        'AD' => 'Andorra',
        'AO' => 'Angola',
        'AI' => 'Anguilla',
        'AQ' => 'Antarctica',
        'AG' => 'Antigua and Barbuda',
        'AR' => 'Argentina',
        'AM' => 'Armenia',
        'AW' => 'Aruba',
        'AU' => 'Australia',
        'AT' => 'Austria',
        'AZ' => 'Azerbaijan',
        'BS' => 'Bahamas the',
        'BH' => 'Bahrain',
        'BD' => 'Bangladesh',
        'BB' => 'Barbados',
        'BY' => 'Belarus',
        'BE' => 'Belgium',
        'BZ' => 'Belize',
        'BJ' => 'Benin',
        'BM' => 'Bermuda',
        'BT' => 'Bhutan',
        'BO' => 'Bolivia',
        'BA' => 'Bosnia and Herzegovina',
        'BW' => 'Botswana',
        'BV' => 'Bouvet Island (Bouvetoya)',
        'BR' => 'Brazil',
        'IO' => 'British Indian Ocean Territory (Chagos Archipelago)',
        'VG' => 'British Virgin Islands',
        'BN' => 'Brunei Darussalam',
        'BG' => 'Bulgaria',
        'BF' => 'Burkina Faso',
        'BI' => 'Burundi',
        'KH' => 'Cambodia',
        'CM' => 'Cameroon',
        'CA' => 'Canada',
        'CV' => 'Cape Verde',
        'KY' => 'Cayman Islands',
        'CF' => 'Central African Republic',
        'TD' => 'Chad',
        'CL' => 'Chile',
        'CN' => 'China',
        'CX' => 'Christmas Island',
        'CC' => 'Cocos (Keeling) Islands',
        'CO' => 'Colombia',
        'KM' => 'Comoros the',
        'CD' => 'Congo',
        'CG' => 'Congo the',
        'CK' => 'Cook Islands',
        'CR' => 'Costa Rica',
        'CI' => 'Cote d\'Ivoire',
        'HR' => 'Croatia',
        'CU' => 'Cuba',
        'CY' => 'Cyprus',
        'CZ' => 'Czech Republic',
        'DK' => 'Denmark',
        'DJ' => 'Djibouti',
        'DM' => 'Dominica',
        'DO' => 'Dominican Republic',
        'EC' => 'Ecuador',
        'EG' => 'Egypt',
        'SV' => 'El Salvador',
        'GQ' => 'Equatorial Guinea',
        'ER' => 'Eritrea',
        'EE' => 'Estonia',
        'ET' => 'Ethiopia',
        'FO' => 'Faroe Islands',
        'FK' => 'Falkland Islands (Malvinas)',
        'FJ' => 'Fiji the Fiji Islands',
        'FI' => 'Finland',
        'FR' => 'France, French Republic',
        'GF' => 'French Guiana',
        'PF' => 'French Polynesia',
        'TF' => 'French Southern Territories',
        'GA' => 'Gabon',
        'GM' => 'Gambia the',
        'GE' => 'Georgia',
        'DE' => 'Germany',
        'GH' => 'Ghana',
        'GI' => 'Gibraltar',
        'GR' => 'Greece',
        'GL' => 'Greenland',
        'GD' => 'Grenada',
        'GP' => 'Guadeloupe',
        'GU' => 'Guam',
        'GT' => 'Guatemala',
        'GG' => 'Guernsey',
        'GN' => 'Guinea',
        'GW' => 'Guinea-Bissau',
        'GY' => 'Guyana',
        'HT' => 'Haiti',
        'HM' => 'Heard Island and McDonald Islands',
        'VA' => 'Holy See (Vatican City State)',
        'HN' => 'Honduras',
        'HK' => 'Hong Kong',
        'HU' => 'Hungary',
        'IS' => 'Iceland',
        'IN' => 'India',
        'ID' => 'Indonesia',
        'IR' => 'Iran',
        'IQ' => 'Iraq',
        'IE' => 'Ireland',
        'IM' => 'Isle of Man',
        'IL' => 'Israel',
        'IT' => 'Italy',
        'JM' => 'Jamaica',
        'JP' => 'Japan',
        'JE' => 'Jersey',
        'JO' => 'Jordan',
        'KZ' => 'Kazakhstan',
        'KE' => 'Kenya',
        'KI' => 'Kiribati',
        'KP' => 'Korea',
        'KR' => 'Korea',
        'KW' => 'Kuwait',
        'KG' => 'Kyrgyz Republic',
        'LA' => 'Lao',
        'LV' => 'Latvia',
        'LB' => 'Lebanon',
        'LS' => 'Lesotho',
        'LR' => 'Liberia',
        'LY' => 'Libyan Arab Jamahiriya',
        'LI' => 'Liechtenstein',
        'LT' => 'Lithuania',
        'LU' => 'Luxembourg',
        'MO' => 'Macao',
        'MK' => 'Macedonia',
        'MG' => 'Madagascar',
        'MW' => 'Malawi',
        'MY' => 'Malaysia',
        'MV' => 'Maldives',
        'ML' => 'Mali',
        'MT' => 'Malta',
        'MH' => 'Marshall Islands',
        'MQ' => 'Martinique',
        'MR' => 'Mauritania',
        'MU' => 'Mauritius',
        'YT' => 'Mayotte',
        'MX' => 'Mexico',
        'FM' => 'Micronesia',
        'MD' => 'Moldova',
        'MC' => 'Monaco',
        'MN' => 'Mongolia',
        'ME' => 'Montenegro',
        'MS' => 'Montserrat',
        'MA' => 'Morocco',
        'MZ' => 'Mozambique',
        'MM' => 'Myanmar',
        'NA' => 'Namibia',
        'NR' => 'Nauru',
        'NP' => 'Nepal',
        'AN' => 'Netherlands Antilles',
        'NL' => 'Netherlands the',
        'NC' => 'New Caledonia',
        'NZ' => 'New Zealand',
        'NI' => 'Nicaragua',
        'NE' => 'Niger',
        'NG' => 'Nigeria',
        'NU' => 'Niue',
        'NF' => 'Norfolk Island',
        'MP' => 'Northern Mariana Islands',
        'NO' => 'Norway',
        'OM' => 'Oman',
        'PK' => 'Pakistan',
        'PW' => 'Palau',
        'PS' => 'Palestinian Territory',
        'PA' => 'Panama',
        'PG' => 'Papua New Guinea',
        'PY' => 'Paraguay',
        'PE' => 'Peru',
        'PH' => 'Philippines',
        'PN' => 'Pitcairn Islands',
        'PL' => 'Poland',
        'PT' => 'Portugal, Portuguese Republic',
        'PR' => 'Puerto Rico',
        'QA' => 'Qatar',
        'RE' => 'Reunion',
        'RO' => 'Romania',
        'RU' => 'Russian Federation',
        'RW' => 'Rwanda',
        'BL' => 'Saint Barthelemy',
        'SH' => 'Saint Helena',
        'KN' => 'Saint Kitts and Nevis',
        'LC' => 'Saint Lucia',
        'MF' => 'Saint Martin',
        'PM' => 'Saint Pierre and Miquelon',
        'VC' => 'Saint Vincent and the Grenadines',
        'WS' => 'Samoa',
        'SM' => 'San Marino',
        'ST' => 'Sao Tome and Principe',
        'SA' => 'Saudi Arabia',
        'SN' => 'Senegal',
        'RS' => 'Serbia',
        'SC' => 'Seychelles',
        'SL' => 'Sierra Leone',
        'SG' => 'Singapore',
        'SK' => 'Slovakia (Slovak Republic)',
        'SI' => 'Slovenia',
        'SB' => 'Solomon Islands',
        'SO' => 'Somalia, Somali Republic',
        'ZA' => 'South Africa',
        'GS' => 'South Georgia and the South Sandwich Islands',
        'ES' => 'Spain',
        'LK' => 'Sri Lanka',
        'SD' => 'Sudan',
        'SR' => 'Suriname',
        'SJ' => 'Svalbard & Jan Mayen Islands',
        'SZ' => 'Swaziland',
        'SE' => 'Sweden',
        'CH' => 'Switzerland, Swiss Confederation',
        'SY' => 'Syrian Arab Republic',
        'TW' => 'Taiwan',
        'TJ' => 'Tajikistan',
        'TZ' => 'Tanzania',
        'TH' => 'Thailand',
        'TL' => 'Timor-Leste',
        'TG' => 'Togo',
        'TK' => 'Tokelau',
        'TO' => 'Tonga',
        'TT' => 'Trinidad and Tobago',
        'TN' => 'Tunisia',
        'TR' => 'Turkey',
        'TM' => 'Turkmenistan',
        'TC' => 'Turks and Caicos Islands',
        'TV' => 'Tuvalu',
        'UG' => 'Uganda',
        'UA' => 'Ukraine',
        'AE' => 'United Arab Emirates',
        'GB' => 'United Kingdom',
        'US' => 'United States of America',
        'UM' => 'United States Minor Outlying Islands',
        'VI' => 'United States Virgin Islands',
        'UY' => 'Uruguay, Eastern Republic of',
        'UZ' => 'Uzbekistan',
        'VU' => 'Vanuatu',
        'VE' => 'Venezuela',
        'VN' => 'Vietnam',
        'WF' => 'Wallis and Futuna',
        'EH' => 'Western Sahara',
        'YE' => 'Yemen',
        'ZM' => 'Zambia',
        'ZW' => 'Zimbabwe'
    );
	
	$key = array_search($code, $countryList);
	return $key;
   
}



 

add_action("admin_menu", "menu_item");

function menu_item()
{
  add_submenu_page("woocommerce", "Shipping Provider Settings", "Shipping Provider Settings", "manage_options", "scm_shipping_settings", "shipping_page");
}

function scm_settings_page()
{
    add_settings_section("section", "Shipping Providers Settings", null, "demo");
    add_settings_field("scm-shipping-mapping-file", "Mapping File", "demo_file_display", "demo", "section");  
    register_setting("section", "scm-shipping-mapping-file", "handle_file_upload");
}

function handle_file_upload($option)
{
	//print_r($_FILES);exit;
  if(!empty($_FILES["scm-shipping-mapping-file"]["tmp_name"]))
  {
    $urls = wp_handle_upload($_FILES["scm-shipping-mapping-file"], array('test_form' => FALSE));
    $temp = $urls["url"];
    return $temp;  
  }
 
  return $option;
}

function demo_file_display()
{
   ?>
        <input type="file" name="scm-shipping-mapping-file" />
        <?php echo get_option('scm-shipping-mapping-file'); ?>
   <?php
}

add_action("admin_init", "scm_settings_page");

function shipping_page()
{
  ?>
      <div class="wrap">
         <h1>SCMLog Provider Setting</h1>
 
         <form method="post" action="options.php" enctype="multipart/form-data">
            <?php
               settings_fields("section");
               do_settings_sections("demo");
               submit_button();
            ?>
         </form>
      </div>
   <?php
}

/**
 * Adds column
 *
 * @param string[] $columns
 * @return string[] $new_columns
 */
function add_scmlog_status_column_header( $columns ) {

    $new_columns = array();

    foreach ( $columns as $column_name => $column_info ) {

        $new_columns[ $column_name ] = $column_info;

        if ( 'order_total' === $column_name ) {
            $new_columns['scmlog_status'] = __( 'Aurobees Status', 'my-textdomain' );
        }
    }

    return $new_columns;
}

function manage_scmlog_status_column_value( $column, $order_id )
{
    switch ( $column )
    {
        case 'scmlog_status' :
			$order = wc_get_order( $order_id );
			//echo "<pre>";print_r($order->get_created_via());
			
			if( $order->get_status() == 'on-hold' ) {
				echo "Waiting"; 
			}
			elseif($order->get_status() == 'shipped' || $order->get_status() == 'completed')
			{
				echo "Handover to 3PL"; 
			}				
			else {
				echo "Allocated";
			}				
		
		break;
	}
}

// cron for create market place orders to scm


function admin_sms_alert($order_id)
{
    global $woocommerce, $post;
    //$order = $woocommerce -> WC_Order($order_id);
	$order = WC_Order($order_id);
	//echo "<pre>";print_r($order);die;
}


// cron for bulk product create to scm

function myprefix_custom_cron_schedule( $schedules ) {
    $schedules['every_six_hours'] = array(
        'interval' => 21600, // Every 6 hours
        'display'  => __( 'Every 6 hours' ),
    );
    return $schedules;
}
add_filter( 'cron_schedules', 'myprefix_custom_cron_schedule' );

//Schedule an action if it's not already scheduled
if ( ! wp_next_scheduled( 'woo_to_scm_product_upload_hook' ) ) {
    wp_schedule_event( time(), 'every_six_hours', 'woo_to_scm_product_upload_hook' );
}

///Hook into that action that'll fire every six hours
 add_action( 'woo_to_scm_product_upload_hook', 'woo_to_scm_product_upload');

//create your function, that runs on cron

//add_action('woo_to_scm_product_create', 'woo_to_scm_product_upload');

function woo_to_scm_product_upload()
{  
	global $wpdb;
	
	$client_shipper_code = get_option('wc_settings_scmprofit_shipper_code');	
	$UOM 				 = get_option('wc_settings_scmprofit_uom');
	$booking_office 	 = get_option('wc_settings_scmprofit_booking_office');// fetch from setings
		
	$query = "SELECT p.ID,p.post_title,t.term_id,t.name FROM " . $wpdb->prefix . "posts as p LEFT JOIN " . $wpdb->prefix . "term_relationships ON (p.ID = " . $wpdb->prefix . "term_relationships.object_id) LEFT JOIN " . $wpdb->prefix . "term_taxonomy ON (" . $wpdb->prefix . "term_relationships.term_taxonomy_id = " . $wpdb->prefix . "term_taxonomy.term_taxonomy_id) LEFT JOIN " . $wpdb->prefix . "terms as t ON (t.term_id = " . $wpdb->prefix . "term_relationships.term_taxonomy_id) WHERE p.post_status = 'publish' AND p.post_type = 'product' AND " . $wpdb->prefix . "term_taxonomy.taxonomy = 'product_cat' group by p.ID ORDER BY post_date DESC";
	//echo $query;die;
	$results = $wpdb->get_results($query);
		
	foreach($results as $productsdata)
	{	
		$product_id = $productsdata->ID;
		$product_title = $productsdata->post_title;	
		$category_id = $productsdata->term_id;	
		$category_name = $productsdata->name;			
				
		$product_data = array(
		'action' 				=> 'Add',
		'ProductCode' 			=> $product_id,		
		'ProductDescription' 	=> $product_title,
		'Barcode' 				=> $product_id,
		'BaseUOM' 				=> $UOM,
		'Code'		    		=> $client_shipper_code,
		'office_code' 			=> $booking_office,
		'category_id' 			=> $category_id,
		'category_name' 		=> $category_name,
		
		);
				
		$xml = Cust_Functions::convert_to_xml_product($product_id,$product_data);
		AzureServices::sync_data_product($xml);		
	}		
}
//do_action( 'woo_to_scm_product_upload_hook');


/*
 * delete product from SCM
*/
function delete_for_product( $post_id = ''){
	
	$post_types = get_post_type( $post_id );
    if ( isset( $_GET['post'] ) && is_array( $_GET['post'] ) && in_array( $_GET['post_type'], array('product')) && $_GET['action'] == 'delete') {
		
        foreach ( $_GET['post'] as $post_id ) {		
            delete_product_scm( $post_id );
        }
		
    } 
	elseif($post_types == 'product' && $_GET['action'] == 'delete')
	{
		delete_product_scm( $post_id );
	}
}

function delete_product_scm( $post_id ){
		  $product = wc_get_product( $post_id );
		  if(!empty($product)){    
				$product_id = $product->get_id();
				//$product_id = $product->get_id();
				//genrate product details xml
				$product_details = generate_product_xml($product_id,'Delete');				
								
				//product is delete request integrate and send product details to SCM using azure service
				AzureServices::sync_data_product($product_details);
		  }
		  
}

/*
 * Send product creation to SCM
*/
function product_save_scm($new_status, $old_status, $post) {
	
	if($old_status != 'publish' && $new_status == 'publish' && !empty($post->ID) && in_array( $post->post_type, array('product'))) 
	 {
		 // code for create product
		 
		  $product = wc_get_product( $post->ID );
		  $product_id = $product->get_id();
			//genrate order details xml
		  $product_details = generate_product_xml($product_id,'Add');				
						
			//product is created - so now integrate and send product details to SCM using azure service
			AzureServices::sync_data_product($product_details);
		 // echo "<pre>";print_r($product);die;
	 }
	 elseif($old_status == 'publish' && $new_status == 'publish' && !empty($post->ID) && in_array( $post->post_type, array('product')))
	 {
		 // code for update product
		 
		 $product = wc_get_product( $post->ID );
		 $product_id = $product->get_id();
			//genrate order details xml
		 $product_details = generate_product_xml($product_id,'Edit');				
						
			//product is created - so now integrate and send product details to SCM using azure service
		 AzureServices::sync_data_product($product_details);
	 }
	 

  }
  

/*
 * Send order creation to SCM
*/
function order_created($order_id) {
        
	//genrate order details xml
	$order_details = generate_xml($order_id,'Add') ;
		
		//set order status on hold
	$order = wc_get_order( $order_id );
	if( $order->get_status() == 'processing' ) {
		$order->update_status( 'on-hold' );
    }
	
	//order is created - so now integrate and send order details to SCM using azure service
	AzureServices::sync_data($order_details);



}

/*
 * Send order updation to SCM
*/
function order_updated($order_id) {
        
	//genrate order details xml
	$order_details = generate_xml($order_id,'Edit') ;

	//order is created - so now integrate and send order details to SCM using azure service
	AzureServices::sync_data($order_details);
    
}

/*
 * Send order cancel to SCM
*/
function order_cancelled($order_id) {
	        
	//genrate order details xml
	$order_details = generate_xml($order_id,'delete') ;

	//order is created - so now integrate and send order details to SCM using azure service
	AzureServices::sync_data($order_details);
}

function  generate_xml($order_id,$action) {
	//ger order data
	$order_data = get_order_data($order_id,$action);

	//convert data to xml
	$xml = Cust_Functions::convert_to_xml($order_id,$order_data);
	return $xml;

}

function  generate_product_xml($product_id,$action) {
	//ger product data
	$product_data = get_product_data($product_id,$action);
	
	//convert product to xml
	$xml = Cust_Functions::convert_to_xml_product($product_id,$product_data);
	return $xml;

}

function get_product_data($product_id,$action) {
	
	//get product basic details
	$product = wc_get_product($product_id);	
	
	$client_shipper_code = get_option('wc_settings_scmprofit_shipper_code');
	$marketplace		 = "woocommerce";//get_option('wc_settings_scmprofit_shipper_code'); //"WooCommerce";
	$due_date 			 = get_option('wc_settings_scmprofit_due_date');
	$due_date_timezone 	 = get_option('wc_settings_scmprofit_due_date_timezone');
	$UOM 				 = get_option('wc_settings_scmprofit_uom');
	$booking_office 	 = get_option('wc_settings_scmprofit_booking_office');// fetch from setings

	//$category = wc_get_product_category_list ($product_id);	
	
	$terms = get_the_terms( $product_id , 'product_cat');
	
	
	$category = array();
	if (is_array($terms) || is_object($terms))
	{
		foreach($terms as $term)
		{	
			$category['cat_id'] = $term->term_id;	
			$category['cat_name'] = $term->name;				
		}
	}
	//echo "<pre>";print_r($category);die;
	$category_id = $category['cat_id'];
	$category_name = $category['cat_name'];
	/*$count_cat =count($category);
	
	if($count_cat>1)
	{
		$category = implode(', ', $category);
	}
	else
	{
		$category = $category[0];
	}*/
	
	//get product array	
	
	$product_data = array(
		'action' 				=> $action,
		'ProductCode' 			=> $product_id,		
		'ProductDescription' 	=> $product->get_title(),
		'Barcode' 				=> $product_id,
		'BaseUOM' 				=> $UOM,
		'Code'		    		=> $client_shipper_code,
		'office_code' 			=> $booking_office,
		'category_id' 			=> $category_id,
		'category_name' 		=> $category_name,
		
	);

    return $product_data;
}


function get_order_data($order_id,$action) {

	$order = new WC_Order( $order_id );
	
	//get order basic details
	$client_shipper_code = get_option('wc_settings_scmprofit_shipper_code');
	$marketplace		 = get_option('wc_settings_scmprofit_shipper_code'); //"WooCommerce";
	$due_date 			 = get_option('wc_settings_scmprofit_due_date');
	$due_date_timezone 	 = get_option('wc_settings_scmprofit_due_date_timezone');
	$UOM 				 = get_option('wc_settings_scmprofit_uom');
	$booking_office 	 = get_option('wc_settings_scmprofit_booking_office');// fetch from setings

	//calculate order due date time
	$order_date 			= date('Y-m-d H:i:s', strtotime(get_post($order->get_id())->post_date));
	$order_due_date_dt 		= strtotime($order_date."+ ".$due_date." days");
	$order_due_date 		=  date("Ymd",$order_due_date_dt);
	$order_due_date_time 	=  date("Hi",$order_due_date_dt);

	//get shiiping provider details
	$shipping_provider_details = get_shipping_provider_details($order_id);
	//echo "<pre>";print_r($shipping_provider_details);die;
	/*$courier 				= "BDX";
	$courier_service_type 	= "reguler";
	$tracking_number 		= "1234567";*/

	$courier 				= $shipping_provider_details['name'];
	$courier_service_type 	= $shipping_provider_details['type'];
	$tracking_number 		= $shipping_provider_details['number'];

	//get product array
	$line_items = array();
	
	foreach ( $order->get_items() as $id => $item ) {
		$product = $item->get_product();
		if( !is_object( $product ) ) {
			continue;
		}
		$line_item['Action']= $action;
		$line_item['ProductCode'] = $product->get_id(); //substr( $product->get_id(), 0, 31 );
		$line_item['Quantity'] = array (
			'Value' => $item->get_quantity(),
			'Uom' => $UOM,
		);
		$line_item['UnitVolume'] = array('Value' => $order->get_item_total( $item ));
		$line_item['BrandSeller']= $client_shipper_code;
		$line_item['OrderDetails'] = array('SKULineNo' => $product->get_id() ); ////substr( $product->get_id(), 0, 31 )
		
		$line_items[]['Product'] = $line_item;
	}
	if($order->get_shipping_country() != '')
	{
		$code = $order->get_shipping_country();
	}
	else
	{
		$code = $order->get_billing_country();
	}
	$order_data = array(
		'action' 				=> $action,
		'booking_no' 			=> $order_id,
		'booking_date' 			=> date('Ymd', strtotime(get_post($order->get_id())->post_date)),
		'client_code' 			=> $client_shipper_code,
		'shipper_code' 			=> $client_shipper_code,
		'cust_ref_no' 			=> $order_id,
		'marketplace'		    => $marketplace,
		'due_date' 				=> $order_due_date,
		'due_date_time' 		=> $order_due_date_time,
		'due_date_timezone' 	=> $due_date_timezone,
		'courier' 				=> $courier,
		'courier_service_type'  => $courier_service_type,
		'tracking_number' 		=> $tracking_number,
		'booking_office' 		=> $booking_office,
		'party_name' 			=> $order->get_billing_first_name()." ".$order->get_shipping_last_name(),
		'address1'				=> $order->get_billing_address_1(),
		'city' 					=> $order->get_billing_city(),
		'state' 				=> $order->get_billing_state(),
		'zipcode' 				=> $order->get_billing_postcode(),
		'country_code' 			=> $code,
		'contact_number' 		=> $order->get_billing_phone(),
		'products' 				=> $line_items,
		'shippingcost' 			=> $order->get_shipping_total(),
	);
	
    return $order_data;
}

function get_shipping_provider_details($order_id) {

	//global $shipping_providers;
	/*$name = 'DHL';
	$type = 'regular';
	$number = '1234567';*/
	
	$selected_shipping_providers = get_option('wc_settings_scmprofit_shipping_provider');
	$shipping_providers = Cust_Functions::get_csv_file_data();
	// if shipping method available
	if(count($shipping_providers) > 0) {

		foreach($selected_shipping_providers as $selected_shipping_provider) {
			if(isset ($shipping_providers[$selected_shipping_provider])) {
				foreach($shipping_providers[$selected_shipping_provider] as $key => $value) {
					$shipping_provider_meta = get_post_meta($order_id, $key, true);					
					if($shipping_provider_meta && is_array($shipping_provider_meta)) {						
						$name_key = $shipping_providers[$selected_shipping_provider][$key]['shipping_provider_name'];
						$type_key = $shipping_providers[$selected_shipping_provider][$key]['shipping_service_type'];
						$number_key = $shipping_providers[$selected_shipping_provider][$key]['shipping_tracking_number'];						
						$name = $shipping_provider_meta[0][$name_key];						
						//$type = $shipping_provider_meta[0][$type_key];
						$type = 'regular';
						$number = $shipping_provider_meta[0][$number_key];				
						
					}
					else
					{
						$name = get_option('wc_settings_scmprofit_courier_name');// fetch from setings
						$type = 'regular';
						$number = $order_id;
					}
					
				}
				
				break;
			}
		}
	}
	else{
		// if shipping method not available
		$name = get_option('wc_settings_scmprofit_courier_name');// fetch from setings
		$type = 'regular';
		$number = $order_id;
	}

	return array  ( 
		'name' => $name,
		'type' => $type,
		'number' => $number
	);

}


// code for create custom order status

function register_shipped_order_status() {
    register_post_status( 'wc-shipped', array(
        'label'                     => 'Shipment Processing',
        'public'                    => true,
        'exclude_from_search'       => false,
        'show_in_admin_all_list'    => true,
        'show_in_admin_status_list' => true,
        'label_count'               => _n_noop( 'Shipment Processing <span class="count">(%s)</span>', 'Shipment Processing <span class="count">(%s)</span>' )
    ) );
}
add_action( 'init', 'register_shipped_order_status' );


add_filter( 'wc_order_statuses', 'custom_order_status');
function custom_order_status( $order_statuses ) {
    $order_statuses['wc-shipped'] = _x( 'Shipment Processing', 'Order status', 'woocommerce' ); 
    return $order_statuses;
}
