<?php 

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_filter( 'woocommerce_settings_tabs_array', 'add_settings_tab', 50 );
add_action( 'woocommerce_settings_scmprofit','settings_tab' );
add_action( 'woocommerce_update_options_scmprofit','update_settings' );
   
function add_settings_tab( $settings_tabs ) {
    $settings_tabs['scmprofit'] = __( 'Aurobees', 'woocommerce-settings-scmprofit' );
    return $settings_tabs;
}

function settings_tab() {
    woocommerce_admin_fields( get_settings_data() );
}

function update_settings() {
    woocommerce_update_options( get_settings_data() );
}

function get_settings_data() {

    global $shipping_providers;

    //get shipping settings array
    $settings_provider_options = Cust_Functions::get_csv_file_data();
    $shiping_options = array();
    foreach($settings_provider_options as $key => $value) {
        $shiping_options[$key] = $key;
    }
    
    $settings = array(
        'endpoint_details' => array(
            'name'     => __( 'Default Setting Details', 'woocommerce-settings-scmlog' ),
            'type'     => 'title',
            'desc'     => 'To get the below setup details kindly register on <a href="https://www.aurobees.com/" target="_blank"><u>https://www.aurobees.com</u></a>',
            'id'       => 'wc_settings_scmprofit_endpoint_details'
        ),
        'endpoint' => array(
            'name' => __( 'Azure Endpoint', 'woocommerce-settings-scmlog' ),
            'type' => 'text',
            'desc' => __( 'Azure Endpoint URL', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_scmprofit_endpoint'
        ),
        'queue_name' => array(
            'name' => __( 'Azure Queue Name', 'woocommerce-settings-scmlog' ),
            'type' => 'text',
            'desc' => __( 'Azure Queue Name', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_scmprofit_queue_name'
        ),
		'product_token' => array(
            'name' => __( 'Product Token', 'woocommerce-settings-scmlog' ),
            'type' => 'text',
            'desc' => __( 'Product Token', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_product_token'
        ),
		'product_api_url' => array(
            'name' => __( 'Product API Url', 'woocommerce-settings-scmlog' ),
            'type' => 'text',
            'desc' => __( 'Product Master API URL', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_product_api_url'
        ),
		'product_api_username' => array(
            'name' => __( 'Product API Username', 'woocommerce-settings-scmlog' ),
            'type' => 'text',
            'desc' => __( 'Product Master API Username', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_product_api_username'
        ),
		'product_api_password' => array(
            'name' => __( 'Product API Password', 'woocommerce-settings-scmlog' ),
            'type' => 'text',
            'desc' => __( 'Product Master API Password', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_product_api_password'
        ),
        'shipper_code' => array(
            'name' => __( 'Shipper Code', 'woocommerce-settings-scmlog' ),
            'type' => 'text',
            'desc' => __( 'Shipper Code', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_scmprofit_shipper_code'
        ),
        'uom' => array(
            'name' => __( 'UOM', 'woocommerce-settings-scmlog' ),
            'type' => 'text',
            'desc' => __( 'UOM', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_scmprofit_uom'
        ),
        'due_date' => array(
            'name' => __( 'Due Date (days)', 'woocommerce-settings-scmlog' ),
            'type' => 'text',
            'desc' => __( 'Due Date', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_scmprofit_due_date'
        ),
        'due_date_timezone' => array(
            'name' => __( 'Due Date TimeZone', 'woocommerce-settings-scmlog' ),
            'type' => 'text',
            'desc' => __( 'Due Date TimeZone', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_scmprofit_due_date_timezone'
        ),
        'booking_office' => array(
            'name' => __( 'Booking Office', 'woocommerce-settings-scmlog' ),
            'type' => 'text',
            'desc' => __( 'Booking Office', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_scmprofit_booking_office'
        ),
        'customer_id' => array(
            'name' => __( 'Customer ID', 'woocommerce-settings-scmlog' ),
            'type' => 'text',
            'desc' => __( 'Customer ID', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_scmprofit_customer_id'
        ),
		'customer_name' => array(
            'name' => __( 'Customer Name', 'woocommerce-settings-scmlog' ),
            'type' => 'text',
            'desc' => __( 'Customer Name', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_scmprofit_customer_name'
        ),
		'courier_name' => array(
            'name' => __( 'Courier Name', 'woocommerce-settings-scmlog' ),
            'type' => 'text',
            'desc' => __( 'Courier Name if Self Shipping', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_scmprofit_courier_name'
        ),
        'shipping_provider' => array(
            'name' => __( 'Shipping Provider', 'woocommerce-settings-scmlog' ),
            'type' => 'multiselect',
            'desc' => __( 'Shipping Provider', 'woocommerce-settings-scmlog' ),
            'id'   => 'wc_settings_scmprofit_shipping_provider',
            'options'     => 
				 $shiping_options
			
        ),
        'section_end' => array(
            'type' => 'sectionend',
            'id' => 'wc_settings_scmprofit_endpoint_details'
        ),
                
        
    );
    return apply_filters( 'wc_settings_scmlog', $settings );
}
		