<?php
/**
 * Block space widget.
 *
 * @package RedParts\Sputnik
 * @since 1.0.0
 */

namespace RedParts\Sputnik\Widgets;

use RedParts\Sputnik\Widget;

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'RedParts\Sputnik\Widgets\Block_Space' ) ) {

	/**
	 * Class Block_Products_Carousel
	 */
	class Block_Space extends Widget {
		/**
		 * Map of valid layouts.
		 *
		 * @var array
		 */
		protected $valid_layouts = array();

		/**
		 * Indicates whether to display the widget title or not.
		 *
		 * @var bool
		 */
		protected $display_title = false;

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->valid_layouts = array(
				'after-header'           => esc_html__( 'After header', 'redparts-sputnik' ),
				'before-footer'          => esc_html__( 'Before footer', 'redparts-sputnik' ),
				'spaceship-ledge-height' => esc_html__( 'Spaceship ledge height', 'redparts-sputnik' ),
				'divider-xs'             => esc_html__( 'XS', 'redparts-sputnik' ),
				'divider-sm'             => esc_html__( 'SM', 'redparts-sputnik' ),
				'divider-nl'             => esc_html__( 'NL', 'redparts-sputnik' ),
				'divider-lg'             => esc_html__( 'LG', 'redparts-sputnik' ),
				'divider-xl'             => esc_html__( 'XL', 'redparts-sputnik' ),
			);

			$widget_ops = array(
				'classname'                   => 'widget_redparts_sputnik_block_space',
				'description'                 => esc_html_x( 'Displays space.', 'Admin', 'redparts-sputnik' ),
				'customize_selective_refresh' => true,
			);

			parent::__construct(
				'redparts_sputnik_block_space',
				esc_html_x( 'RedParts: Block Space', 'Admin', 'redparts-sputnik' ),
				$widget_ops
			);
		}

		/**
		 * Echoes the widget body content.
		 *
		 * @param array $args     Display arguments including 'before_title', 'after_title', 'before_widget', and 'after_widget'.
		 * @param array $instance The settings for the particular instance of the widget.
		 */
		protected function widget_body( array $args, array $instance ) {
			if ( ! isset( $instance['layout'] ) || ! isset( $this->valid_layouts[ $instance['layout'] ] ) ) {
				return;
			}

			$layout = $instance['layout'];

			?>
			<div class="th-block-space th-block-space--layout--<?php echo esc_attr( $layout ); ?>"></div>
			<?php
		}

		/**
		 * Returns form fields.
		 *
		 * @return array
		 */
		public function form_fields(): array {
			$options = array();

			foreach ( $this->valid_layouts as $key => $name ) {
				$options[] = array(
					'key'   => $key,
					'label' => $name,
				);
			}

			return array(
				array(
					'key'     => 'layout',
					'label'   => esc_html__( 'Layout', 'redparts-sputnik' ),
					'type'    => 'select',
					'options' => $options,
				),
			);
		}
	}
}
