<?php

/**
 * An external standard for Auropay.
 *
 * @package AuroPay_Gateway_For_WooCommerce
 * @link    https://auropay.net/
 */

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Save the error logs in woocommerce
 *
 * @package AuroPay_Gateway_For_WooCommerce
 * @link    https://auropay.net/
 */
class Custom_Functions {
	/**
	 * Log
	 *
	 * @param $message error message
	 * @param string $level   information of error log
	 *
	 * @return void
	 */
	public static function log( $message, $level = 'info' ) {
		$options = get_option( 'woocommerce_auropay_settings' );
		$logging = $options['logging'];

		if ( 'no' != $logging ) {
			$log = wc_get_logger();
			$log->log( $level, $message, array( 'source' => WC_HP_PLUGIN_NAME ) );
		}
	}

	/**
	 * This will return currency symbol - which will use to display in CSV and PDF
	 *
	 * @return void
	 */
	public function getCurrencySymbol() {
		$currency = get_woocommerce_currency();
		$symbols = array(
			'AED' => 'د.إ',
			'AFN' => '؋',
			'ALL' => 'L',
			'AMD' => 'AMD',
			'ANG' => 'ƒ',
			'AOA' => 'Kz',
			'ARS' => '$',
			'AUD' => '$',
			'AWG' => 'ƒ',
			'AZN' => 'AZN',
			'BAM' => 'KM',
			'BBD' => '$',
			'BDT' => '৳ ',
			'BGN' => 'лв.',
			'BHD' => '.د.ب',
			'BIF' => 'Fr',
			'BMD' => '$',
			'BND' => '$',
			'BOB' => 'Bs.',
			'BRL' => 'R$',
			'BSD' => '$',
			'BTC' => '฿',
			'BTN' => 'Nu.',
			'BWP' => 'P',
			'BYR' => 'Br',
			'BZD' => '$',
			'CAD' => '$',
			'CDF' => 'Fr',
			'CHF' => 'CHF',
			'CLP' => '$',
			'CNY' => '¥',
			'COP' => '$',
			'CRC' => '₡',
			'CUC' => '$',
			'CUP' => '$',
			'CVE' => '$',
			'CZK' => 'Kč',
			'DJF' => 'Fr',
			'DKK' => 'DKK',
			'DOP' => 'RD$',
			'DZD' => 'د.ج',
			'EGP' => 'EGP',
			'ERN' => 'Nfk',
			'ETB' => 'Br',
			'EUR' => '€',
			'FJD' => '$',
			'FKP' => '£',
			'GBP' => '£',
			'GEL' => 'ლ',
			'GGP' => '£',
			'GHS' => '₵',
			'GIP' => '£',
			'GMD' => 'D',
			'GNF' => 'Fr',
			'GTQ' => 'Q',
			'GYD' => '$',
			'HKD' => '$',
			'HNL' => 'L',
			'HRK' => 'Kn',
			'HTG' => 'G',
			'HUF' => 'Ft',
			'IDR' => 'Rp',
			'ILS' => '₪',
			'IMP' => '£',
			'INR' => '₹',
			'IQD' => 'ع.د',
			'IRR' => '﷼',
			'IRT' => 'تومان',
			'ISK' => 'kr.',
			'JEP' => '£',
			'JMD' => '$',
			'JOD' => 'د.ا',
			'JPY' => '¥',
			'KES' => 'KSh',
			'KGS' => 'сом',
			'KHR' => '៛',
			'KMF' => 'Fr',
			'KPW' => '₩',
			'KRW' => '₩',
			'KWD' => 'د.ك',
			'KYD' => '$',
			'KZT' => 'KZT',
			'LAK' => '₭',
			'LBP' => 'ل.ل',
			'LKR' => 'රු',
			'LRD' => '$',
			'LSL' => 'L',
			'LYD' => 'ل.د',
			'MAD' => 'د.م.',
			'MDL' => 'MDL',
			'MGA' => 'Ar',
			'MKD' => 'ден',
			'MMK' => 'Ks',
			'MNT' => '₮',
			'MOP' => 'P',
			'MRO' => 'UM',
			'MUR' => '₨',
			'MVR' => '.ރ',
			'MWK' => 'MK',
			'MXN' => '$',
			'MYR' => 'RM',
			'MZN' => 'MT',
			'NAD' => '$',
			'NGN' => '₦',
			'NIO' => 'C$',
			'NOK' => 'kr',
			'NPR' => '₨',
			'NZD' => '$',
			'OMR' => 'ر.ع.',
			'PAB' => 'B/.',
			'PEN' => 'S/.',
			'PGK' => 'K',
			'PHP' => '₱',
			'PKR' => '₨',
			'PLN' => 'zł',
			'PRB' => 'р.',
			'PYG' => '₲',
			'QAR' => 'ر.ق',
			'RMB' => '¥',
			'RON' => 'lei',
			'RSD' => 'дин.',
			'RUB' => '₽',
			'RWF' => 'Fr',
			'SAR' => 'ر.س',
			'SBD' => '$',
			'SCR' => '₨',
			'SDG' => 'ج.س.',
			'SEK' => 'kr',
			'SGD' => '$',
			'SHP' => '£',
			'SLL' => 'Le',
			'SOS' => 'Sh',
			'SRD' => '$',
			'SSP' => '£',
			'STD' => 'Db',
			'SYP' => 'ل.س',
			'SZL' => 'L',
			'THB' => '฿',
			'TJS' => 'ЅМ',
			'TMT' => 'm',
			'TND' => 'د.ت',
			'TOP' => 'T$',
			'TRY' => '₺',
			'TTD' => '$',
			'TWD' => 'NT$',
			'TZS' => 'Sh',
			'UAH' => '₴',
			'UGX' => 'UGX',
			'USD' => '$',
			'UYU' => '$',
			'UZS' => 'UZS',
			'VEF' => 'Bs F',
			'VND' => '₫',
			'VUV' => 'Vt',
			'WST' => 'T',
			'XAF' => 'Fr',
			'XCD' => '$',
			'XOF' => 'Fr',
			'XPF' => 'Fr',
			'YER' => '﷼',
			'ZAR' => 'R',
			'ZMW' => 'ZK',
		);
		$currency_symbol = isset( $symbols[$currency] ) ? $symbols[$currency] : '';
		//return $currency_symbol;
		return '&#8377';
	}
}
