<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'wp_ajax_ajax_tracking_shipment', 'auroship_ajax_tracking_shipment' );
add_action( 'wp_enqueue_scripts', 'auroship_tracking_js' );
add_action( 'admin_head', 'auroship_tracking_js' );

/**
 * Get the data after generating the label
 *
 * @return string
 */
function auroship_ajax_tracking_shipment() {
	if ( isset( $_POST['tracking_action'] ) && 'tracking_shipment' == $_POST['tracking_action'] ) {
		$order_id = isset( $_POST['order_id'] ) ? intval( $_POST['order_id'] ) : 0;

		$tracking_id = get_post_meta( $order_id, '_tracking_id', true );
		$carrier_id = get_post_meta( $order_id, '_carrier_id', true );
		$params['trackingId'] = $tracking_id;
		$params['carrierId'] = $carrier_id;
		$res = Auroship_API::get_shipping_tracking( $params, $order_id );
		$departed_found = false;
		$delivered_found = false;

		if ( !empty( $res['success'] ) ) {
			$order = wc_get_order( $order_id );

			$tracking_id = get_post_meta( $order_id, '_tracking_id', true );
			$promised_delivery_date = get_post_meta( $order_id, '_promised_delivery_date', true );
			$tracking_history = get_post_meta( $order_id, '_tracking_history', true );
			$shipping_status = get_post_meta( $order_id, '_shipping_status', true );

			if ( !empty( $promised_delivery_date ) && strtotime( $promised_delivery_date ) !== false ) {
				$formatted_date = new DateTime( $promised_delivery_date );
				$estimated_delivery_date = $formatted_date->format( 'd-m-Y' );
			} else {
				$estimated_delivery_date = '';
			}
			$shipping_data = [
				'tracking_id' => $tracking_id,
				'estimated_delivery_date' => $estimated_delivery_date,
				'tracking_history' => $tracking_history,
				'shipping_status' => $shipping_status,
			];

			$buyer_fname = get_post_meta( $order_id, '_buyer_fname', true );
			$buyer_email = get_post_meta( $order_id, '_buyer_email', true );
			$seller_fname = get_post_meta( $order_id, '_seller_fname', true );
			$seller_email = get_post_meta( $order_id, '_seller_email', true );

			$tracking_history_data = json_decode( $tracking_history, true );

			// Check the eventHistory array for Departed and Delivered events
			if ( isset( $tracking_history_data['payload']['eventHistory'] ) && is_array( $tracking_history_data['payload']['eventHistory'] ) ) {
				foreach ( $tracking_history_data['payload']['eventHistory'] as $event ) {
					if ( isset( $event['eventCode'] ) ) {
						if ( 'Departed' === $event['eventCode'] ) {
							$departed_found = true;
						}
						if ( 'Delivered' === $event['eventCode'] ) {
							$delivered_found = true;
						}
					}
				}
			}

			$status = '';
			$email_data = [];

			if ( $departed_found && !$delivered_found ) {
				if ( $order->get_status() !== 'shipped' && $order->get_status() !== 'delivered' ) {
					$order->update_status( 'shipped' );
					$status = 'shipped';
				}
			} elseif ( $delivered_found ) {
				if ( $order->get_status() !== 'delivered' ) {
					$order->update_status( 'delivered' );
					$status = 'delivered';
				}
			}

			if ( 'shipped' === $status || 'delivered' === $status ) {
				$email_data = [
					'order_number' => $order_id,
					'tracking_number' => $tracking_id,
					'delivery_date' => $estimated_delivery_date,
					'buyer_name' => $buyer_fname,
					'buyer_email' => $buyer_email,
					'seller_name' => $seller_fname,
					'seller_email' => $seller_email,
					'order_status' => $status,
				];
			}

			$response = array( 'shipping_data' => $shipping_data );
			if ( !empty( $email_data ) ) {
				$response['email_data'] = $email_data;
			}

			wp_send_json_success( $response );
			die();
		} else {
			wp_send_json_error( $res );
			die();
		}
	}
}

/**
 * JavaScript functionality to get tracking info
 *
 * @return void
 */
function auroship_tracking_js() {
	// Ensure jQuery is loaded
	wp_enqueue_script( 'jquery' );

	// Register the script
	if ( function_exists( 'dokan_is_seller_dashboard' ) && dokan_is_seller_dashboard() ) {
		wp_register_script( 'tracking-script', AUROSHIP_PLUGIN_URL . '/assets/js/tracking-shipment-script-dokan.js', array( 'jquery' ), null, true );
	} else {
		if ( is_admin() ) {
			wp_register_script( 'tracking-script', AUROSHIP_PLUGIN_URL . '/assets/js/tracking-shipment-script.js', array( 'jquery' ), null, true );
		}
	}

	$orderid = 0;
	if ( isset( $_GET['post'] ) && is_admin() ) {
		$orderid = intval( $_GET['post'] );
	}

	if ( isset( $_GET['id'] ) && is_admin() ) {
		$orderid = intval( $_GET['id'] );
	}

	if ( isset( $_GET['order_id'] ) ) {
		$orderid = intval( $_GET['order_id'] );
	}

	$php_data = array(
		'order_id' => $orderid,
		'ajax_url' => admin_url( 'admin-ajax.php' ),
	);

	wp_localize_script( 'tracking-script', 'phpVariables', $php_data );
	// Enqueue the script
	wp_enqueue_script( 'tracking-script' );
}
