(function ($) {
    "use strict";
    let wizard = "";
    const steps = rex_wpfm_wizard_translate_string;
    const necessaryPlugins = necessary_plugins;
    const popularMerchants = popular_merchants;
    const modifiedPopularMerchants = Object.entries(popularMerchants).map(([key, value]) => ({key, value}));
    const allMerchants = all_merchants;
    const { stepOne, stepTwo, stepThree, stepFour, stepFive } = steps;
    let merchantName = '';
    let ytVideosLink = yt_video;
    let isToggleButtonChecked = true;



    const prevToggle = () => {
        wizard.previousStep();
    };

    const nextToggle = () => {
        wizard.nextStep();
    };

    /**
     * Initializes a wizard if the wizard container exists, using the provided configuration steps.
     *
     * @param {Object} stepOne - Configuration for the first step of the wizard.
     * @param {Object} stepTwo - Configuration for the second step of the wizard.
     * @param {Object} stepThree - Configuration for the third step of the wizard.
     * @param {Object} stepFour - Configuration for the fourth step of the wizard.
     * @since 7.4.15
     */
    if ($("#wizardContainer")?.length > 0) {

        wizard = rexWizard({

          general: {
            title: "Welcome to the Wizard",
            currentStep: 0,
            logo: logoUrl,
            targetElement: "wizardContainer",
            logoStyles: "setup-wizard__logo",
          },
          steps: [
            {
              stepText: `${stepOne?.step_text}`,
              html: `<main class="setup-wizard__body-content">
              <!-- welcome section container -->
              <section class="setup-wizard__welcome-section-container">
                  <div class="setup-wizard__welcome-text-content">
                      <h1 class="setup-wizard__welcome-heading setup-wizard__heading-one">
                          ${stepOne?.heading}
                          <span class="setup-wizard__heading-one-highlight">${stepOne?.strong_heading[0]}</span>
                      </h1>
                      <p class="setup-wizard__welcome-description setup-wizard__description">
                        ${stepOne?.description}
                      </p>
                  </div>

                  <!-- video container -->
                  <div class="setup-wizard__welcome-video-container">
                      <div id="video_play_button" class="setup-wizard__video-play-button">
                          <button class="setup-wizard__shadow" aria-label="Play YouTube Video">
                              <svg width="100" height="70" viewBox="0 0 100 70" fill="none" xmlns="http://www.w3.org/2000/svg">
                                  <path d="M97.7467 10.9613C97.1734 8.84245 96.055 6.91079 94.5028 5.35872C92.9507 3.80666 91.0189 2.68836 88.9001 2.11523C81.1428 0 49.9254 0 49.9254 0C49.9254 0 18.7069 0.0641905 10.9508 2.17942C8.83206 2.75265 6.90045 3.87099 5.34839 5.42304C3.79634 6.9751 2.678 8.90671 2.10477 11.0255C-0.241546 24.8081 -1.15183 45.8081 2.16896 59.0387C2.74219 61.1575 3.86053 63.0891 5.41258 64.6412C6.96464 66.1932 8.89625 67.3115 11.015 67.8848C18.7717 70 49.9896 70 49.9896 70C49.9896 70 81.2076 70 88.9642 67.8848C91.083 67.3115 93.0146 66.1932 94.5667 64.6412C96.1187 63.0891 97.2371 61.1575 97.8103 59.0387C100.284 45.2372 101.047 24.2499 97.7461 10.9619" fill="#FF0000"></path>
                                  <path d="M39.9895 50.0004L65.887 35.0006L39.9895 20.0002V50.0004Z" fill="white"></path>
                              </svg>
                          </button>
                      </div>

                      <div id="setup_video" class="setup-wizard__welcome-video-iframe" style="display: none">
                          <iframe id="recommendation-video_set" title="Video"></iframe>
                      </div>
                      <img id="recommendation-preview" class="setup-wizard__welcome-video-preview" loading="lazy" src="${thumnailImage}" alt="${stepOne?.img_alt}">
                  </div>

                  <!-- setup wizard buttons -->
                  <div class="setup-wizard__main-buttons">
                      <a href="#" class="setup-wizard__button-left lets-create-first-feed">
                        ${stepOne?.button_text[0]} 
                      </a>
                      <a href="https://rextheme.com/docs/product-feed-manager-documentation/" target="_blank" class="setup-wizard__button-right">
                        ${stepOne?.button_text[1]} 
                      </a>
                  </div>

              </section>

              <!-- features container -->
              <section class="setup-wizard__features-section-container">
                  <div class="setup-wizard__features-text-content">
                      <h1 class="setup-wizard__feature-heading setup-wizard__heading-one">
                        <span class="setup-wizard__heading-one-highlight">${stepOne?.pfm_feature_content[0]}</span>
                      </h1>
                      <p class="setup-wizard__feature-description setup-wizard__description">
                        ${stepOne?.pfm_feature_content[1]}
                      </p>
                  </div>

              <div class="setup-wizard__feature-lists">
              
                <div class="setup-wizard__single-feature">
                  <div class="setup-wizard__feature-image">
                      <svg xmlns="http://www.w3.org/2000/svg" width="35" height="40" viewBox="0 0 35 40" fill="none">
                          <path d="M33.1999 18.8C33.1999 17.4746 32.1253 16.4 30.7999 16.4H4.3999C3.07455 16.4 2 17.4746 2 18.8C2 20.1254 3.07455 21.2 4.3999 21.2H30.7999C32.1253 21.2 33.1999 20.1254 33.1999 18.8Z" stroke="#7869E5" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                          <path d="M5.59985 21.2L15.1998 30.8V38L19.9999 35.6V30.8L29.5999 21.2H5.59985Z" stroke="#7869E5" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                          <path d="M29.5998 9.2C31.5863 9.2 33.1997 7.58657 33.1997 5.6C33.1997 3.61342 31.5863 2 29.5998 2C27.6131 2 25.9998 3.61342 25.9998 5.6C25.9998 7.58657 27.6131 9.2 29.5998 9.2Z" stroke="#7869E5" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                          <path d="M17.6002 11.6C19.5869 11.6 21.2002 9.98657 21.2002 8C21.2002 6.01343 19.5869 4.4 17.6002 4.4C15.6136 4.4 14.0002 6.01343 14.0002 8C14.0002 9.98657 15.6136 11.6 17.6002 11.6Z" stroke="#7869E5" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                          <path d="M5.59993 9.2C7.58657 9.2 9.19993 7.58657 9.19993 5.6C9.19993 3.61342 7.58657 2 5.59993 2C3.61335 2 2 3.61342 2 5.6C2 7.58657 3.61335 9.2 5.59993 9.2Z" stroke="#7869E5" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>
                  </div>

                  <div class="setup-wizard__feature-text-content">
                    <h6 class="setup-wizard__feature-heading">
                      ${stepOne?.pfm_feature_heading[0]}
                    </h6>
                    <p class="setup-wizard__feature-description">
                      ${stepOne?.pfm_feature_description[0]}
                    </p>
                  </div>

                </div>

                <div class="setup-wizard__single-feature">
                  <div class="setup-wizard__feature-image">
                      <svg xmlns="http://www.w3.org/2000/svg" width="36" height="33" viewBox="0 0 36 33" fill="none">
                          <path d="M28.5 0H7.5C3.3645 0 0 3.3645 0 7.5V25.5C0 29.6355 3.3645 33 7.5 33H28.5C32.6355 33 36 29.6355 36 25.5V7.5C36 3.3645 32.6355 0 28.5 0ZM33 25.5C33 27.981 30.981 30 28.5 30H7.5C5.019 30 3 27.981 3 25.5V7.5C3 5.019 5.019 3 7.5 3H28.5C30.981 3 33 5.019 33 7.5V25.5ZM28.5 9C28.5 9.828 27.828 10.5 27 10.5H16.5C15.672 10.5 15 9.828 15 9C15 8.172 15.672 7.5 16.5 7.5H27C27.828 7.5 28.5 8.172 28.5 9ZM12 9C12 10.242 10.992 11.25 9.75 11.25C8.508 11.25 7.5 10.242 7.5 9C7.5 7.758 8.508 6.75 9.75 6.75C10.992 6.75 12 7.758 12 9ZM28.5 16.5C28.5 17.328 27.828 18 27 18H16.5C15.672 18 15 17.328 15 16.5C15 15.672 15.672 15 16.5 15H27C27.828 15 28.5 15.672 28.5 16.5ZM12 16.5C12 17.742 10.992 18.75 9.75 18.75C8.508 18.75 7.5 17.742 7.5 16.5C7.5 15.258 8.508 14.25 9.75 14.25C10.992 14.25 12 15.258 12 16.5ZM28.5 24C28.5 24.828 27.828 25.5 27 25.5H16.5C15.672 25.5 15 24.828 15 24C15 23.172 15.672 22.5 16.5 22.5H27C27.828 22.5 28.5 23.172 28.5 24ZM12 24C12 25.242 10.992 26.25 9.75 26.25C8.508 26.25 7.5 25.242 7.5 24C7.5 22.758 8.508 21.75 9.75 21.75C10.992 21.75 12 22.758 12 24Z" fill="#EB79AD"/>
                      </svg>
                  </div>

                  <div class="setup-wizard__feature-text-content">
                    <h6 class="setup-wizard__feature-heading">
                      ${stepOne?.pfm_feature_heading[1]}
                    </h6>
                    <p class="setup-wizard__feature-description">
                      ${stepOne?.pfm_feature_description[1]}
                    </p>
                  </div>

                </div>

                <div class="setup-wizard__single-feature">
                  <div class="setup-wizard__feature-image">
                      <svg xmlns="http://www.w3.org/2000/svg" width="34" height="34" viewBox="0 0 34 34" fill="none">
                          <path d="M14.7678 12.5356V14.3034H13V16.955H14.7678V24.91H18.3033V16.955H20.6545L20.955 14.3034H18.3033V12.7566C18.3033 12.0406 18.374 11.6605 19.4788 11.6605H20.955V9H18.5862C15.7578 9.00008 14.7678 10.3259 14.7678 12.5356Z" fill="#216DF0"/>
                          <path d="M17 0C7.61115 0 0 7.61115 0 17C0 26.3888 7.61115 34 17 34C26.3888 34 34 26.3888 34 17C34 7.61115 26.3888 0 17 0ZM17 32.4545C8.46467 32.4545 1.54547 25.5353 1.54547 17C1.54547 8.46467 8.46467 1.54547 17 1.54547C25.5353 1.54547 32.4545 8.46467 32.4545 17C32.4545 25.5353 25.5353 32.4545 17 32.4545Z" fill="#216DF0"/>
                      </svg>
                  </div>

                  <div class="setup-wizard__feature-text-content">
                    <h6 class="setup-wizard__feature-heading">
                      ${stepOne?.pfm_feature_heading[2]}
                    </h6>
                    <p class="setup-wizard__feature-description">
                      ${stepOne?.pfm_feature_description[2]}
                    </p>
                  </div>

                </div>

                <div class="setup-wizard__single-feature">
                  <div class="setup-wizard__feature-image">
                      <svg xmlns="http://www.w3.org/2000/svg" width="38" height="28" viewBox="0 0 38 28" fill="none">
                          <path d="M6.22222 12.4444H31.1111C34.5427 12.4444 37.3333 9.65378 37.3333 6.22222C37.3333 2.79067 34.5427 0 31.1111 0H6.22222C2.79067 0 0 2.79067 0 6.22222C0 9.65378 2.79067 12.4444 6.22222 12.4444ZM34.2222 6.22222C34.2222 7.938 32.8269 9.33333 31.1111 9.33333H24.8889V3.11111H31.1111C32.8269 3.11111 34.2222 4.50644 34.2222 6.22222ZM6.22222 3.11111H21.7778V9.33333H6.22222C4.50644 9.33333 3.11111 7.938 3.11111 6.22222C3.11111 4.50644 4.50644 3.11111 6.22222 3.11111ZM31.1111 15.5556H6.22222C2.79067 15.5556 0 18.3462 0 21.7778C0 25.2093 2.79067 28 6.22222 28H31.1111C34.5427 28 37.3333 25.2093 37.3333 21.7778C37.3333 18.3462 34.5427 15.5556 31.1111 15.5556ZM3.11111 21.7778C3.11111 20.062 4.50644 18.6667 6.22222 18.6667H12.4444V24.8889H6.22222C4.50644 24.8889 3.11111 23.4936 3.11111 21.7778ZM31.1111 24.8889H15.5556V18.6667H31.1111C32.8269 18.6667 34.2222 20.062 34.2222 21.7778C34.2222 23.4936 32.8269 24.8889 31.1111 24.8889Z" fill="#5C76F6"/>
                      </svg>
                  </div>

                  <div class="setup-wizard__feature-text-content">
                    <h6 class="setup-wizard__feature-heading">
                      ${stepOne?.pfm_feature_heading[3]}
                    </h6>
                    <p class="setup-wizard__feature-description">
                      ${stepOne?.pfm_feature_description[3]}
                    </p>
                  </div>
                </div>

                <div class="setup-wizard__single-feature">
                  <div class="setup-wizard__feature-image">
                      <svg xmlns="http://www.w3.org/2000/svg" width="38" height="38" viewBox="0 0 38 38" fill="none">
                          <path d="M16 35.5C16 36.3295 15.3295 37 14.5 37H8.5C4.3645 37 1 33.6355 1 29.5V8.5C1 4.3645 4.3645 1 8.5 1H20.5C24.6355 1 28 4.3645 28 8.5V11.5C28 12.3295 27.3295 13 26.5 13C25.6705 13 25 12.3295 25 11.5V8.5C25 6.019 22.981 4 20.5 4H8.5C6.019 4 4 6.019 4 8.5V29.5C4 31.981 6.019 34 8.5 34H14.5C15.3295 34 16 34.6705 16 35.5ZM22 10C22 9.1705 21.3295 8.5 20.5 8.5H8.5C7.6705 8.5 7 9.1705 7 10C7 10.8295 7.6705 11.5 8.5 11.5H20.5C21.3295 11.5 22 10.8295 22 10ZM16 17.5C16 16.6705 15.3295 16 14.5 16H8.5C7.6705 16 7 16.6705 7 17.5C7 18.3295 7.6705 19 8.5 19H14.5C15.3295 19 16 18.3295 16 17.5ZM8.5 23.5C7.6705 23.5 7 24.1705 7 25C7 25.8295 7.6705 26.5 8.5 26.5H11.5C12.3295 26.5 13 25.8295 13 25C13 24.1705 12.3295 23.5 11.5 23.5H8.5ZM37 26.5C37 32.2885 32.2885 37 26.5 37C20.7115 37 16 32.2885 16 26.5C16 20.7115 20.7115 16 26.5 16C32.2885 16 37 20.7115 37 26.5ZM34 26.5C34 22.3645 30.6355 19 26.5 19C22.3645 19 19 22.3645 19 26.5C19 30.6355 22.3645 34 26.5 34C30.6355 34 34 30.6355 34 26.5ZM29.212 24.6385L25.8775 27.8395C25.6615 28.051 25.309 28.0555 25.0945 27.8425L23.398 26.1805C22.804 25.5985 21.856 25.6075 21.277 26.2015C20.6965 26.794 20.7055 27.742 21.298 28.3225L22.996 29.986C23.686 30.6595 24.589 30.997 25.4905 30.997C26.392 30.997 27.292 30.6595 27.97 29.9905L31.2895 26.8045C31.8865 26.23 31.906 25.2805 31.333 24.6835C30.7585 24.0835 29.8075 24.067 29.212 24.64V24.6385Z" fill="#D95080" stroke="#D95080" stroke-width="0.2"/>
                      </svg>
                  </div>

                  <div class="setup-wizard__feature-text-content">
                    <h6 class="setup-wizard__feature-heading">
                      ${stepOne?.pfm_feature_heading[4]}
                    </h6>

                    <p class="setup-wizard__feature-description">
                      ${stepOne?.pfm_feature_description[4]}
                    </p>
                  </div>

                </div>

                <div class="setup-wizard__single-feature">
                  <div class="setup-wizard__feature-image">
                      <svg xmlns="http://www.w3.org/2000/svg" width="36" height="36" viewBox="0 0 36 36" fill="none">
                          <path d="M13.7608 18.8479C13.703 18.5589 11.7145 8.61602 11.6514 8.30095C11.5529 7.80799 11.12 7.45312 10.6172 7.45312H8.50785C8.00511 7.45312 7.5722 7.80799 7.47369 8.30095C7.40964 8.62137 5.41902 18.5744 5.36432 18.8478C5.25006 19.419 5.62054 19.9747 6.19168 20.0888C6.76283 20.2031 7.31851 19.8326 7.4327 19.2615L8.10686 15.8906H11.0182L11.6924 19.2615C11.8066 19.833 12.3625 20.2032 12.9334 20.0889C13.5045 19.9747 13.875 19.419 13.7608 18.8479ZM8.52873 13.7812L9.37248 9.5625H9.75259L10.5963 13.7812H8.52873Z" fill="#00B4FF"/>
                          <path d="M30.6562 15.8906H27.4922V14.8359C27.4922 14.2535 27.02 13.7812 26.4375 13.7812C25.855 13.7812 25.3828 14.2535 25.3828 14.8359V15.8906H22.2188C21.6363 15.8906 21.1641 16.3628 21.1641 16.9453C21.1641 17.5278 21.6363 18 22.2188 18H22.474C23.0749 19.9415 23.9797 21.4317 24.9754 22.6259C24.165 23.3671 23.345 23.9749 22.6146 24.5592C22.1598 24.9231 22.086 25.5868 22.4499 26.0416C22.814 26.4967 23.4778 26.57 23.9323 26.2063C24.6668 25.6187 25.5472 24.9657 26.4375 24.1487C27.3284 24.9663 28.2104 25.6205 28.9427 26.2063C29.3975 26.5703 30.0613 26.4964 30.4251 26.0416C30.7889 25.5868 30.7152 24.923 30.2604 24.5592C29.5319 23.9763 28.7108 23.3678 27.8996 22.6259C28.8953 21.4317 29.8001 19.9415 30.401 18H30.6562C31.2387 18 31.7109 17.5278 31.7109 16.9453C31.7109 16.3628 31.2387 15.8906 30.6562 15.8906ZM26.4375 21.0758C25.7643 20.2307 25.1586 19.2219 24.702 17.993H28.173C27.7164 19.2219 27.1107 20.2307 26.4375 21.0758Z" fill="#00B4FF"/>
                          <path d="M32.8359 6.39844H17.6202L17.1681 2.77158C16.9706 1.19152 15.6209 0 14.0285 0H3.16406C1.4194 0 0 1.4194 0 3.16406V26.4375C0 28.1822 1.4194 29.6016 3.16406 29.6016H12.0574L12.5037 33.2284C12.7009 34.8053 14.0506 36 15.6434 36H32.8359C34.5806 36 36 34.5806 36 32.8359V9.5625C36 7.81784 34.5806 6.39844 32.8359 6.39844ZM3.16406 27.4922C2.58251 27.4922 2.10938 27.0191 2.10938 26.4375V3.16406C2.10938 2.58251 2.58251 2.10938 3.16406 2.10938H14.0285C14.5593 2.10938 15.0093 2.5065 15.075 3.03286C15.2279 4.25883 17.9724 26.2761 18.124 27.4922H3.16406ZM14.5353 32.4668L14.1827 29.6016H17.0123L14.5353 32.4668ZM33.8906 32.8359C33.8906 33.4175 33.4175 33.8906 32.8359 33.8906H16.0927L20.1078 29.2463C20.3134 29.0145 20.4055 28.7067 20.363 28.4008L17.8832 8.50781H32.8359C33.4175 8.50781 33.8906 8.98095 33.8906 9.5625V32.8359Z" fill="#00B4FF"/>
                      </svg>
                  </div>

                  <div class="setup-wizard__feature-text-content">
                    <h6 class="setup-wizard__feature-heading">
                      ${stepOne?.pfm_feature_heading[5]}
                    </h6>
                    <p class="setup-wizard__feature-description">
                      ${stepOne?.pfm_feature_description[5]}
                    </p>
                  </div>
                </div>

                <div class="setup-wizard__single-feature">
                  <div class="setup-wizard__feature-image">
                      <svg xmlns="http://www.w3.org/2000/svg" width="36" height="37" viewBox="0 0 36 37" fill="none">
                          <path d="M35.53 18.6591C35.53 17.3827 35.4155 16.1554 35.2027 14.9773H18.25V21.94H27.9373C27.52 24.19 26.2518 26.0964 24.3455 27.3727V31.8891H30.1627C33.5664 28.7554 35.53 24.1409 35.53 18.6591Z" fill="#4285F4"/>
                          <path d="M18.25 36.25C23.11 36.25 27.1845 34.6382 30.1627 31.8891L24.3455 27.3727C22.7336 28.4527 20.6718 29.0909 18.25 29.0909C13.5618 29.0909 9.59364 25.9246 8.17819 21.67H2.16455V26.3337C5.12637 32.2164 11.2136 36.25 18.25 36.25Z" fill="#34A853"/>
                          <path d="M8.17818 21.67C7.81818 20.59 7.61364 19.4364 7.61364 18.25C7.61364 17.0636 7.81818 15.91 8.17818 14.83V10.1664H2.16455C0.904545 12.6747 0.24889 15.443 0.250001 18.25C0.250001 21.1545 0.945456 23.9036 2.16455 26.3336L8.17818 21.67Z" fill="#FBBC05"/>
                          <path d="M18.25 7.40909C20.8927 7.40909 23.2655 8.31727 25.1309 10.1009L30.2936 4.93818C27.1764 2.03364 23.1018 0.25 18.25 0.25C11.2136 0.25 5.12637 4.28364 2.16455 10.1664L8.17819 14.83C9.59364 10.5755 13.5618 7.40909 18.25 7.40909Z" fill="#EA4335"/>
                      </svg>
                  </div>

                  <div class="setup-wizard__feature-text-content">
                    <h6 class="setup-wizard__feature-heading">
                      ${stepOne?.pfm_feature_heading[6]}
                    </h6>
                    <p class="setup-wizard__feature-description">
                      ${stepOne?.pfm_feature_description[6]}
                    </p>
                  </div>
                </div>

                <div class="setup-wizard__single-feature">
                  <div class="setup-wizard__feature-image">
                      <svg xmlns="http://www.w3.org/2000/svg" width="34" height="34" viewBox="0 0 34 34" fill="none">
                          <path d="M34 17.5833V21.8333C34 24.95 31.45 27.5 28.3333 27.5H4.81667L8.075 30.7583C8.64167 31.325 8.64167 32.175 8.075 32.7417C7.50833 33.3083 6.65833 33.3083 6.09167 32.7417L0.425 27.075C-0.141667 26.5083 -0.141667 25.6583 0.425 25.0917L6.09167 19.425C6.65833 18.8583 7.50833 18.8583 8.075 19.425C8.64167 19.9917 8.64167 20.8417 8.075 21.4083L4.81667 24.6667H28.3333C29.8917 24.6667 31.1667 23.3917 31.1667 21.8333V17.5833C31.1667 16.7333 31.7333 16.1667 32.5833 16.1667C33.4333 16.1667 34 16.7333 34 17.5833ZM33.575 6.09167L27.9083 0.425C27.3417 -0.141667 26.4917 -0.141667 25.925 0.425C25.3583 0.991667 25.3583 1.84167 25.925 2.40833L29.1833 5.66667H5.66667C2.55 5.66667 6.33299e-08 8.21667 6.33299e-08 11.3333V15.5833C6.33299e-08 16.4333 0.566667 17 1.41667 17C2.26667 17 2.83333 16.4333 2.83333 15.5833V11.3333C2.83333 9.775 4.10833 8.5 5.66667 8.5H29.1833L25.925 11.7583C25.3583 12.325 25.3583 13.175 25.925 13.7417C26.4917 14.3083 27.3417 14.3083 27.9083 13.7417L33.575 8.075C34.1417 7.50833 34.1417 6.65833 33.575 6.09167Z" fill="#216DF0"/>
                      </svg>
                  </div>

                  <div class="setup-wizard__feature-text-content">
                    <h6 class="setup-wizard__feature-heading">
                      ${stepOne?.pfm_feature_heading[7]}
                    </h6>
                    <p class="setup-wizard__feature-description">
                      ${stepOne?.pfm_feature_description[7]}
                    </p>
                  </div>

                </div>

              </div>

              <!-- setup wizard buttons -->
              <div class="setup-wizard__feature-list-button-container">
                <a href="https://rextheme.com/best-woocommerce-product-feed/product-feed-manager-features/" target="_blank" class="setup-wizard__feature-list-button">
                  Check All Features
                  <svg width="17" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M15.171 7.02277L1.47856 6.65834" stroke="#73707D" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                    <path d="M10.0348 11.8971L15.1709 7.008L10.2614 1.85151" stroke="#73707D" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                  </svg>
                </a>
              </div>

              <!--pro features -->
              <div class="setup-wizard__pro-features-section-container">
                <div class="setup-wizard__pro-features">
                  <div class="setup-wizard__pro-features-text-content">
                    <h2 class="setup-wizard__pro-feature-heading">
                      ${stepOne?.pfm_feature_pro_heading[0]}
                      <span class="setup-wizard__pro-feature-heading-highlight">${stepOne?.pfm_feature_pro_heading[1]}</span>
                    </h2>
                  </div>

                  <div class="setup-wizard__pro-feature-lists">

                    <div class="setup-wizard__single-pro-feature">
                      <svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20" fill="none">
                          <path d="M16.625 0H4.375C1.96263 0 0 1.96263 0 4.375V14.875C0 17.2874 1.96263 19.25 4.375 19.25H16.625C19.0374 19.25 21 17.2874 21 14.875V4.375C21 1.96263 19.0374 0 16.625 0ZM19.25 14.875C19.25 16.3223 18.0723 17.5 16.625 17.5H4.375C2.92775 17.5 1.75 16.3223 1.75 14.875V4.375C1.75 2.92775 2.92775 1.75 4.375 1.75H16.625C18.0723 1.75 19.25 2.92775 19.25 4.375V14.875ZM16.625 5.25C16.625 5.733 16.233 6.125 15.75 6.125H9.625C9.142 6.125 8.75 5.733 8.75 5.25C8.75 4.767 9.142 4.375 9.625 4.375H15.75C16.233 4.375 16.625 4.767 16.625 5.25ZM7 5.25C7 5.9745 6.412 6.5625 5.6875 6.5625C4.963 6.5625 4.375 5.9745 4.375 5.25C4.375 4.5255 4.963 3.9375 5.6875 3.9375C6.412 3.9375 7 4.5255 7 5.25ZM16.625 9.625C16.625 10.108 16.233 10.5 15.75 10.5H9.625C9.142 10.5 8.75 10.108 8.75 9.625C8.75 9.142 9.142 8.75 9.625 8.75H15.75C16.233 8.75 16.625 9.142 16.625 9.625ZM7 9.625C7 10.3495 6.412 10.9375 5.6875 10.9375C4.963 10.9375 4.375 10.3495 4.375 9.625C4.375 8.9005 4.963 8.3125 5.6875 8.3125C6.412 8.3125 7 8.9005 7 9.625ZM16.625 14C16.625 14.483 16.233 14.875 15.75 14.875H9.625C9.142 14.875 8.75 14.483 8.75 14C8.75 13.517 9.142 13.125 9.625 13.125H15.75C16.233 13.125 16.625 13.517 16.625 14ZM7 14C7 14.7245 6.412 15.3125 5.6875 15.3125C4.963 15.3125 4.375 14.7245 4.375 14C4.375 13.2755 4.963 12.6875 5.6875 12.6875C6.412 12.6875 7 13.2755 7 14Z" fill="#EB79AD"/>
                      </svg>
                      <p class="setup-wizard__single-pro-feature-title">
                          ${stepOne?.pfm_feature_pro_list_heading[0]}
                      </p>
                    </div>

                    <div class="setup-wizard__single-pro-feature">
                      <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
                          <path d="M20.3941 10.702H16.7595V9.44248C18.5881 9.15119 19.9903 7.56331 19.9903 5.65395V4.84627C19.9903 4.51175 19.719 4.24051 19.3845 4.24051C19.05 4.24051 18.7787 4.51175 18.7787 4.84627V5.65395C18.7787 6.89287 17.9158 7.93331 16.7595 8.20763V7.67319C16.7595 7.11649 16.3066 6.66359 15.7499 6.66359H15.1441V4.44247C15.1441 3.16828 14.2314 2.10359 13.0254 1.86697L13.4765 0.852001C13.6124 0.546311 13.4747 0.188286 13.169 0.0524417C12.8632 -0.0834841 12.5053 0.0542464 12.3694 0.359977L11.7216 1.81751H9.27819L8.63043 0.359895C8.49459 0.0542054 8.13656 -0.0835252 7.83087 0.0523597C7.52518 0.188204 7.38749 0.546229 7.52334 0.851919L7.97443 1.86689C6.76853 2.10355 5.85576 3.16816 5.85576 4.44239V6.66351H5.25C4.6933 6.66351 4.2404 7.1164 4.2404 7.67311V8.20754C3.08417 7.93327 2.2212 6.89279 2.2212 5.65387V4.84619C2.2212 4.51166 1.94997 4.24043 1.61544 4.24043C1.28092 4.24043 1.00968 4.51166 1.00968 4.84619V5.65387C1.00968 7.56323 2.4118 9.15107 4.24045 9.4424V10.7019H0.60576C0.271237 10.7019 0 10.9731 0 11.3077C0 11.6422 0.271237 11.9134 0.60576 11.9134H4.24036V13.1729C2.41172 13.4642 1.0096 15.0521 1.0096 16.9615V17.7692C1.0096 18.1037 1.28084 18.3749 1.61536 18.3749C1.94988 18.3749 2.22112 18.1037 2.22112 17.7692V16.9615C2.22112 15.7226 3.08409 14.6821 4.24032 14.4078V14.7403C4.24036 18.1919 7.04842 21 10.4999 21C13.9514 21 16.7595 18.1919 16.7595 14.7404V14.4079C17.9157 14.6822 18.7787 15.7227 18.7787 16.9616V17.7693C18.7787 18.1038 19.0499 18.375 19.3845 18.375C19.719 18.375 19.9902 18.1038 19.9902 17.7693V16.9616C19.9902 15.0522 18.5881 13.4644 16.7595 13.1731V11.9136H20.3941C20.7286 11.9136 20.9998 11.6423 20.9998 11.3078C20.9998 10.9733 20.7286 10.702 20.3941 10.702ZM7.06724 4.44243C7.06724 3.66305 7.70131 3.02899 8.48069 3.02899H12.5191C13.2985 3.02899 13.9326 3.66305 13.9326 4.44243V6.66355H7.06724V4.44243ZM15.548 14.7404C15.548 17.5239 13.2834 19.7885 10.4999 19.7885C7.71644 19.7885 5.45188 17.5239 5.45188 14.7404V7.87511H9.89417V13.7308C9.89417 14.0654 10.1654 14.3366 10.4999 14.3366C10.8345 14.3366 11.1057 14.0654 11.1057 13.7308V7.87511H15.548V14.7404Z" fill="#DF52FF"/>
                      </svg>
                      <p class="setup-wizard__single-pro-feature-title">
                          ${stepOne?.pfm_feature_pro_list_heading[1]}
                      </p>
                    </div>

                    <div class="setup-wizard__single-pro-feature">
                      <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
                      <path d="M17.3372 9.27907H15.3837C13.02 9.27907 11.7209 7.98 11.7209 5.61628V3.66279C11.7209 1.29907 13.02 0 15.3837 0H17.3372C19.7009 0 21 1.29907 21 3.66279V5.61628C21 7.98 19.7009 9.27907 17.3372 9.27907ZM15.3837 1.46512C13.8405 1.46512 13.1861 2.11953 13.1861 3.66279V5.61628C13.1861 7.15953 13.8405 7.81395 15.3837 7.81395H17.3372C18.8805 7.81395 19.5349 7.15953 19.5349 5.61628V3.66279C19.5349 2.11953 18.8805 1.46512 17.3372 1.46512H15.3837Z" fill="#00B4FF"/>
                      <path d="M5.61628 21H3.66279C1.29907 21 0 19.7009 0 17.3372V15.3837C0 13.02 1.29907 11.7209 3.66279 11.7209H5.61628C7.98 11.7209 9.27907 13.02 9.27907 15.3837V17.3372C9.27907 19.7009 7.98 21 5.61628 21ZM3.66279 13.1861C2.11953 13.1861 1.46512 13.8405 1.46512 15.3837V17.3372C1.46512 18.8805 2.11953 19.5349 3.66279 19.5349H5.61628C7.15953 19.5349 7.81395 18.8805 7.81395 17.3372V15.3837C7.81395 13.8405 7.15953 13.1861 5.61628 13.1861H3.66279Z" fill="#00B4FF"/>
                      <path d="M4.63953 9.27907C2.08047 9.27907 0 7.1986 0 4.63953C0 2.08047 2.08047 0 4.63953 0C7.1986 0 9.27907 2.08047 9.27907 4.63953C9.27907 7.1986 7.1986 9.27907 4.63953 9.27907ZM4.63953 1.46512C2.89116 1.46512 1.46512 2.89116 1.46512 4.63953C1.46512 6.38791 2.89116 7.81395 4.63953 7.81395C6.38791 7.81395 7.81395 6.38791 7.81395 4.63953C7.81395 2.89116 6.38791 1.46512 4.63953 1.46512Z" fill="#00B4FF"/>
                      <path d="M16.3605 21C13.8014 21 11.7209 18.9196 11.7209 16.3605C11.7209 13.8014 13.8014 11.7209 16.3605 11.7209C18.9196 11.7209 21 13.8014 21 16.3605C21 18.9196 18.9196 21 16.3605 21ZM16.3605 13.1861C14.6121 13.1861 13.1861 14.6121 13.1861 16.3605C13.1861 18.1089 14.6121 19.5349 16.3605 19.5349C18.1089 19.5349 19.5349 18.1089 19.5349 16.3605C19.5349 14.6121 18.1089 13.1861 16.3605 13.1861Z" fill="#00B4FF"/>
                      </svg>
                      <p class="setup-wizard__single-pro-feature-title">
                          ${stepOne?.pfm_feature_pro_list_heading[2]}
                      </p>
                    </div>

                    <div class="setup-wizard__single-pro-feature">
                      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="22" viewBox="0 0 24 22" fill="none">
                          <path d="M22.0606 1.3495H12.4694C12.215 1.3495 11.9711 1.45055 11.7912 1.63042C11.6113 1.81029 11.5103 2.05424 11.5103 2.30861V5.44493L9.20841 1.455C9.04044 1.16206 8.79811 0.918655 8.50592 0.749381C8.21372 0.580108 7.88202 0.490967 7.54434 0.490967C7.20666 0.490967 6.87496 0.580108 6.58277 0.749381C6.29058 0.918655 6.04825 1.16206 5.88027 1.455L0.125568 11.4202C0.0413876 11.566 -0.00292969 11.7314 -0.00292969 11.8998C-0.00292969 12.0682 0.0413876 12.2335 0.125568 12.3793C0.21007 12.5257 0.331748 12.6472 0.478279 12.7314C0.624811 12.8156 0.790994 12.8596 0.96 12.8589H5.07461C4.88839 13.4812 4.79468 14.1276 4.79647 14.7771C4.79647 16.5578 5.50382 18.2654 6.7629 19.5245C8.02199 20.7836 9.72968 21.491 11.5103 21.491C13.2909 21.491 14.9986 20.7836 16.2577 19.5245C17.5168 18.2654 18.2241 16.5578 18.2241 14.7771C18.2259 14.1276 18.1322 13.4812 17.946 12.8589H22.0606C22.315 12.8589 22.5589 12.7579 22.7388 12.578C22.9187 12.3981 23.0197 12.1542 23.0197 11.8998V2.30861C23.0197 2.05424 22.9187 1.81029 22.7388 1.63042C22.5589 1.45055 22.315 1.3495 22.0606 1.3495ZM2.61927 10.9407L7.53955 2.41412L10.8293 8.06332C9.87014 8.17006 8.94524 8.48235 8.11767 8.9789C7.29009 9.47544 6.5793 10.1446 6.03373 10.9407H2.61927ZM11.5103 19.5727C10.5618 19.5727 9.63464 19.2915 8.84601 18.7645C8.05738 18.2376 7.44272 17.4886 7.07975 16.6123C6.71678 15.7361 6.62181 14.7718 6.80685 13.8416C6.99189 12.9113 7.44863 12.0568 8.1193 11.3862C8.78998 10.7155 9.64447 10.2587 10.5747 10.0737C11.505 9.88866 12.4692 9.98363 13.3455 10.3466C14.2218 10.7096 14.9707 11.3242 15.4977 12.1129C16.0246 12.9015 16.3059 13.8287 16.3059 14.7771C16.3059 16.049 15.8006 17.2688 14.9013 18.1681C14.0019 19.0675 12.7822 19.5727 11.5103 19.5727ZM21.1015 10.9407H17.0156C16.1446 9.69713 14.8815 8.78187 13.4285 8.34146V3.26773H21.1015V10.9407Z" fill="#AA7038"/>
                      </svg>
                      <p class="setup-wizard__single-pro-feature-title">
                          ${stepOne?.pfm_feature_pro_list_heading[3]}
                      </p>
                    </div>

                    <div class="setup-wizard__single-pro-feature">
                      <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                      <path d="M19.85 10.4773C19.85 9.76819 19.7864 9.08637 19.6682 8.43182H10.25V12.3H15.6318C15.4 13.55 14.6955 14.6091 13.6364 15.3182V17.8273H16.8682C18.7591 16.0864 19.85 13.5227 19.85 10.4773Z" fill="#4285F4"/>
                      <path d="M10.2501 20.25C12.9501 20.25 15.2137 19.3545 16.8683 17.8272L13.6364 15.3181C12.741 15.9181 11.5955 16.2727 10.2501 16.2727C7.64554 16.2727 5.44099 14.5136 4.65463 12.15H1.31372V14.7409C2.95917 18.0091 6.34099 20.25 10.2501 20.25Z" fill="#34A853"/>
                      <path d="M4.65455 12.15C4.45455 11.55 4.34091 10.9091 4.34091 10.25C4.34091 9.59091 4.45455 8.95 4.65455 8.35V5.75909H1.31364C0.613636 7.1526 0.249383 8.69056 0.250001 10.25C0.250001 11.8636 0.636364 13.3909 1.31364 14.7409L4.65455 12.15Z" fill="#FBBC05"/>
                      <path d="M10.2501 4.22727C11.7183 4.22727 13.0364 4.73182 14.0728 5.72273L16.941 2.85455C15.2092 1.24091 12.9455 0.25 10.2501 0.25C6.34099 0.25 2.95917 2.49091 1.31372 5.75909L4.65463 8.35C5.44099 5.98636 7.64554 4.22727 10.2501 4.22727Z" fill="#EA4335"/>
                      </svg>
                      <p class="setup-wizard__single-pro-feature-title">
                          ${stepOne?.pfm_feature_pro_list_heading[4]}
                      </p>
                    </div>

                    <div class="setup-wizard__single-pro-feature">
                      <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
                          <path d="M13.4399 9.31116C13.4399 8.96093 13.1559 8.67694 12.8057 8.67694H5.82929C5.47906 8.67694 5.19507 8.96093 5.19507 9.31116C5.19507 9.66139 5.47906 9.94538 5.82929 9.94538H12.8057C13.1559 9.94538 13.4399 9.66139 13.4399 9.31116Z" fill="#3F04FE"/>
                          <path d="M5.82782 11.8798C5.47759 11.8798 5.1936 12.1637 5.1936 12.514C5.1936 12.8642 5.47759 13.1482 5.82782 13.1482H9.52673C9.87696 13.1482 10.161 12.8642 10.161 12.514C10.161 12.1637 9.87696 11.8798 9.52673 11.8798H5.82782Z" fill="#3F04FE"/>
                          <path d="M17.6187 9.3464C17.2684 9.3464 16.9844 9.63039 16.9844 9.98062V15.11C16.9844 16.0698 16.2036 16.8506 15.2439 16.8506H11.0016C10.8642 16.8506 10.7303 16.895 10.6204 16.9782L6.95742 19.7328C6.8644 19.8026 6.77702 19.7737 6.73333 19.7497C6.68894 19.7272 6.61565 19.6715 6.61847 19.558L6.68894 17.5074C6.69457 17.3355 6.63045 17.1684 6.51135 17.0451C6.39226 16.9211 6.22736 16.8513 6.05542 16.8513H3.10912C2.14933 16.8513 1.36854 16.0712 1.36854 15.1108V6.72496C1.36854 5.76165 2.14933 4.97803 3.10912 4.97803H10.9241C11.2743 4.97803 11.5583 4.69404 11.5583 4.34381C11.5583 3.99358 11.2743 3.70959 10.9241 3.70959H3.10912C1.45028 3.70959 0.100098 5.0626 0.100098 6.72566V15.1108C0.100098 16.7696 1.45028 18.1205 3.10912 18.1205H5.39865L5.35073 19.5172C5.33382 20.0908 5.63895 20.6123 6.14844 20.8765C6.36619 20.99 6.60085 21.0456 6.8334 21.0456C7.14557 21.0456 7.45493 20.9449 7.71849 20.7483L11.213 18.1205H15.2432C16.902 18.1205 18.2522 16.7703 18.2522 15.1108V9.98132C18.2529 9.63039 17.9689 9.3464 17.6187 9.3464Z" fill="#3F04FE"/>
                          <path d="M21.0471 3.30509C20.9323 2.95275 20.6497 2.68919 20.291 2.6004L18.6702 2.19662L17.7851 0.780193C17.3926 0.150201 16.368 0.151611 15.9762 0.780193L15.0911 2.19662L13.4703 2.6004C13.1116 2.68919 12.8283 2.95275 12.7142 3.30509C12.6 3.65744 12.6733 4.03726 12.9115 4.32125L13.9854 5.59956L13.8685 7.26544C13.8424 7.6347 14.0059 7.98493 14.3054 8.20268C14.4914 8.33798 14.7099 8.40774 14.9311 8.40774C15.0657 8.40774 15.2017 8.38167 15.3321 8.32882L16.881 7.70305L18.4292 8.32882C18.7724 8.46834 19.1557 8.42043 19.4559 8.20338C19.7554 7.98563 19.9189 7.6354 19.8935 7.26544L19.7766 5.59956L20.8505 4.32055C21.088 4.03726 21.162 3.65744 21.0471 3.30509ZM18.6399 4.98014C18.5342 5.10628 18.4813 5.26835 18.4933 5.43325L18.6061 7.03289L17.1192 6.43179C17.0431 6.40079 16.962 6.38529 16.8817 6.38529C16.8014 6.38529 16.7203 6.40079 16.6442 6.43179L15.158 7.03289L15.2701 5.43325C15.2814 5.26906 15.2285 5.10628 15.1235 4.98014L14.0925 3.75257L15.6485 3.36429C15.8078 3.32412 15.9459 3.22476 16.0326 3.08523L16.8824 1.72588L17.7323 3.08523C17.8196 3.22476 17.9571 3.32482 18.1163 3.36429L19.6723 3.75257L18.6399 4.98014Z" fill="#3F04FE"/>
                      </svg>
                      <p class="setup-wizard__single-pro-feature-title">
                          ${stepOne?.pfm_feature_pro_list_heading[5]}
                      </p>
                    </div>

                    <div class="setup-wizard__single-pro-feature">
                      <svg xmlns="http://www.w3.org/2000/svg" width="21" height="19" viewBox="0 0 21 19" fill="none">
                      <path d="M20.7611 14.2167C20.5932 13.796 20.116 13.591 19.6953 13.759C19.2745 13.927 19.0696 14.4041 19.2375 14.8249C19.451 15.3598 19.381 15.9706 19.0502 16.4589C18.7192 16.9474 18.1892 17.2276 17.5962 17.2276H3.40711C2.76025 17.2276 2.18582 16.89 1.87045 16.3246C1.55459 15.7582 1.56944 15.0908 1.91016 14.5391L9.00472 3.05251C9.32776 2.52948 9.88734 2.21722 10.5017 2.21722C11.116 2.21722 11.6755 2.52948 11.9986 3.05251L17.2456 11.5478C17.4837 11.9333 17.9892 12.0528 18.3745 11.8146C18.7599 11.5766 18.8794 11.0712 18.6413 10.6858L13.3943 2.19044C12.7702 1.17998 11.6888 0.576721 10.5016 0.576721C9.31443 0.576721 8.23309 1.18002 7.609 2.19044L0.514434 13.677C-0.143294 14.7421 -0.171923 16.0305 0.437775 17.1237C1.04698 18.216 2.15699 18.868 3.40711 18.868H17.5962C18.7421 18.868 19.7671 18.3253 20.4083 17.379C21.0447 16.4399 21.1765 15.2577 20.7611 14.2167Z" fill="#5C76F6"/>
                      <path d="M10.5021 15.6281C10.9551 15.6281 11.3223 15.2609 11.3223 14.8079C11.3223 14.3549 10.9551 13.9877 10.5021 13.9877H10.5017C10.0486 13.9877 9.68164 14.3549 9.68164 14.8079C9.68164 15.2609 10.0491 15.6281 10.5021 15.6281Z" fill="#5C76F6"/>
                      <path d="M11.3219 11.937V5.90824C11.3219 5.45523 10.9546 5.08801 10.5016 5.08801C10.0486 5.08801 9.6814 5.45523 9.6814 5.90824V11.937C9.6814 12.39 10.0486 12.7572 10.5016 12.7572C10.9546 12.7572 11.3219 12.39 11.3219 11.937Z" fill="#5C76F6"/>
                      </svg>
                      <p class="setup-wizard__single-pro-feature-title">
                          ${stepOne?.pfm_feature_pro_list_heading[6]}
                      </p>
                    </div>

                    <div class="setup-wizard__single-pro-feature">
                      <svg xmlns="http://www.w3.org/2000/svg" width="22" height="25" viewBox="0 0 22 25" fill="none">
                      <path d="M21 16.5533V7.66439C20.9996 7.27469 20.8967 6.89195 20.7017 6.55457C20.5067 6.21718 20.2264 5.93701 19.8889 5.74216L12.1111 1.29772C11.7733 1.10268 11.3901 1 11 1C10.6099 1 10.2267 1.10268 9.88889 1.29772L2.11111 5.74216C1.77363 5.93701 1.49331 6.21718 1.29829 6.55457C1.10327 6.89195 1.0004 7.27469 1 7.66439V16.5533C1.0004 16.943 1.10327 17.3257 1.29829 17.6631C1.49331 18.0005 1.77363 18.2806 2.11111 18.4755L9.88889 22.9199C10.2267 23.115 10.6099 23.2177 11 23.2177C11.3901 23.2177 11.7733 23.115 12.1111 22.9199L19.8889 18.4755C20.2264 18.2806 20.5067 18.0005 20.7017 17.6631C20.8967 17.3257 20.9996 16.943 21 16.5533Z" stroke="#00B4FF" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                      <path d="M1.30005 6.50885L11 12.12L20.7 6.50885" stroke="#00B4FF" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                      <path d="M11 23.3089V12.1089" stroke="#00B4FF" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                      </svg>

                      <p class="setup-wizard__single-pro-feature-title">
                          ${stepOne?.pfm_feature_pro_list_heading[7]}
                      </p>
                    </div>

                  </div>

                </div>

                  <div class="setup-wizard__pro-features-price">
                      <p class="setup-wizard__discount-price-label">Starting at <span style="font-weight:600; color:#216DF0;">$63.99</span>/year</p>
                      <p>Normally $79.99/year</p>
                  </div>

                <div class="setup-wizard__pro-feature-list-button-container">
                  <a href="https://rextheme.com/best-woocommerce-product-feed/pricing/" target="_blank" class="setup-wizard__pro-feature-list-button">
                    Upgrade To Pro Now
                    <svg width="17" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M15.171 7.02277L1.47856 6.65834" stroke="#ffffff" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                      <path d="M10.0348 11.8971L15.1709 7.008L10.2614 1.85151" stroke="#ffffff" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                    </svg>
                  </a>
                </div>
              </div>
            </section>

            <!-- setup wizard buttons -->
            <section class="setup-wizard__footer-buttons">
              <a href="#" class="setup-wizard__button-left lets-create-first-feed">
                Let’s create your first feed
              </a>
              <a href="#" class="setup-wizard__button-right next-step-button"> Next </a>
            </section>

        </main>`,
              isNextStep: true,
              isPreviousStep: false,
              isSkip: false,
            },
            {
              stepText: `${stepTwo?.step_text}`,
              html: `
              <main class="setup-wizard__body-content">
                  <section class="setup-wizard__welcome-section-container">
                    <h2 class="setup-wizard__main-heading">
                      ${stepTwo.heading}
                        <span class="setup-wizard__main-heading-highlight">${stepTwo?.strong_heading[0]}</span>
                    </h2>

                    <div class="rex-wpfm-setup-wizard-essential-plugin">
        
                      <div class="rex-wpfm-setup-plugins-wrapper">

                        <div class="rex-wpfm-setup-single-plugin" data-plugin="woocommerce">

                          <div class="setup-wizard__checkbox-container">
                            <input type="checkbox" id="woocommerce" checked disabled>
                            <label for="woocommerce"></label>
                          </div>
                          
                          <div class="rex-wpfm-setup-plugin-logo">
                            <img src="${woocommerceUrl}"  alt="WooCommerce Logo" id="rex-wpfm-wc-logo"/>
                          </div>

                          <div class="rex-wpfm-setup-plugin-info">
                            <h3 class="rex-wpfm-setup-plugin-heading">WooCommerce</h3>
                            <p class="rex-wpfm-setup-plugin-subheading">Required for Product Feed.</p>
                          </div>

                          <span class="rex-wpfm-required-tag">Required</span>
                                        
                        </div>

                        <div class="rex-wpfm-setup-no-plugin-needed" style="display: none;">
                          <img src="http://localhost:10024/wp-content/uploads/2024/06/image-6.png"  alt="No Plugin Needed" id="rex-wpfm-no-plugin-img"/>
                        </div>

                      </div>

                    </div>
                  </section>
                  <!-- welcome-section-container -->
              
                  <section class="setup-wizard__welcome-section-container">
              
                      <h2 class="setup-wizard__main-heading ">
                        ${stepFour.heading}
                          <span class="setup-wizard__main-heading-highlight">${stepFour?.strong_heading[0]}</span>
                      </h2>

                        <div class="rex-wpfm-setup-wizard-page-builder-selection">
                          <div class="search-merchant-wrapper">
                              <input type="text" id="search_merchant" name="search_merchant" placeholder="Search your merchant">
                              <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                              <path d="M9 17C13.4183 17 17 13.4183 17 9C17 4.58172 13.4183 1 9 1C4.58172 1 1 4.58172 1 9C1 13.4183 4.58172 17 9 17Z" stroke="#6C798F" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                              <path d="M19 18.9999L14.65 14.6499" stroke="#6C798F" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                              </svg>
                          </div>
                          <div id="popular_merchants" class="rex-wpfm-setup-wizard-page-builder-wrapper"></div>
                          <div id="search-results" class="rex-wpfm-setup-wizard-page-builder-wrapper"></div>
                        </div>
                  </section>

                  <!-- setup wizard buttons -->
                  <section class="setup-wizard__footer-buttons">
                    <a href="#" class="setup-wizard__button-left lets-create-first-feed">
                      Let’s create your first feed
                    </a>
                    <a href="#" class="setup-wizard__button-right next-step-button">  Next </a>
                  </section>

                </main>
                  `,
              isNextStep: true,
              isPreviousStep: true,
              isSkip: true,
            },
            {
              stepText: `${stepThree?.step_text}`,
              html: `
                   <main class="setup-wizard__body-content">
                  <!-- done section container -->
                  <section class="setup-wizard__done-section-container">
                    <!-- text content -->
                    <div class="setup-wizard__done-text-content setup-wizard__done-text-content--done-icon">

                      <svg xmlns="http://www.w3.org/2000/svg" width="63" height="50" viewBox="0 0 63 50" fill="none">
                        <path d="M28.5173 0C27.7776 0.245902 27.3705 0.819672 26.929 1.89155C28.1821 2.64466 29.258 3.70905 30.0711 5C30.4324 4.23707 30.8911 3.85246 31.929 3.28499C31.0103 1.94265 29.8486 0.824145 28.5173 0Z" fill="url(#paint0_linear_2083_42)"/>
                        <path d="M6.8632 11C8.42842 9.58755 9.5228 8.31517 10 6.69844C9.27904 5.84953 8.26493 5.25063 7.12407 5C6.55542 6.65516 5.46906 8.12054 4 9.214C5.46978 9.52918 6.27784 9.92023 6.8632 11Z" fill="#FF44BC"/>
                        <path d="M4 26.366C3.20341 26.0034 2.52632 25.244 1.633 23C0.866845 23.6494 0.294407 24.5776 0 25.6477C0.668138 27.0311 1.62025 28.1853 2.7653 29C2.92952 27.9847 3.36267 27.0607 4 26.366Z" fill="url(#paint1_linear_2083_42)"/>
                        <path d="M51.2501 10.2419C53.7606 8.99918 55.1516 8.51349 57.515 8.63293C57.3194 7.54072 57.3654 6.8157 57.7709 6.24135C55.2212 5.93799 53.4531 6.33534 50.6749 7.41476C50.615 8.39132 50.8134 9.36643 51.2501 10.2419Z" fill="url(#paint2_linear_2083_42)"/>
                        <path d="M62.1065 24C60.4858 24.7257 58.7533 25.0842 57.0087 25.0548C56.9494 26.0919 57.1949 27.1222 57.7075 27.9876C59.4928 28.0587 61.2774 27.8244 63 27.293C62.0435 26.0388 61.7399 25.2284 62.1065 24Z" fill="#EE8134"/>
                        <circle cx="34" cy="32" r="17.5" stroke="#216DF0"/>
                        <path d="M41.9848 26.3328L30.6515 37.6661L25.5 32.5146" stroke="#216DF0" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
                        <defs>
                          <linearGradient id="paint0_linear_2083_42" x1="6162.56" y1="2165.93" x2="6183.4" y2="2144.35" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#FF5C5C"/>
                            <stop offset="0.3" stop-color="#F44444"/>
                            <stop offset="0.93" stop-color="#D60707"/>
                            <stop offset="1" stop-color="#D30000"/>
                          </linearGradient>
                          <linearGradient id="paint1_linear_2083_42" x1="11265.7" y1="8815.03" x2="11241.4" y2="8836.24" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#4D8EFF"/>
                            <stop offset="0.43" stop-color="#3F76FF"/>
                            <stop offset="1" stop-color="#2850FF"/>
                          </linearGradient>
                          <linearGradient id="paint2_linear_2083_42" x1="-8914.56" y1="11377.5" x2="-8898.45" y2="11420.1" gradientUnits="userSpaceOnUse">
                            <stop stop-color="#4D8EFF"/>
                            <stop offset="0.43" stop-color="#3F76FF"/>
                            <stop offset="1" stop-color="#2850FF"/>
                          </linearGradient>
                        </defs>
                      </svg>

                      <h1 class="setup-wizard__done-heading setup-wizard__heading-one">
                        You Are
                        <span class="setup-wizard__heading-one-highlight">Done</span>
                      </h1>
                    </div>

                    <!-- testimonial container -->
                    <div class="setup-wizard__testimonial">
                      <h2 class="setup-wizard__testimonial-title">Testimonials</h2>
                      <div class="setup-wizard__testimonial-card">
                        <div class="setup-wizard__testimonial-single-card">

                          <p class="setup-wizard__testimonial-text-content">
                            ${stepThree?.testimonials_description[0]}
                          </p>

                          <p class="setup-wizard__testimonial-text-author">
                            -  ${stepThree?.testimonials_author[0]}
                          </p>

                          <div class="setup-wizard__testimonial-quote-icon">

                            <svg xmlns="http://www.w3.org/2000/svg" width="113" height="96" viewBox="0 0 113 96" fill="none">
                              <g filter="url(#filter0_dd_192_605)">
                                <path d="M46.3642 40L39.8188 53.0909H52.9097L52.9097 76H30.0006L30.0006 53.0909L36.5461 40H46.3642ZM75.8188 40L69.2733 53.0909H82.3643L82.3643 76L59.4552 76L59.4552 53.0909L66.0006 40L75.8188 40Z" fill="white"/>
                              </g>
                              <defs>
                                <filter id="filter0_dd_192_605" x="0.000610352" y="0" width="112.364" height="96" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                  <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                  <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                  <feOffset dy="-10"/>
                                  <feGaussianBlur stdDeviation="15"/>
                                  <feComposite in2="hardAlpha" operator="out"/>
                                  <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.427451 0 0 0 0 0.941176 0 0 0 0.12 0"/>
                                  <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_192_605"/>
                                  <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                  <feOffset dy="1"/>
                                  <feGaussianBlur stdDeviation="0.5"/>
                                  <feComposite in2="hardAlpha" operator="out"/>
                                  <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.427451 0 0 0 0 0.941176 0 0 0 0.1 0"/>
                                  <feBlend mode="normal" in2="effect1_dropShadow_192_605" result="effect2_dropShadow_192_605"/>
                                  <feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_192_605" result="shape"/>
                                </filter>
                              </defs>
                            </svg>
                          </div>
                        </div>

                        <div class="setup-wizard__testimonial-single-card">
                          <p class="setup-wizard__testimonial-text-content">
                            ${stepThree?.testimonials_description[1]}
                          </p>
                          <p class="setup-wizard__testimonial-text-author">
                            - ${stepThree?.testimonials_author[1]}
                          </p>

                              <div class="setup-wizard__testimonial-quote-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="113" height="96" viewBox="0 0 113 96" fill="none">
                                  <g filter="url(#filter0_dd_192_605)">
                                    <path d="M46.3642 40L39.8188 53.0909H52.9097L52.9097 76H30.0006L30.0006 53.0909L36.5461 40H46.3642ZM75.8188 40L69.2733 53.0909H82.3643L82.3643 76L59.4552 76L59.4552 53.0909L66.0006 40L75.8188 40Z" fill="white"/>
                                  </g>
                                  <defs>
                                    <filter id="filter0_dd_192_605" x="0.000610352" y="0" width="112.364" height="96" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                      <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                      <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                      <feOffset dy="-10"/>
                                      <feGaussianBlur stdDeviation="15"/>
                                      <feComposite in2="hardAlpha" operator="out"/>
                                      <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.427451 0 0 0 0 0.941176 0 0 0 0.12 0"/>
                                      <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_192_605"/>
                                      <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                      <feOffset dy="1"/>
                                      <feGaussianBlur stdDeviation="0.5"/>
                                      <feComposite in2="hardAlpha" operator="out"/>
                                      <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.427451 0 0 0 0 0.941176 0 0 0 0.1 0"/>
                                      <feBlend mode="normal" in2="effect1_dropShadow_192_605" result="effect2_dropShadow_192_605"/>
                                      <feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_192_605" result="shape"/>
                                    </filter>
                                  </defs>
                                </svg>
                              </div>
                          </div>
                      </div>
                    </div>

                    <!-- subscribe button -->
                    <div class="setup-wizard__subscribe-button-container">
                      <!-- switcher -->
                      <label class="setup-wizard__switch">
                        <input type="checkbox" id="wpfm-toggle-button" ${ isToggleButtonChecked ? 'checked': ''}>
                        <span class="setup-wizard__switch-slider setup-wizard__switch-round"></span>
                      </label>
                      <p>
                        Opt-in to receive tips, discounts, and recommendations from
                        the RexTheme team directly in your inbox.
                      </p>
                    </div>
                  </section>


                  <!-- setup wizard buttons -->
                  <section class="setup-wizard__footer-buttons">
                    <a href="#" class="setup-wizard__button-left lets-create-first-feed last-step" target="_self">
                      ${stepThree?.button_text[0]}
                    </a>
                    <a href="https://rextheme.com/best-woocommerce-product-feed/pricing/" target="_blank" class="setup-wizard__button-right" id="upgrade-to-pro">
                      ${stepThree?.button_text[1]}
                    </a>
                  </section>
              </main>
                  `,
              isNextStep: true,
              isPreviousStep: true,
              isSkip: false,
            }
            
          ],
        });
    }

    /**
     * Navigation bar onclick event
     *
     * since 7.4.15
     */
    $( document ).on('click', '.setup-wizard__pregress-step', function () {
        if ( !$( this ).hasClass( 'step-active' ) ) {
            if ( $( this ).next().hasClass( 'step-active' ) ) {
                prevToggle();
            }
            else if ( $( this ).prev().hasClass( 'step-active' ) ) {
                nextToggle();
            }
            requiredTagText();
            displayMerchants();
        }
    });

    /**
     * Adds event listeners to handle clicks on navigation buttons within the wizard.
     *
     * @since 7.4.15
     */
    $(document).on("click", ".next-step-button", () => {
        nextToggle();
        requiredTagText();
        displayMerchants();
    });

    /**
     * Handles click events on the "Skip" button, redirecting to the license manager page.
     *
     * @since 7.4.15
     */
    $(document).on('click', '.lets-create-first-feed', function (e) {
        e.preventDefault();
        if( isToggleButtonChecked && $( this ).hasClass( 'last-step' ) ){
            createContact()
        }

        if(merchantName) {
            window.location = `post-new.php?post_type=product-feed&tour_guide=1&rex_feed_merchant=${merchantName}`;
        }else{
            window.location = "/wp-admin/post-new.php?post_type=product-feed&tour_guide=1";
        }
    });

    /**
     * Handles click events on the video play button.
     *  @since 7.4.15
     */
    $(document).on("click", "#video_play_button", () => {
        const yt_video = ytVideosLink;

        $("#setup_video").css("display", "block");

        // Append the iframe with the correct attributes
        $("#setup_video").html(`<iframe id="recommendation-video_set" title="Video" src="${yt_video}" allow="autoplay"></iframe>`);

        // Hide the preview and play button
        $("#recommendation-preview, #video_play_button").css("display", "none");
    });

    $(document).on("click", "#wpfm-toggle-button", () => {
        isToggleButtonChecked = !isToggleButtonChecked;
    });


    function createContact(){
        let name = window?.rex_wpfm_ajax?.user_information?.name;
        let email = window?.rex_wpfm_ajax?.user_information?.email;
        $.ajax({
            url: window.rex_wpfm_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'create_contact',
                email: email,
                name: name,
                security: window.rex_wpfm_ajax.ajax_nonce
            },
            success: function(response){
            },
            error: function(jqXHR){
            }
        });
    }

    $(document).on('input', '#search_merchant', function(){
        let searchValue = $(this).val().toLowerCase();
        let merchants = Object.entries(allMerchants).map(([key, value]) => ({key, value}));
        let filteredMerchants = merchants.filter(merchant => merchant.value.name.toLowerCase().includes(searchValue));
        let searchResults = document.querySelector('#search-results');
        searchResults.innerHTML = '';
        if(searchValue !== '') {
            $('#popular_merchants').hide();
            if (filteredMerchants.length > 0) {
                filteredMerchants.forEach(merchant => {
                    let merchantDiv = document.createElement('div');
                    merchantDiv.classList.add('rex-wpfm-setup-wizard-single-builder');
                    merchantDiv.classList.add('handle-selected-merchant');
                    merchantDiv.setAttribute('data-merchant-name', merchant.key)
                    merchantDiv.innerHTML = `
                <h3 class="rex-wpfm-builder-heading">${merchant.value.name}</h3>
                `;
                    searchResults.appendChild(merchantDiv);
                });
            } else {
                searchResults.innerHTML = '<p class="rex-wpfm-no-result-found">No results found</p>';
            }
        }else{
            $('#popular_merchants').show();
        }
    })

    $(document).on('click', '.handle-selected-merchant', function(){
        merchantName = $(this).data('merchant-name');
        $('.handle-selected-merchant').removeClass('active');
        $(this).addClass('active');
    });

    $(document).on('click', '.setup-wizard__done-buttons-progress', function(){
        window.location = 'post-new.php?post_type=product-feed&tour_guide=1&rex_feed_merchant=' + merchantName;
    });

    function displayMerchants() {
        const container = $('#popular_merchants');

        modifiedPopularMerchants.forEach(merchant => {
            const merchantDiv = $('<div>', {
                class: 'rex-wpfm-setup-wizard-single-builder handle-selected-merchant',
                'data-merchant-name': merchant.key
            });

            const img = $('<img>', {
                src: merchant.value.logo_url,
                alt: merchant.value.name,
                class: 'rex-wpfm-setup-builder-image'
            });

            const heading = $('<h3>', {
                class: 'rex-wpfm-builder-heading',
                text: merchant.value.name
            });

            merchantDiv.append(img).append(heading);
            container.append(merchantDiv);
        });
    }

    function requiredTagText(){
        const requiredTag = $('.rex-wpfm-required-tag');
        if(necessaryPlugins.woocommerce.is_active){
            requiredTag.text('Installed');
        } else{
            requiredTag.text('Required');
        }
    }
})(jQuery);