<?php
/**
 * Dokan Seller registration form
 *
 * @since 2.4
 */
?>


<div class="show_if_seller" style="<?php echo esc_attr( $role_style ); ?>">

    <div class="split-row form-row-wide">
        <p class="form-row form-group">
            <label for="first-name"><?php esc_html_e( 'First Name', 'dokan-lite' ); ?> <span class="required">*</span></label>
            <input type="text" class="input-text form-control" name="fname" id="first-name" value="<?php echo ! empty( $data['fname'] ) ? esc_attr( $data['fname'] ) : ''; ?>" required="required" />
        </p>

        <p class="form-row form-group">
            <label for="last-name"><?php esc_html_e( 'Last Name', 'dokan-lite' ); ?> <span class="required">*</span></label>
            <input type="text" class="input-text form-control" name="lname" id="last-name" value="<?php echo ! empty( $data['lname'] ) ? esc_attr( $data['lname'] ) : ''; ?>" required="required" />
        </p>
    </div>

    <p class="form-row form-group form-row-wide">
        <label for="company-name"><?php esc_html_e( 'Shop Name', 'dokan-lite' ); ?> <span class="required">*</span></label>
        <input type="text" class="input-text form-control" name="shopname" id="company-name" value="<?php echo ! empty( $data['shopname'] ) ? esc_attr( $data['shopname'] ) : ''; ?>" required="required" />
    </p>
	
    <p class="form-row form-group form-row-wide">
        <label for="seller-url" class="pull-left"><?php esc_html_e( 'Shop URL', 'dokan-lite' ); ?> <span class="required">*</span></label>
        <strong id="url-alart-mgs" class="pull-right"></strong>
        <input type="text" class="input-text form-control" name="shopurl" id="seller-url" value="<?php echo ! empty( $data['shopurl'] ) ? esc_attr( $data['shopurl'] ) : ''; ?>" required="required" />
        <small><?php echo esc_url( home_url() . '/' . dokan_get_option( 'custom_store_url', 'dokan_general', 'store' ) ); ?>/<strong id="url-alart"></strong></small>
    </p>                                   

    <?php

    /**
     * Store Address Fields
     */

    if ( 'on' === dokan_get_option( 'enabled_address_on_reg', 'dokan_general', 'off' ) ) {
        dokan_seller_address_fields( false, true );
    }
    /**
     * @since 3.2.8
     */
    do_action( 'dokan_seller_registration_after_shopurl_field', [] );
    ?>

    <p class="form-row form-group form-row-wide">
        <label for="shop-phone"><?php esc_html_e( 'Phone Number', 'dokan-lite' ); ?><span class="required">*</span></label>
        <input type="text" class="input-text form-control" name="phone" id="shop-phone" value="<?php echo ! empty( $data['phone'] ) ? esc_attr( $data['phone'] ) : ''; ?>" required="required" />
    </p>
	
	
	<p class="form-row form-group form-row-wide">
        <label for="imageSelect"><?php esc_html_e( 'Pay using QR Code and add Transaction details', 'dokan-custom-codes' ); ?><span class="required">*</span></label>
		<div class="qrcode-content" id="image3">
			<img src="https://scmwoocomrepo.blob.core.windows.net/wowhandicraft/2023/09/Revised-Annual-Subscription.png" width="100" height="100"/></br>
			<span>Annual Subscription charges</br><span class="qrcode-price">&#8377;1,500 + 18% GST</span></span>
		</div>
        <!-- <select id="planSelect" class="dokan-form-control ">
			<option value="none">Select your plan</option>
			<option value="image1">Quarterly</option>
			<option value="image2">Half Yearly</option>
			<option value="image3">Yearly</option>
		</select>
		
		<div class="qrcode-content" id="image1" style="display:none;">
			<img src="https://www.wowhandicraft.com/wp-content/uploads/2023/05/Quarterly-Subscription-1.png" width="100" height="100"/></br>
			<span>Quarterly </br><span class="qrcode-price">&#8377;4,500 + 18% GST</span></br><p style="font-size:12px">Up to 85 products in quantity sales</p></span>
		</div>
		<div class="qrcode-content" id="image2" style="display:none;">
			<img src="https://www.wowhandicraft.com/wp-content/uploads/2023/05/Half-Yearly-Subscription-1.png" width="100" height="100"/></br>
			<span>Half Yearly</br><span class="qrcode-price">&#8377;9,000 + 18% GST</span></br><p style="font-size:12px">Up to 165 products in quantity sales</p></span>
			</div>
			<div class="qrcode-content" id="image3" style="display:none;">
			<img src="https://www.wowhandicraft.com/wp-content/uploads/2023/05/Yearly-Subscription-1.png" width="100" height="100"/></br>
			<span>Yearly</br><span class="qrcode-price">&#8377;16,500 + 18% GST</span></br><p style="font-size:12px">Up to 330 products in quantity sales</p></span>
			</div>
    </p> -->
	
	
	<p class="form-row form-group form-row-wide">
        <label for="upi-id"><?php esc_html_e( 'UPI Transaction ID', 'dokan-custom-codes' ); ?><span class="required">*</span></label>
        <input type="text" class="input-text form-control" name="upi_id" id="upi_id" value="<?php if ( ! empty( $data['upi_id'] ) ) echo esc_attr($data['upi_id']); ?>" oninput="this.value = this.value.replace(/[^a-zA-Z0-9]/g, '').replace(/(\..*)\./g, '$1');" required="required" />
    </p>
	
	<p class="form-row form-group form-row-wide">
        <label for="payment-date"><?php esc_html_e( 'Payment Date', 'dokan-custom-codes' ); ?><span class="required">*</span></label>
        <input type="date" class="input-text form-control" name="payment_date" id="payment_date" value="<?php if ( ! empty( $data['payment_date'] ) ) echo esc_attr($data['payment_date']); ?>" required="required" />
    </p>
	
	<p class="form-row form-group form-row-wide">
        <label for="payment-amt"><?php esc_html_e( 'Amount Paid', 'dokan-custom-codes' ); ?><span class="required">*</span></label>
        <input type="text" class="input-text form-control" name="payment_amt" id="payment_amt" value="<?php if ( ! empty( $data['payment_amt'] ) ) echo esc_attr($data['payment_amt']); ?>" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" required="required" />
    </p>

    <?php
    $show_terms_condition = dokan_get_option( 'enable_tc_on_reg', 'dokan_general' );
    $terms_condition_url  = dokan_get_terms_condition_url();

    if ( 'on' === $show_terms_condition && $terms_condition_url ) {
        ?>
        <p class="form-row form-group form-row-wide">
            <input class="tc_check_box" type="checkbox" id="tc_agree" name="tc_agree" required="required">
            <label style="display: inline" for="tc_agree">
                <?php
                printf(
                /* translators: %1$s: opening anchor tag with link, %2$s: an ampersand %3$s: closing anchor tag */
                    __( 'I have read and agree to the %1$sTerms %2$s Conditions%3$s.', 'dokan-lite' ),
                    sprintf( '<a target="_blank" href="%s">', esc_url( $terms_condition_url ) ),
                    '&amp;',
                    '</a>'
                );
                ?>
            </label>
        </p>
        <?php
    }
    do_action( 'dokan_seller_registration_field_after' );
    ?>
</div>

<?php do_action( 'dokan_reg_form_field' ); ?>

<p class="form-row form-group user-role vendor-customer-registration">

    <label class="radio">
        <input type="radio" name="role" value="customer"<?php checked( $role, 'customer' ); ?>>
        <?php esc_html_e( 'I am a customer', 'dokan-lite' ); ?>
    </label>
    <br/>
    <label class="radio">
        <input type="radio" name="role" value="seller"<?php checked( $role, 'seller' ); ?>>
        <?php esc_html_e( 'I am a vendor', 'dokan-lite' ); ?>
    </label>
    <?php do_action( 'dokan_registration_form_role', $role ); ?>

</p>

<!-- <script type="text/javascript" >
	jQuery(document).ready(function($) {
	   $('#planSelect').change(function() {	
			var selValue = $(this).val();
			if ( selValue === "image1") {
			$("#image1").show();
			$("#image2").hide();
			$("#image3").hide();
		  } else if ( selValue === "image2") {
			$("#image1").hide();
			$("#image2").show();
			$("#image3").hide();
		  }else if ( selValue === "image3") {
			$("#image1").hide();
			$("#image2").hide();
			$("#image3").show();
		  } else {
			$("#image1").hide();
			$("#image2").hide();
			$("#image3").hide();
		  }
	   });
	});
	
	</script> -->
	
