<?php
/**
 * Electro Child
 *
 * @package electro-child
 */

/**
 * Include all your custom code here
 */ 
 

function electro_child_theme() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'parent-style' ), wp_get_theme()->get('Version') );
	wp_register_script( 'jQueryUI', 'https://cdnjs.cloudflare.com/ajax/libs/izimodal/1.6.1/js/iziModal.min.js', null, null, true );
    wp_enqueue_script( 'jQueryUI' );
	
}

add_action( 'wp_enqueue_scripts', 'electro_child_theme' );
  
 
/** Place order button rename*/
add_filter( 'woocommerce_order_button_text', 'ql_replace_place_order_button_text' );
function ql_replace_place_order_button_text() {
   return 'Place Order'; 
}

// Rename dokan verification National ID name
 
add_filter(  'gettext',  'wps_translate_words_array'  );
add_filter(  'ngettext',  'wps_translate_words_array'  );
function wps_translate_words_array( $translated ) {
 
     $words = array(
	    'National ID' => 'Aadhaar',
            'National Id' => 'Aadhaar Card',
	    'Join to my followers' => 'Join my followers',
	    'Lost your password?' => 'Forgot password?',
            'Lost password' => 'Forgot password',
            );
     $translated = str_ireplace(  array_keys($words),  $words,  $translated );
     return $translated;
}

/** Vendor registration form custom field*/

 function dokan_custom_seller_registration_required_fields( $required_fields ) {
    $required_fields['upi_id'] = __( 'Please enter UPI Transaction ID', 'dokan-custom' );
	$required_fields['payment_date'] = __( 'Please enter Payment Date', 'dokan-custom' );
	$required_fields['payment_amt'] = __( 'Please enter Amount Paid', 'dokan-custom' );
    return $required_fields;
};
add_filter( 'dokan_seller_registration_required_fields', 'dokan_custom_seller_registration_required_fields' );

add_filter( 'dokan_settings_form_bottom', 'extra_fields', 10, 2);

function extra_fields( ){
	
	$user_id = get_current_user_id();
	$user_meta = get_user_meta( $user_id );

//echo '<pre>';
//print_r( $user_meta );
//echo '</pre>';

	?>
	
	<div class="dokan-form-group">
            <label class="dokan-w3 dokan-control-label" for="upi_id"><?php esc_html_e( 'UPI Transaction ID', 'dokan-lite' ); ?></label>
            <div class="dokan-w5 dokan-text-left">
                <input id="upi_id" value="<?php echo esc_attr( get_user_meta( dokan_get_current_user_id(), 'dokan_custom_upi_id', true ) ); ?>" name="upi_id" placeholder="<?php esc_attr_e( 'UPI Transaction ID', 'dokan-lite' ); ?>" class="dokan-form-control input-md" type="text" readonly>
            </div>
        </div>
		
		<?php do_action( 'dokan_settings_after_store_upi_id', $current_user, $profile_info ); ?>
        
        <div class="dokan-form-group">
            <label class="dokan-w3 dokan-control-label" for="payment_date"><?php esc_html_e( 'Payment Date', 'dokan-lite' ); ?></label>
            <div class="dokan-w5 dokan-text-left">
                <input id="payment_date" value="<?php echo esc_attr( get_user_meta( dokan_get_current_user_id(), 'dokan_custom_payment_date', true ) ); ?>" name="payment_date" placeholder="<?php esc_attr_e( 'Payment Date', 'dokan-lite' ); ?>" class="dokan-form-control input-md" type="text" readonly>
            </div>
        </div>
		
		<?php do_action( 'dokan_settings_after_store_payment_date', $current_user, $profile_info ); ?>
        
        <div class="dokan-form-group">
            <label class="dokan-w3 dokan-control-label" for="payment_amt"><?php esc_html_e( 'Amount Paid', 'dokan-lite' ); ?></label>
            <div class="dokan-w5 dokan-text-left">
                <input id="payment_amt" value="<?php echo esc_attr( get_user_meta( dokan_get_current_user_id(), 'dokan_custom_payment_amount', true ) ); ?>" name="payment_amt" placeholder="<?php esc_attr_e( 'Amount Paid', 'dokan-lite' ); ?>" class="dokan-form-control input-md" type="text" readonly>
            </div>
        </div>
		
		<?php do_action( 'dokan_settings_after_store_payment_amt', $current_user, $profile_info ); ?>
        
    <?php
}
    //save the field value
add_action( 'dokan_store_profile_saved', 'save_extra_fields', 15 );
function save_extra_fields( $store_id ) {
    $dokan_settings = dokan_get_store_info($store_id);
    if ( isset( $_POST['upi_id'] ) ) {
        $dokan_settings['upi_id'] = $_POST['upi_id'];
    }
    elseif  ( isset( $_POST['payment_date'] ) ) {
        $dokan_settings['payment_date'] = $_POST['payment_date'];
    }
    elseif  ( isset( $_POST['payment_amt'] ) ) {
        $dokan_settings['payment_amt'] = $_POST['payment_amt'];
    }
    
 update_user_meta( $store_id, 'dokan_profile_settings', $dokan_settings );
}

function dokan_custom_new_seller_created( $vendor_id, $dokan_settings ) {
    $post_data = wp_unslash( $_POST );

    $upi_id =  $post_data['upi_id'];
	$payment_date =  $post_data['payment_date'];
	$payment_amt =  $post_data['payment_amt'];
   
    update_user_meta( $vendor_id, 'dokan_custom_upi_id', $upi_id );
	update_user_meta( $vendor_id, 'dokan_custom_payment_date', $payment_date );
	update_user_meta( $vendor_id, 'dokan_custom_payment_amount', $payment_amt );
}

add_action( 'dokan_new_seller_created', 'dokan_custom_new_seller_created', 10, 2 );

add_action( 'dokan_seller_meta_fields', 'my_show_extra_profile_fields', 10 );
add_action( 'dokan_process_seller_meta_fields', 'process_more_fields', 10 );

function my_show_extra_profile_fields( $user ) { ?>

    <?php if ( ! current_user_can( 'manage_woocommerce' ) ) {
            return;
        }
        if ( ! user_can( $user, 'dokandar' ) ) {
            return;
        }
         $upi  = get_user_meta( $user->ID, 'dokan_custom_upi_id', true );
		 $payment_date  = get_user_meta( $user->ID, 'dokan_custom_payment_date', true );
		 $payment_amt  = get_user_meta( $user->ID, 'dokan_custom_payment_amount', true );
     ?>
         <tr>
                    <th><?php esc_html_e( 'UPI Transaction ID', 'dokan-lite' ); ?></th>
                    <td>
                        <input type="text" name="upi_id" class="regular-text" value="<?php echo esc_attr($upi); ?>"/>
                    </td>
         </tr>
		 <tr>
                    <th><?php esc_html_e( 'Payment Date', 'dokan-lite' ); ?></th>
                    <td>
                        <input type="text" name="payment_date" class="regular-text" value="<?php echo esc_attr($payment_date); ?>"/>
                    </td>
         </tr>
		 <tr>
                    <th><?php esc_html_e( 'Amount Paid', 'dokan-lite' ); ?></th>
                    <td>
                        <input type="text" name="payment_amt" class="regular-text" value="<?php echo esc_attr($payment_amt); ?>"/>
                    </td>
         </tr>
    <?php
 }

add_action( 'personal_options_update', 'my_save_extra_profile_fields' );
add_action( 'edit_user_profile_update', 'my_save_extra_profile_fields' );

function my_save_extra_profile_fields( $user_id ) {

if ( ! current_user_can( 'manage_woocommerce' ) ) {
            return;
        }
    update_usermeta( $user_id, 'dokan_custom_upi_id', $_POST['upi_id'] );
	update_usermeta( $user_id, 'dokan_custom_payment_date', $_POST['payment_date'] );
	update_usermeta( $user_id, 'dokan_custom_payment_amount', $_POST['payment_amt'] );
}

/*New order footer text change*/
function mtp_disable_mobile_messaging ( $mailer ) { 
remove_action ( 'woocommerce_email_footer', array ( $mailer->emails ['WC_Email_New_Order'], 'mobile_messaging' ), 9 ); 
} 
add_action ( 'woocommerce_email', 'mtp_disable_mobile_messaging' );

/*Disable paypal payment gateway for india*/
/*add_filter( 'woocommerce_available_payment_gateways', 'bbloomer_payment_gateway_disable_country' );
  
function bbloomer_payment_gateway_disable_country( $available_gateways ) {
	//print_r(get_woocommerce_currency());
    if ( is_admin() ) return $available_gateways;
    if ( isset( $available_gateways['authorize'] ) && WC()->customer && get_woocommerce_currency() <> 'INR' ) {
        unset( $available_gateways['authorize'] );
    } else {
        if ( isset( $available_gateways['ppcp-gateway'] ) && WC()->customer && get_woocommerce_currency() == 'INR' ) {
            unset( $available_gateways['ppcp-gateway'] );
        }
		else{
			unset( $available_gateways['auropay'] );
		}
    }
    return $available_gateways;
}*/