<?php
/**
 * Customer new account email
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/customer-new-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates\Emails
 * @version 6.0.0
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_email_header', $email_heading, $email ); ?>



<?php 
if ( isset( $_POST['role'] ) && $_POST['role'] === 'seller' ) :?>
	<p style="text-transform: capitalize;"><?php printf( esc_html__( 'Dear %s,', 'woocommerce' ), esc_html( $user_login ) ); ?></p>
	<p><?php printf( esc_html__( 'We are thrilled to inform you that your vendor registration at wowhandicraft.com has been successfully created! On behalf of the entire WOWHandicraft team, we extend our warmest congratulations and welcome you to our esteemed community of artisans and creators.', 'woocommerce' ), esc_html( $user_login ) ); ?></p>
	<p><?php printf( esc_html__( 'We believe that your unique creations will resonate with our discerning customers who appreciate the beauty and authenticity of handmade goods.', 'woocommerce' ), esc_html( $user_login ) ); ?></p>
	
	<p><?php printf( esc_html__( 'You are one step closer to publish your product online. You would require to', 'woocommerce' ), esc_html( $user_login ) ); ?>
	<strong><?php printf( esc_html__( 'complete the KYC process by going to your Dashboard>>Verification.', 'woocommerce' ), esc_html( $user_login ) ); ?></strong>
	<?php printf( esc_html__( 'Once approved you will be able to showcase your products to a wider audience and reach potential customers from all corners of the globe. wowhandicraft.com provides an intuitive and user-friendly platform where you can create and manage your online store effortlessly. We have a dedicated team of professionals who will provide guidance and support throughout your journey with us, ensuring that you have a seamless selling experience.', 'woocommerce' ), esc_html( $user_login ) ); ?></p>
<p><?php printf( esc_html__( 'Thank you for choosing WOWHandicraft.com as your preferred online marketplace. Together, lets create an unforgettable experience for our customers and showcase the beauty of handmade craftsmanship to the world.', 'woocommerce' ), esc_html( $user_login ) ); ?></p>


<?php else :?>
	<p style="text-transform: capitalize;"><?php printf( esc_html__( 'Dear %s,', 'woocommerce' ), esc_html( $user_login ) ); ?></p>
	<?php /* translators: %1$s: Site title, %2$s: Username, %3$s: My account link */ ?>
	<p><?php printf( esc_html__( 'Thanks for creating an account on %1$s. Your username is %2$s. You can access your account area to view orders, change your password, and more at: %3$s', 'woocommerce' ), esc_html( $blogname ), '<strong>' . esc_html( $user_login ) . '</strong>', make_clickable( esc_url( wc_get_page_permalink( 'myaccount' ) ) ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
	<?php if ( 'yes' === get_option( 'woocommerce_registration_generate_password' ) && $password_generated && $set_password_url ) : ?>
	<?php // If the password has not been set by the user during the sign up process, send them a link to set a new password ?>
	<p><a href="<?php echo esc_attr( $set_password_url ); ?>"><?php printf( esc_html__( 'Click here to set your new password.', 'woocommerce' ) ); ?></a></p>
	<?php endif; ?>
	<?php endif; ?>

<?php
/**
 * Show user-defined additional content - this is set in each email's settings.
 */
if ( $additional_content ) {
	echo wp_kses_post( wpautop( wptexturize( $additional_content ) ) );
}

do_action( 'woocommerce_email_footer', $email );
