<?php
/**
 * This file contains code related to the label swatches.
 *
 * @package RedParts\Sputnik
 * @since 1.0.0
 */

namespace RedParts\Sputnik\Swatches;

use RedParts\Sputnik\Singleton;
use WP_Term;

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'RedParts\Sputnik\Swatches\Label' ) ) {
	/**
	 * Class Label
	 */
	class Label extends Singleton {
		/**
		 * Initialization.
		 */
		public function init() {
			add_filter( 'redparts_sputnik_swatches_types', array( $this, 'get_attribute_types' ) );
			add_action( 'redparts_sputnik_swatches_control_template', array( $this, 'control_template' ), 10, 3 );
		}

		/**
		 * Returns an associative array of attribute types.
		 *
		 * @param array $types An associative array of attribute types.
		 *
		 * @return array
		 */
		public function get_attribute_types( $types = array() ): array {
			return array_merge( $types, array( 'label' => esc_html__( 'Label', 'redparts-sputnik' ) ) );
		}

		/**
		 * Outputs control template.
		 *
		 * @param array     $args   Args array.
		 * @param string    $type   Attribute type.
		 * @param WP_Term[] $values Option values.
		 */
		public function control_template( array $args, string $type, array $values ) {
			if ( 'label' !== $type ) {
				return;
			}

			?>
			<div class="th-input-radio-label">
				<div class="th-input-radio-label__list">
					<?php foreach ( $values as $value ) : ?>
						<label class="th-input-radio-label__item">
							<input
								type="radio"
								class="th-input-radio-label__input"
								name="redparts_fake_option_<?php echo esc_attr( $args['attribute'] ); ?>"
								value="<?php echo esc_attr( $value->slug ); ?>"
							>
							<span class="th-input-radio-label__title">
								<?php echo esc_html( $value->name ); ?>
							</span>
						</label>
					<?php endforeach; ?>
				</div>
			</div>
			<?php
		}
	}
}
