<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Image Widget .
 *
 */
class Traga_Group_Image extends Widget_Base {

	public function get_name() {
		return 'tragagroupimage';
	}

	public function get_title() {
		return __( 'Group Image V2', 'webteck' ); 
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'webteck' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __( 'Group Image', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Group Style', 'webteck' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'webteck' ),
					'2'  		=> __( 'Style Two', 'webteck' ),
					'3'  		=> __( 'Style Three', 'webteck' ),
					'4'  		=> __( 'Style Four', 'webteck' ),
					'5'  		=> __( 'Style Five', 'webteck' ),
					'6'  		=> __( 'Style Six', 'webteck' ),
					'7'  		=> __( 'Style Seven', 'webteck' ),
					'8'  		=> __( 'Style Eight', 'webteck' ),
					'9'  		=> __( 'Style Nine', 'webteck' ),
					'10'  		=> __( 'Style Ten', 'webteck' ),
					'11'  		=> __( 'Style Elevn', 'webteck' ),
					'12'  		=> __( 'Style Twelve', 'webteck' ),
					'13'  		=> __( 'Style Thirteen', 'webteck' ),
					'14'  		=> __( 'Style Fourteen', 'webteck' ),
					'15'  		=> __( 'Style Fifteen', 'webteck' ),
					'16'  		=> __( 'Style Sixteen', 'webteck' ),
					'17'  		=> __( 'Style Seventeen', 'webteck' ),
					'18'  		=> __( 'Style Eighteen', 'webteck' ),
					'19'  		=> __( 'Style Nineteen', 'webteck' ),
					'20'  		=> __( 'Style Twenty', 'webteck' ),
					'21'  		=> __( 'Style Twenty One', 'webteck' ),
				],
			]
		);

        $this->add_control(
			'image1',
			[
				'label' 		=> __( 'Image 1', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'image2',
			[
				'label' 		=> __( 'Image 2', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'layout_style' =>  ['3', '8', '9', '10', '11', '12', '15', '16', '20']  ],
			]
		);
		$this->add_control(
			'image3',
			[
				'label' 		=> __( 'Image 3', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'layout_style' =>  ['3', '8', '9', '11', '15']  ],
			]
		);

		$this->add_control(
			'shape1',
			[
				'label' 		=> __( 'Shape 1', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'layout_style' =>  ['1', '3', '4', '5', '6']  ],
			]
		);

		$this->add_control(
			'shape2',
			[
				'label' 		=> __( 'Shape 2', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'layout_style' =>  ['4', '5', '6']  ],
			]
		);
		$this->add_control(
			'video_link',
			[
				'label' 		=> esc_html__( 'Video Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'	=> ['layout_style' => ['16']]
			]
		);
		$this->add_control(
			'experience_text',
            [
				'label'         => __( 'Experience Text', 'webteck' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __( 'Years Experience' , 'webteck' ),
				'label_block'   => true,
				'condition'		=> [ 'layout_style' =>  ['1', '7', '16', '19','21']  ],
			]
		);
		$this->add_control(
			'experience_year',
            [
				'label'         => __( 'Experience Year', 'webteck' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __( '25' , 'webteck' ),
				'label_block'   => true,
				'condition'		=> [ 'layout_style' =>  ['1', '7', '16', '19','21']  ],
			]
		);
		$this->add_control(
			'experience_counter',
            [
				'label'         => __( 'Counter On', 'webteck' ),
				'type'          => Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'On', 'webteck' ),
				'label_off' 	=> __( 'Off', 'webteck' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'		=> [ 'layout_style' =>  ['1', '7', '16', '19','21']  ],
			]
		);
		$this->add_control(
			'title',
            [
				'label'         => __( 'Title', 'webteck' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __( 'Webteck' , 'webteck' ),
				'label_block'   => true,
				'condition'		=> [ 'layout_style' =>  ['18']  ],
			]
		);


        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        if ( $settings['layout_style'] == '1' ) {
			if( $settings['experience_counter'] == 'yes' ) {
				$counter_class = 'counter-number1';
			} else {
				$counter_class = '';
			}
        	echo '<div class="img-box1">';
        		if (!empty($settings['image1']['url'])) {
					
	                echo '<div class="img1">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['image1']['url']  ),
		                ));
	                echo '</div>';
	            }
	            if (!empty($settings['shape1']['url'])) {
	                echo '<div class="shape1">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['shape1']['url']  ),
		                ));
	                echo '</div>';
	            }
	            if(!empty($settings['experience_text'])){
					echo '<div class="year-counter">';
						echo '<h3 class="year-counter_number"><span class="'.$counter_class.'">'.wp_kses_post($settings['experience_year']).'</span></h3>';
						echo '<p class="year-counter_text">'.wp_kses_post($settings['experience_text']).'</p>';
					echo '</div>';
	            }
            echo '</div>';

        } elseif ( $settings['layout_style'] == '2' ) {
        	echo '<div class="img-box2">';
        		if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['image1']['url']  ),
		                ));
	                echo '</div>';
	            }
            echo '</div>';
        } elseif ( $settings['layout_style'] == '3' ) {
			echo '<div class="img-box3">';
        		if (!empty($settings['image1']['url'])) {
					
	                echo '<div class="img1">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['image1']['url']  ),
		                ));
	                echo '</div>';
	            }
	            if (!empty($settings['image2']['url'])) {
	                echo '<div class="img2">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['image2']['url']  ),
		                ));
	                echo '</div>';
	            }
	            if (!empty($settings['image3']['url'])) {
	                echo '<div class="img3">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['image3']['url']  ),
		                ));
	                echo '</div>';
	            }
	            if (!empty($settings['shape1']['url'])) {
	                echo '<div class="shape1">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['shape1']['url']  ),
		                ));
	                echo '</div>';
	            }
            echo '</div>';
		} elseif ( $settings['layout_style'] == '4' ) {
			echo '<div class="img-box6">';
        		if (!empty($settings['image1']['url'])) {
					
	                echo '<div class="img1">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['image1']['url']  ),
		                ));
	                echo '</div>';
	            }
	            if (!empty($settings['shape1']['url'])) {
	                echo '<div class="shape1">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['shape1']['url']  ),
		                ));
	                echo '</div>';
	            }
	            if (!empty($settings['shape2']['url'])) {
	                echo '<div class="shape2">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['shape2']['url']  ),
		                ));
	                echo '</div>';
	            }
            	echo '<div class="color-animate"></div>';
            echo '</div>';
		} elseif ( $settings['layout_style'] == '5' ) {
			echo '<div class="img-box7">';
        		if (!empty($settings['image1']['url'])) {
					
	                echo '<div class="img1">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['image1']['url']  ),
		                ));
	                echo '</div>';
	            }
	            if (!empty($settings['shape1']['url'])) {
	                echo '<div class="shape1">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['shape1']['url']  ),
		                ));
	                echo '</div>';
	            }
	            if (!empty($settings['shape2']['url'])) {
	                echo '<div class="shape2">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['shape2']['url']  ),
		                ));
	                echo '</div>';
	            }
            	echo '<div class="color-animate"></div>';
            echo '</div>';
		} elseif ( $settings['layout_style'] == '6' ) {
			echo '<div class="img-box8">';
        		if (!empty($settings['image1']['url'])) {
					
	                echo '<div class="img1">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['image1']['url']  ),
		                ));
	                echo '</div>';
	            }
	            if (!empty($settings['shape1']['url'])) {
	                echo '<div class="shape1">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['shape1']['url']  ),
		                ));
	                echo '</div>';
	            }
	            if (!empty($settings['shape2']['url'])) {
	                echo '<div class="shape2">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['shape2']['url']  ),
		                ));
	                echo '</div>';
	            }
            	echo '<div class="color-animate"></div>';
            echo '</div>';
		} elseif ( $settings['layout_style'] == '7' ) {
			if( $settings['experience_counter'] == 'yes' ) {
				$counter_class = 'counter-number1';
			} else {
				$counter_class = '';
			}
        	echo '<div class="img-box5">';
        		if (!empty($settings['image1']['url'])) {
					
	                echo '<div class="img1">';
	                    echo webteck_img_tag( array(
		                    'url'   => esc_url( $settings['image1']['url']  ),
		                    'class'   => 'tilt-active',
		                ));
	                echo '</div>';
	            }
	            if(!empty($settings['experience_text'])){
					echo '<div class="year-counter">';
						echo '<h3 class="year-counter_number"><span class="'.$counter_class.'">'.wp_kses_post($settings['experience_year']).'</span></h3>';
						echo '<p class="year-counter_text">'.wp_kses_post($settings['experience_text']).'</p>';
					echo '</div>';
	            }
	            if(!empty($settings['experience_year'])){
	                echo '<a href="'.esc_url($settings['experience_counter']).'" class="order-btn"></a>';
	            }
            echo '</div>';

		}elseif ( $settings['layout_style'] == '8' ){
			echo '<div class="img-box15 mb-xl-0 mt-xl-0 mt-n4">';
				echo '<div class="img1">';
					echo webteck_img_tag( array(
						'url'   => esc_url( $settings['image1']['url']  ),
					));
					if (!empty($settings['image2']['url'])) {
						echo '<div class="img2 jump">';
							echo webteck_img_tag( array(
								'url'   => esc_url( $settings['image2']['url']  ),
							));
						echo '</div>';
					}
					if (!empty($settings['image3']['url'])) {
						echo '<div class="img3 movingX">';
							echo webteck_img_tag( array(
								'url'   => esc_url( $settings['image3']['url']  ),
							));
						echo '</div>';
					}
					echo '<div class="about-shape15"></div>';
				echo '</div>';
			echo '</div>';

		}elseif ( $settings['layout_style'] == '9' ){
			echo '<div class="faq-img5 mb-xl-0 mt-xl-0 mt-n4 me-xl-5 pe-xl-5">';
				echo '<div class="img1">';
					echo webteck_img_tag( array(
						'url'   => esc_url( $settings['image1']['url']  ),
					));
					if (!empty($settings['image2']['url'])) {
						echo '<div class="img2 jump">';
							echo webteck_img_tag( array(
								'url'   => esc_url( $settings['image2']['url']  ),
							));
						echo '</div>';
					}
					if (!empty($settings['image3']['url'])) {
						echo '<div class="img3 movingX">';
							echo webteck_img_tag( array(
								'url'   => esc_url( $settings['image3']['url']  ),
							));
						echo '</div>';
					}
					echo '<div class="faq-shape5"></div>';
				echo '</div>';
			echo '</div>';

		}elseif ( $settings['layout_style'] == '10' ){
			echo '<div class="feature-thumb8_wrapp">';
				if (!empty($settings['image1']['url'])) {
					echo '<div class="feature-thumb8-1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
					echo '</div>';
				}
				if (!empty($settings['image2']['url'])) {
					echo '<div class="feature-thumb8-2 jump">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image2']['url']  ),
						));
					echo '</div>';
				}
			echo '</div>';

		}elseif ( $settings['layout_style'] == '11' ){
			echo '<div class="feature-thumb10_wrapp">';
				if (!empty($settings['image1']['url'])) {
					echo '<div class="feature-thumb10-1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
					echo '</div>';
				}
				if (!empty($settings['image2']['url'])) {
					echo '<div class="feature-thumb10-2 jump">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image2']['url']  ),
						));
					echo '</div>';
				}
				if (!empty($settings['image3']['url'])) {
					echo '<div class="feature-thumb10-3 movingX">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image3']['url']  ),
						));
					echo '</div>';
				}
			echo '</div>';

		}elseif ( $settings['layout_style'] == '12' ){
			echo '<div class="feature-thumb8_wrapp">';
				if (!empty($settings['image1']['url'])) {
					echo '<div class="feature-thumb11-1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
					echo '</div>';
				}
				if (!empty($settings['image2']['url'])) {
					echo '<div class="feature-thumb11-2 jump">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image2']['url']  ),
						));
					echo '</div>';
				}
			echo '</div>';

		}elseif ( $settings['layout_style'] == '13' ){
			if (!empty($settings['image1']['url'])) {
				echo '<div class="img-box17 pe-xl-5">';
					echo '<div class="img1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
					echo '</div>';
				echo '</div>';
			}

		}elseif ( $settings['layout_style'] == '14' ){
			if (!empty($settings['image1']['url'])) {
				echo '<div class="feature-image7">';
					echo webteck_img_tag( array(
						'url'   => esc_url( $settings['image1']['url']  ),
					));
				echo '</div>';
			}

		}elseif ( $settings['layout_style'] == '15' ){
			echo '<div class="faq-img7 mb-xl-0 mt-xl-0 mt-n4 pe-xl-5 me-xl-1">';
				echo '<div class="img1">';
					echo webteck_img_tag( array(
						'url'   => esc_url( $settings['image1']['url']  ),
					));
					if (!empty($settings['image2']['url'])) {
						echo '<div class="img2 jump">';
							echo webteck_img_tag( array(
								'url'   => esc_url( $settings['image2']['url']  ),
							));
						echo '</div>';
					}
					if (!empty($settings['image3']['url'])) {
						echo '<div class="img3 movingX">';
							echo webteck_img_tag( array(
								'url'   => esc_url( $settings['image3']['url']  ),
							));
						echo '</div>';
					}
				echo '</div>';
			echo '</div>';

		}elseif ( $settings['layout_style'] == '16' ){
			echo '<div class="img-box16 pe-xl-5">';
				if (!empty($settings['image1']['url'])) {
					echo '<div class="img1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
					echo '</div>';
				}
				if (!empty($settings['image2']['url'])) {
				echo '<div class="img2">';
					echo webteck_img_tag( array(
						'url'   => esc_url( $settings['image2']['url']  ),
					));
					if(!empty($settings['video_link']['url'])){
						echo '<a href="'.esc_url( $settings['video_link']['url'] ).'" class="play-btn popup-video"><i class="fas fa-play"></i></a>';
					}
				echo '</div>';
				}
				if( $settings['experience_counter'] == 'yes' ) {
					echo '<div class="year-counter style2">';
						if(!empty($settings['experience_year'])){
							echo '<h3 class="year-counter_number">'.wp_kses_post($settings['experience_year']).'</h3>';
						}
						if(!empty($settings['experience_text'])){
							echo '<p class="year-counter_text">'.wp_kses_post($settings['experience_text']).'</p>';
						}
					echo '</div>';
				}
			echo '</div>';

		}elseif ( $settings['layout_style'] == '17' ){
			echo '<div class="choose-image4 pe-xl-5 me-xl-4">';
				if (!empty($settings['image1']['url'])) {
					echo '<div class="img1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
					echo '</div>';
				}
			echo '</div>';

		}elseif ( $settings['layout_style'] == '18' ){
			echo '<div class="feature-box me-xl-5 pe-xl-5">';
				if (!empty($settings['image1']['url'])) {
					echo '<div class="img1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
					echo '</div>';
				}
				if(!empty($settings['title'])){
				echo '<div class="feature-content11">';
					echo '<h4 class="feature-text">'.wp_kses_post($settings['title']).'</h4>';
				echo '</div>';
				}
			echo '</div>';

		}elseif ( $settings['layout_style'] == '19' ){
			echo '<div class="img-box20 pe-xl-5 me-xl-2">';
				if (!empty($settings['image1']['url'])) {
					echo '<div class="img1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
						echo '<div class="about-shape17"></div>';
					echo '</div>';
				}
				if( $settings['experience_counter'] == 'yes' ) {
					echo '<div class="th-experience">';
						echo '<div class="th-experience_content">';
							if(!empty($settings['experience_year'])){
								echo '<h2 class="experience-year">'.wp_kses_post($settings['experience_year']).'</h2>';
							}
							if(!empty($settings['experience_text'])){
								echo '<p class="experience-text">'.wp_kses_post($settings['experience_text']).'</p>';
							}
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';

		}elseif ( $settings['layout_style'] == '20' ){
			echo '<div class="feature-thumb14_wrapp">';
				if (!empty($settings['image1']['url'])) {
					echo '<div class="feature-thumb14-1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
					echo '</div>';
				}
				if (!empty($settings['image2']['url'])) {
					echo '<div class="feature-thumb14-2 jump">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image2']['url']  ),
						));
					echo '</div>';
				}
			echo '</div>';

		}else{
			echo '<div class="img-box25 me-xl-5">';
				if (!empty($settings['image1']['url'])) {
	                echo '<div class="img1">';
	                    echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
	                echo '</div>';
	            }

                echo '<div class="th-experience2">';
                    if(!empty($settings['experience_year'])){
						echo '<h2 class="experience-year">'.wp_kses_post($settings['experience_year']).'</h2>';
					}
					if(!empty($settings['experience_text'])){
						echo '<p class="experience-text">'.wp_kses_post($settings['experience_text']).'</p>';
					}
                echo '</div>';
            echo '</div>';
		}

         
	}

}

