<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Image Widget .
 *
 */
class Traga_Group_Image3 extends Widget_Base {

	public function get_name() {
		return 'tragagroupimage3';
	}
	public function get_title() {
		return __( 'Group Image V3', 'webteck' ); 
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __( 'Group Image', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Group Style', 'webteck' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'webteck' ),
					'2'  		=> __( 'Style Two', 'webteck' ),
					'3'  		=> __( 'Style Three', 'webteck' ),
					'4'  		=> __( 'Style four', 'webteck' ),
					'5'  		=> __( 'Style five', 'webteck' ),
					'6'  		=> __( 'Style Six', 'webteck' ),
					'7'  		=> __( 'Style Seven', 'webteck' ),
					'8'  		=> __( 'Style Eight', 'webteck' ),
					'9'  		=> __( 'Style Nine', 'webteck' ),
					'10'  		=> __( 'Style Ten', 'webteck' ),
					'11'  		=> __( 'Style Eleven', 'webteck' ),
				],
			]
		);

        $this->add_control(
			'image1',
			[
				'label' 		=> __( 'Image 1', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'image2',
			[
				'label' 		=> __( 'Image 2', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
                'condition'		=> [ 'layout_style' =>  ['1', '2', '4', '5', '8', '9', '10', '11']  ],
			]
		);

		webteck_media_fields( $this, 'image3', 'Image 3', ['9'] );
		webteck_media_fields( $this, 'image4', 'Image 4', ['9'] );


		$this->add_control(
			'title',
            [
				'label'         => __( 'Title', 'webteck' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __( 'Title' , 'webteck' ),
				'label_block'   => true,
				'condition'		=> [ 'layout_style' =>  ['5', '9', '11']  ],
			]
		);
		$this->add_control(
			'desc',
            [
				'label'         => __( 'Content', 'webteck' ),
				'type'          => Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default'       => __( 'Description' , 'webteck' ),
				'label_block'   => true,
				'condition'		=> [ 'layout_style' =>  ['5', '9', '11']  ],
			]
		);


        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        if ( $settings['layout_style'] == '1' ) {
			echo '<div class="feature-thumb12_wrapp">';
                if(!empty($settings['image1']['url'])){
                    echo '<div class="feature-thumb12-1">';
                        echo webteck_img_tag( array(
                            'url'   => esc_url( $settings['image1']['url']  ),
                        ));
                    echo '</div>';
                }
                if(!empty($settings['image2']['url'])){
                    echo '<div class="feature-thumb12-2 movingX">';
                        echo webteck_img_tag( array(
                            'url'   => esc_url( $settings['image2']['url']  ),
                        ));
                    echo '</div>';
                }
            echo '</div>';

        } elseif ( $settings['layout_style'] == '2' ) {
            echo '<div class="feature-thumb12_wrapp">';
                if(!empty($settings['image1']['url'])){
                    echo '<div class="feature-thumb12-3">';
                        echo webteck_img_tag( array(
                            'url'   => esc_url( $settings['image1']['url']  ),
                        ));
                    echo '</div>';
                }
                if(!empty($settings['image2']['url'])){
                    echo '<div class="feature-thumb12-4 movingX">';
                        echo webteck_img_tag( array(
                            'url'   => esc_url( $settings['image2']['url']  ),
                        ));
                    echo '</div>';
                }
           echo '</div>';

        } elseif ( $settings['layout_style'] == '3' ) {
            if(!empty($settings['image1']['url'])){
                echo '<div class="testi-image">';
                    echo webteck_img_tag( array(
                        'url'   => esc_url( $settings['image1']['url']  ),
                    ));
                echo '</div>';
            }

        } elseif ( $settings['layout_style'] == '4' ) {
			echo '<div class="faq-img8 mb-xl-0 mt-xl-0 ps-xl-5 ms-xl-1">';
				echo '<div class="img1">';
					echo webteck_img_tag( array(
						'url'   => esc_url( $settings['image1']['url']  ),
					));
					if(!empty($settings['image2']['url'])){
						echo '<div class="img2 jump">';
							echo webteck_img_tag( array(
								'url'   => esc_url( $settings['image2']['url']  ),
							));
						echo '</div>';
					}
					echo '<div class="faq8-shape"></div>';
				echo '</div>';
			echo '</div>';

		} elseif ( $settings['layout_style'] == '5' ){
			echo '<div class="img-box21 pe-xl-5 me-xl-2">';
				if(!empty($settings['image1']['url'])){
					echo '<div class="img1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
					echo '</div>';
				}
				if(!empty($settings['image2']['url'])){
					echo '<div class="img2">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image2']['url']  ),
						));
					echo '</div>';
				}
				echo '<div class="th-experience">';
					if(!empty($settings['title'])){
						echo '<h2 class="experience-year">'.wp_kses_post($settings['title']).'</h2>';
					}
					if(!empty($settings['desc'])){
						echo '<p class="experience-text">'.esc_html($settings['desc']).'</p>';
					}
				echo '</div>';
			echo '</div>';

		} elseif ( $settings['layout_style'] == '6' ){
			echo '<div class="choose-image5 me-xl-4">';
				if(!empty($settings['image1']['url'])){
					echo '<div class="img1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
					echo '</div>';
				}
			echo '</div>';

		} elseif ( $settings['layout_style'] == '7' ){
			if(!empty($settings['image1']['url'])){
				echo '<div class="faq-image11">';
					echo webteck_img_tag( array(
						'url'   => esc_url( $settings['image1']['url']  ),
					));
				echo '</div>';
			}

		} elseif ( $settings['layout_style'] == '8' ){
			echo '<div class="img-box22">';
				if(!empty($settings['image1']['url'])){
					echo '<div class="img1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
					echo '</div>';
				}
				if(!empty($settings['image2']['url'])){
					echo '<div class="img2 jump">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image2']['url']  ),
						));
					echo '</div>';
				}
			echo '</div>';

		} elseif ( $settings['layout_style'] == '9' ){
			echo '<div class="img-box23 pe-xl-5 me-xl-2">';
				if(!empty($settings['image1']['url'])){
					echo '<div class="img1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
					echo '</div>';
				}
				if(!empty($settings['image2']['url'])){
					echo '<div class="img2">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image2']['url']  ),
						));
					echo '</div>';
				}
				if(!empty($settings['image3']['url'])){
					echo '<div class="img3">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image3']['url']  ),
						));
					echo '</div>';
				}
				echo '<div class="th-experience">';
					if(!empty($settings['title'])){
						echo '<h2 class="experience-year">'.wp_kses_post($settings['title']).'</h2>';
					}
					if(!empty($settings['desc'])){
						echo '<p class="experience-text">'.esc_html($settings['desc']).'</p>';
					}
				echo '</div>';
				if(!empty($settings['image4']['url'])){
					echo '<div class="about-dots movingX">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image4']['url']  ),
						));
					echo '</div>';
				}
			echo '</div>';

		} elseif ( $settings['layout_style'] == '10' ){
			echo '<div class="choose-image5">';
				if(!empty($settings['image1']['url'])){
					echo '<div class="img1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
					echo '</div>';
				}
				if(!empty($settings['image2']['url'])){
					echo '<div class="choose-line">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image2']['url']  ),
						));
					echo '</div>';
				}
			echo '</div>';

		} elseif ( $settings['layout_style'] == '11' ){
			echo '<div class="img-box24 me-xl-5">';
				if(!empty($settings['image1']['url'])){
					echo '<div class="img1">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image1']['url']  ),
						));
					echo '</div>';
				}
				if(!empty($settings['image2']['url'])){
					echo '<div class="img2">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image2']['url']  ),
						));
					echo '</div>';
				}
				echo '<div class="th-experience">';
					if(!empty($settings['title'])){
						echo '<h2 class="experience-year">'.wp_kses_post($settings['title']).'</h2>';
					}
					if(!empty($settings['desc'])){
						echo '<p class="experience-text">'.esc_html($settings['desc']).'</p>';
					}
				echo '</div>';
			echo '</div>';

		}

         
	}

}

