<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Info Box Widget .
 *
 */
class Webteck_Info_Box extends Widget_Base {

	public function get_name() {
		return 'webteckinfobox';
	}
	public function get_title() {
		return __( 'Webteck Info Box', 'webteck' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'info_section',
			[
				'label' 	=> __( 'Info Box', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Layout Style', 'webteck' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'webteck' ),
					'2'  		=> __( 'Style Two', 'webteck' ),
					'3'  		=> __( 'Style Three', 'webteck' ),
					'4'  		=> __( 'Style Four', 'webteck' ),
					'5'  		=> __( 'Style Five', 'webteck' ),
				],
			]
		);
		
		webteck_media_fields( $this, 'bg', 'Choose Background', ['5'] );
        webteck_media_fields( $this, 'image2', 'Choose Image', ['5'] );

		$repeater = new Repeater();

		webteck_general_fields($repeater, 'title', 'Title', 'TEXTAREA', 'Address');
		webteck_general_fields($repeater, 'desc', 'Description', 'TEXTAREA', 'Content here');
		
		$this->add_control(
			'info_lists',
			[
				'label' 		=> __( 'Info', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'condition'	=> [
					'layout_style' => ['5']
				]
			]
		);

		//Social 
		webteck_general_fields($this, 'social_label', 'Social Title', 'TEXTAREA2', 'Stay Connected', ['5']);
		webteck_social_fields($this, 'social_lists', 'Social Lists', ['5']);

		$this->add_control(
			'title',
			[
				'label' 	=> __( 'Title', 'webteck' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Title', 'webteck' ),
                'condition'	=> ['layout_style' => ['1', '3']]
			]
        );
        $this->add_control(
			'rating',
			[
				'label' 	=> __( 'Rating', 'webteck' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( '', 'webteck' ),
                'condition'	=> ['layout_style' => ['1', '3']]
			]
        );

        $repeater = new Repeater();

        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'image_lists',
			[
				'label' 		=> __( 'Image Lists', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'condition'	=> ['layout_style' => ['1', '3']]
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' 	=> esc_html__( 'Button Text', 'webteck' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'CONTACT US', 'webteck' ),
                'condition'	=> ['layout_style' => ['2', '4']]
			]
        );

        $this->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'	=> ['layout_style' => ['2', '4']]
			]
		);

		$this->add_control(
			'content',
			[
				'label' 	=> __( 'Content', 'webteck' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( '', 'webteck' ),
                'condition'	=> ['layout_style' => ['2']]
			]
        );

		$this->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition'	=> ['layout_style' => ['2']]
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'webteck' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Title Area', 'webteck' )
			]
        );

        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'features2',
			[
				'label' 		=> __( 'Features', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'webteck' ),
					],
				],
				'condition'		=> [ 'layout_style' =>  [ '2' ]  ],
			]
		);

		$repeater = new Repeater();

		webteck_general_fields($repeater, 'number', 'Number', 'TEXT', '');
		webteck_media_fields($repeater, 'image', 'Choose Image');
		webteck_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Fantasy Quest');
		webteck_general_fields($repeater, 'desc', 'Description', 'TEXTAREA', ''); 
		webteck_media_fields($repeater, 'icon', 'Choose Icon');
		
		$this->add_control(
			'services4',
			[
				'label' 		=> __( 'Service Lists', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Fantasy Quest', 'webteck' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['4']
				]
			]
		);

        $this->end_controls_section();


        /*-----------------------------------------features styling------------------------------------*/



	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if ( $settings['layout_style'] == '1' ){
        	echo '<div class="about-client-box style2 mb-sm-0 mb-3">';
                echo '<div class="client-thumb-group">';
                    foreach( $settings['image_lists'] as $data ) {  
                        if(!empty($data['image']['url'])){
                            echo '<div class="thumb">';
                                echo webteck_img_tag( array(
                                    'url'   => esc_url( $data['image']['url']  ),
                                ));
                            echo '</div>';
                        }
                    }
                echo '</div>';
                echo '<div class="cilent-box">';
                    if( !empty( $settings['rating'] ) ){
                        echo '<div class="about_review">'.wp_kses_post($settings['rating']).'</div>';
                    }
                    if( !empty( $settings['title'] ) ){
                        echo '<h4 class="cilent-box_counter">'.wp_kses_post($settings['title']).'</h4>';
                    }
                echo '</div>';
            echo '</div>';

	    }elseif ( $settings['layout_style'] == '2' ){
			echo '<div class="about-feature-wrap style5">';
				echo '<div>';
					foreach( $settings['features2'] as $data ) {  
						echo '<div class="about-feature style5">';
							if( !empty( $data['image']['url'] ) ){
								echo '<div class="about-feature_icon">';
									echo webteck_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
								echo '</div>';
							}
							if( ! empty( $data['title'] ) ){
								echo '<div class="media-body">';
									echo '<h3 class="about-feature_title">'.esc_html( $data['title'] ).'</h3>';
								echo '</div>';
							}
						echo '</div>';
					}
			
					echo '<div class="btn-group style3">';
						if(!empty($settings['button_text'])){
							echo '<a href="'.esc_url( $settings['button_link']['url'] ).'" class="th-btn style-radius text-capitalize">'.esc_html($settings['button_text']).'</a>';
						}
						if(!empty($settings['content'])){
						echo '<div class="call-btn">';
							echo wp_kses_post( $settings['content'] );
						echo '</div>';
						}
					echo '</div>';
				echo '</div>';
				if (!empty($settings['image']['url'])) {
					echo '<div class="about-img">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image']['url']  ),
						));
					echo '</div>';
				}
			echo '</div>';

	    }elseif ( $settings['layout_style'] == '3' ){
			echo '<div class="about-client-box style2">';
				echo '<div class="client-thumb-group">';
					foreach( $settings['image_lists'] as $data ) {  
						if(!empty($data['image']['url'])){
							echo '<div class="thumb">';
								echo webteck_img_tag( array(
									'url'   => esc_url( $data['image']['url']  ),
								));
							echo '</div>';
						}
					}
				echo '</div>';
				echo '<div class="cilent-box style2">';
					if( !empty( $settings['rating'] ) ){
						echo '<div class="about_review">'.wp_kses_post($settings['rating']).'</div>';
					}
					if( !empty( $settings['title'] ) ){
                        echo '<h4 class="cilent-box_counter">'.wp_kses_post($settings['title']).'</h4>';
                    }
				echo '</div>';
			echo '</div>';

		}elseif ( $settings['layout_style'] == '4' ){
			echo '<div class="service-list-content">';
				foreach( $settings['services4'] as $data ) { 
					echo '<div class="service-list">';
						echo '<div class="service-wrapp">';
							if( ! empty( $data['number'] ) ){
								echo '<div class="box-number">'.wp_kses_post( $data['number'] ).'</div>';
							}
							echo '<div class="box-profile">';
								if( ! empty( $data['image']['url'] ) ){
									echo '<div class="box-author">';
										echo webteck_img_tag( array(
											'url'   => esc_url( $data['image']['url'] ),
										) );
									echo '</div>';
								}
								echo '<div class="box-content">';
									if( ! empty( $data['title'] ) ){
										echo '<h4 class="box-title title">'.wp_kses_post( $data['title'] ).'</h4>';
									}
									if( ! empty( $data['desc'] ) ){
										echo '<span class="text desc">'.wp_kses_post( $data['desc'] ).'</span>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
						if( ! empty( $data['icon']['url'] ) ){
							echo '<div class="box-badge">';
								echo webteck_img_tag( array(
									'url'   => esc_url( $data['icon']['url'] ),
								) );
							echo '</div>';
						}
					echo '</div>';
				}
				if(!empty($settings['button_text'])){
					echo '<a href="'.esc_url( $settings['button_link']['url'] ).'" class="th-btn style11 text-capitalize style-radius">'.esc_html($settings['button_text']).'</a>';
				}
			echo '</div>';

		}elseif ( $settings['layout_style'] == '5' ){
			echo '<div class="appointment-area11" data-bg-src="'.esc_url( $settings['bg']['url'] ).'">';
				foreach( $settings['info_lists'] as $data ) {  
					echo '<div class="contact-info2">';
						echo '<div class="media-body">';
							if( !empty( $data['title'] ) ){
								echo '<h4 class="box-title">'.wp_kses_post($data['title']).'</h4>';
							}
							if( !empty( $data['desc'] ) ){
								echo '<div class="info2">'.wp_kses_post($data['desc']).'</div>';
							}
						echo '</div>';
					echo '</div>';
				}
				echo '<div class="th-social style3">';
					if( !empty( $settings['social_label'] ) ){
						echo '<span class="social-title">'.wp_kses_post($settings['social_label']).'</span>';
					}
					foreach( $settings['social_lists'] as $social_icon ){
						$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
						$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';

						echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';

						\Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] );

						echo '</a> ';
					}
				echo '</div>';
				if (!empty($settings['image2']['url'])) {
					echo '<div class="appointment-image11">';
						echo webteck_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
					echo '</div>';
				}
			echo '</div>';

		}


	}
}