<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Team Box Widget .
 *
 */
class Webteck_Team extends Widget_Base {

	public function get_name() {
		return 'webteckteam';
	}
	public function get_title() {
		return __( 'Team v2', 'webteck' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'teamd_section',
			[
				'label' 	=> __( 'Team', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Team Style', 'webteck' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'webteck' ),
					'layout_two'  		=> __( 'Style Two', 'webteck' ),
					'layout_three'  	=> __( 'Style Three', 'webteck' ),
					'layout_four'  		=> __( 'Style Four', 'webteck' ),
					'layout_five'  		=> __( 'Style Five', 'webteck' ),
					'layout_six'  		=> __( 'Style Six', 'webteck' ),
					'layout_seven'  	=> __( 'Style Seven', 'webteck' ),
					'layout_eight'  	=> __( 'Style Eight', 'webteck' ),
					'layout_nine'  		=> __( 'Style Nine', 'webteck' ),
					'layout_ten'  		=> __( 'Style Ten', 'webteck' ),
				]
			]
		);

		$this->add_control(
			'title', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition'	=> ['layout_style' => ['layout_four', 'layout_six' ]]
			]
		);
		$this->add_control(
			'subtitle', [
				'label' 		=> __( 'Subtitle', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition'	=> ['layout_style' => ['layout_four', 'layout_six' ]]
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'name', [
				'label' 		=> __( 'Name', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Michael Lee' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'profile_link',
			[
				'label' 		=> esc_html__( 'Profile Link', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$repeater->add_control(
			'designation', [
				'label' 		=> __( 'Designation', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> __( 'Customer' , 'webteck' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'team_image',
			[
				'label' 		=> esc_html__( 'Team Member Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'fb_link',
			[
				'label' 		=> esc_html__( 'Facebook Link', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$repeater->add_control(
			'twitter_link',
			[
				'label' 		=> esc_html__( 'Twitter Link', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$repeater->add_control(
			'linkedin_link',
			[
				'label' 		=> esc_html__( 'Linkedin Link', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
			]
		);
		$repeater->add_control(
			'insta_link',
			[
				'label' 		=> esc_html__( 'Instagram Link', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
			]
		);

		$this->add_control(
			'team_members',
			[
				'label' 		=> __( 'Team Member', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'Michael Lee', 'webteck' ),
					],
				],
				'title_field' 	=> '{{{ name }}}', 
				'condition'		=> [ 
					'layout_style!' => [ 'layout_ten']
				],
			]
		);


		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'name', [
				'label' 		=> __( 'Name', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Michael Lee' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'profile_link',
			[
				'label' 		=> esc_html__( 'Profile Link', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
		$repeater->add_control(
			'designation', [
				'label' 		=> __( 'Designation', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> __( 'Customer' , 'webteck' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'team_image',
			[
				'label' 		=> esc_html__( 'Team Member Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'linkedin_icon', [
				'label' 		=> __( 'Social Icon', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> __( '<i class="fab fa-linkedin-in"></i>' , 'webteck' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'linkedin_link',
			[
				'label' 		=> esc_html__( 'Social Link', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
			]
		);

		$this->add_control(
			'team_members2',
			[
				'label' 		=> __( 'Team Member', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'Michael Lee', 'webteck' ),
					],
				],
				'title_field' 	=> '{{{ name }}}', 
				'condition'		=> [ 
					'layout_style' => [ 'layout_ten']
				],
			]
		);
		
		
        $this->end_controls_section();

       	//---------------------------------------
			//Style Section Start
		//---------------------------------------


		webteck_common_style_fields($this, 'sub2', 'Section Subtitle', '{{WRAPPER}} .sub-title', ['layout_four', 'layout_six' ]);
		webteck_common_style_fields($this, 'title2', 'Section Title', '{{WRAPPER}} .sec-title', ['layout_four', 'layout_six' ]);

		//-------Name Style-------
		webteck_common2_style_fields( $this, 'name', 'Name', '{{WRAPPER}} .box-title a' );
		//-------Designation Style-------
		webteck_common_style_fields( $this, 'desig', 'Designation', '{{WRAPPER}} .team-desig' );


       
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){
        	echo '<div class="slider-area">'; ?>
                <div class="swiper th-slider has-shadow" id="teamSlider2" data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"}}}'> <?php
                    echo '<div class="swiper-wrapper">';
                       	foreach( $settings['team_members'] as $data ) {
		            		$target = $data['profile_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $data['profile_link']['nofollow'] ? ' rel="nofollow"' : '';

							$f_target = $data['fb_link']['is_external'] ? ' target="_blank"' : '';
							$f_nofollow = $data['fb_link']['nofollow'] ? ' rel="nofollow"' : '';

							$t_target = $data['twitter_link']['is_external'] ? ' target="_blank"' : '';
							$t_nofollow = $data['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';

							$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
							$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';

							$i_target = $data['insta_link']['is_external'] ? ' target="_blank"' : '';
							$i_nofollow = $data['insta_link']['nofollow'] ? ' rel="nofollow"' : '';

	                        echo '<!-- Single Item -->';
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="th-team team-card2">';
	                                echo '<div class="team-img">';
	                                    if( ! empty( $data['team_image']['url'] ) ){
				                            echo webteck_img_tag( array(
					                            'url'       => esc_url( $data['team_image']['url'] ),
					                        ) );
					                    }
	                                    echo '<div class="social-links">';
	                                        if( ! empty( $data['fb_link']['url']) ){
				                                echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['fb_link']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
				                            }
				                            if( ! empty( $data['twitter_link']['url']) ){
				                                echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_link']['url'] ).'"><i class="fab fa-twitter"></i></a>';
				                            }
				                            if( ! empty( $data['linkedin_link']['url']) ){
				                                echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
				                            }
				                            if( ! empty( $data['insta_link']['url']) ){
				                                echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['insta_link']['url'] ).'"><i class="fab fa-instagram"></i></a>';
				                            }
	                                    echo '</div>';
	                                echo '</div>';
	                                echo '<div class="box-content">';
	                                    echo '<div class="media-body">';
	                                    	if( ! empty( $data['name']) ){
						                        echo '<h3 class="box-title title-selector"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $data['profile_link']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
						                    }
	                                        if( ! empty( $data['designation']) ){
						                        echo '<span class="team-desig desig-selector">'.esc_html($data['designation']).'</span>';
						                    }
	                                    echo '</div>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
                echo '<button data-slider-prev="#teamSlider2" class="slider-arrow style2 slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#teamSlider2" class="slider-arrow style2 slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';
	                
	    }elseif( $settings['layout_style'] == 'layout_two' ){
	    	echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="teamSlider5" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach( $settings['team_members'] as $data ) {
		            		$target = $data['profile_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $data['profile_link']['nofollow'] ? ' rel="nofollow"' : '';

							$f_target = $data['fb_link']['is_external'] ? ' target="_blank"' : '';
							$f_nofollow = $data['fb_link']['nofollow'] ? ' rel="nofollow"' : '';

							$t_target = $data['twitter_link']['is_external'] ? ' target="_blank"' : '';
							$t_nofollow = $data['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';

							$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
							$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';

							$i_target = $data['insta_link']['is_external'] ? ' target="_blank"' : '';
							$i_nofollow = $data['insta_link']['nofollow'] ? ' rel="nofollow"' : '';

	                        echo '<!-- Single Item -->';
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="th-team team-card3">';
	                                echo '<div class="team-img">';
	                                    if( ! empty( $data['team_image']['url'] ) ){
				                            echo webteck_img_tag( array(
					                            'url'       => esc_url( $data['team_image']['url'] ),
					                        ) );
					                    }
	                                echo '</div>';
	                                echo '<div class="box-content">';
	                                    echo '<div class="social-links">';
	                                        if( ! empty( $data['fb_link']['url']) ){
				                                echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['fb_link']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
				                            }
				                            if( ! empty( $data['twitter_link']['url']) ){
				                                echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_link']['url'] ).'"><i class="fab fa-twitter"></i></a>';
				                            }
				                            if( ! empty( $data['linkedin_link']['url']) ){
				                                echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
				                            }
				                            if( ! empty( $data['insta_link']['url']) ){
				                                echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['insta_link']['url'] ).'"><i class="fab fa-instagram"></i></a>';
				                            }
	                                    echo '</div>';
	                                    echo '<div class="media-body">';
	                                        if( ! empty( $data['name']) ){
						                        echo '<h3 class="box-title title-selector"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $data['profile_link']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
						                    }
	                                        if( ! empty( $data['designation']) ){
						                        echo '<span class="team-desig desig-selector">'.esc_html($data['designation']).'</span>';
						                    }
	                                    echo '</div>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
                echo '<button data-slider-prev="#teamSlider5" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#teamSlider5" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';

	    }elseif( $settings['layout_style'] == 'layout_three' ){
			echo '<div class="slider-area">';
				echo '<div class="swiper th-slider has-shadow" id="teamSlider7" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['team_members'] as $data ) {
							$target = $data['profile_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $data['profile_link']['nofollow'] ? ' rel="nofollow"' : '';

							$f_target = $data['fb_link']['is_external'] ? ' target="_blank"' : '';
							$f_nofollow = $data['fb_link']['nofollow'] ? ' rel="nofollow"' : '';

							$t_target = $data['twitter_link']['is_external'] ? ' target="_blank"' : '';
							$t_nofollow = $data['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';

							$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
							$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';

							$i_target = $data['insta_link']['is_external'] ? ' target="_blank"' : '';
							$i_nofollow = $data['insta_link']['nofollow'] ? ' rel="nofollow"' : '';
							echo '<div class="swiper-slide">';
								echo '<div class="th-team team-box2">';
									echo '<div class="team-img-wrap">';
										if( ! empty( $data['team_image']['url'] ) ){
											echo '<div class="team-img">';
												echo webteck_img_tag( array(
													'url'       => esc_url( $data['team_image']['url'] ),
												) );
											echo '</div>';
					                    }
										echo '<div class="th-social">';
											if( ! empty( $data['fb_link']['url']) ){
												echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['fb_link']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
											}
											if( ! empty( $data['twitter_link']['url']) ){
												echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_link']['url'] ).'"><i class="fab fa-twitter"></i></a>';
											}
											if( ! empty( $data['linkedin_link']['url']) ){
												echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
											}
											if( ! empty( $data['insta_link']['url']) ){
												echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['insta_link']['url'] ).'"><i class="fab fa-instagram"></i></a>';
											}
										echo '</div>';
									echo '</div>';
									echo '<div class="team-content">';
										echo '<div class="media-body">';
											if( ! empty( $data['name']) ){
												echo '<h3 class="box-title title-selector"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $data['profile_link']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
											}
											if( ! empty( $data['designation']) ){
												echo '<span class="team-desig desig-selector">'.esc_html($data['designation']).'</span>';
											}
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
				echo '<button data-slider-prev="#teamSlider7" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
				echo '<button data-slider-next="#teamSlider7" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_four' ){
			echo '<div class="row justify-content-lg-between justify-content-center align-items-end">';
				echo '<div class="col-xl-6">';
					echo '<div class="title-area text-center text-xl-start">';
						if(!empty($settings['subtitle'])){
							echo '<span class="sub-title sub-title3 style1">'.wp_kses_post($settings['subtitle']).'</span>';
						}
						if(!empty($settings['title'])){
							echo '<h2 class="sec-title sec-title2">'.wp_kses_post($settings['title']).'</h2>';
						}
					echo '</div>';
				echo '</div>';
				echo '<div class="col-lg-auto d-none d-xl-block">';
					echo '<div class="sec-btn">';
						echo '<div class="icon-box">';
							echo '<button data-slider-prev="#teamSlider8" class="slider-arrow style2 default"><i class="far fa-arrow-left"></i></button>';
							echo '<button data-slider-next="#teamSlider8" class="slider-arrow style2 default"><i class="far fa-arrow-right"></i></button>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';
			echo '<div class="slider-area">';
				echo '<div class="swiper th-slider has-shadow" id="teamSlider8" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"}}}\'>';
					echo '<div class="swiper-wrapper">';
					foreach( $settings['team_members'] as $data ) {
						$target = $data['profile_link']['is_external'] ? ' target="_blank"' : '';
						$nofollow = $data['profile_link']['nofollow'] ? ' rel="nofollow"' : '';

						$f_target = $data['fb_link']['is_external'] ? ' target="_blank"' : '';
						$f_nofollow = $data['fb_link']['nofollow'] ? ' rel="nofollow"' : '';

						$t_target = $data['twitter_link']['is_external'] ? ' target="_blank"' : '';
						$t_nofollow = $data['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';

						$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
						$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';

						$i_target = $data['insta_link']['is_external'] ? ' target="_blank"' : '';
						$i_nofollow = $data['insta_link']['nofollow'] ? ' rel="nofollow"' : '';
						echo '<div class="swiper-slide">';
							echo '<div class="th-team team-box3">';
								if( ! empty( $data['team_image']['url'] ) ){
									echo '<div class="team-img">';
										echo webteck_img_tag( array(
											'url'       => esc_url( $data['team_image']['url'] ),
										) );
									echo '</div>';
								}
								echo '<div class="team-content">';
									echo '<div class="media-body">';
										if( ! empty( $data['name']) ){
											echo '<h3 class="box-title title-selector"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $data['profile_link']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
										}
										if( ! empty( $data['designation']) ){
											echo '<span class="team-desig desig-selector">'.esc_html($data['designation']).'</span>';
										}
									echo '</div>';
									echo '<div class="team-social-wrap">';
										echo '<div class="th-social">';
											if( ! empty( $data['fb_link']['url']) ){
												echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['fb_link']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
											}
											if( ! empty( $data['twitter_link']['url']) ){
												echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_link']['url'] ).'"><i class="fab fa-twitter"></i></a>';
											}
											if( ! empty( $data['linkedin_link']['url']) ){
												echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
											}
											if( ! empty( $data['insta_link']['url']) ){
												echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['insta_link']['url'] ).'"><i class="fab fa-instagram"></i></a>';
											}
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					}
					echo '</div>';
				echo '</div>';
				echo '<button data-slider-prev="#teamSlider7" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
				echo '<button data-slider-next="#teamSlider7" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_five' ){
			echo '<div class="slider-area">';
				echo '<div class="swiper th-slider has-shadow" id="teamSlider10" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['team_members'] as $data ) {
							$target = $data['profile_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $data['profile_link']['nofollow'] ? ' rel="nofollow"' : '';

							$f_target = $data['fb_link']['is_external'] ? ' target="_blank"' : '';
							$f_nofollow = $data['fb_link']['nofollow'] ? ' rel="nofollow"' : '';

							$t_target = $data['twitter_link']['is_external'] ? ' target="_blank"' : '';
							$t_nofollow = $data['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';

							$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
							$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';

							$i_target = $data['insta_link']['is_external'] ? ' target="_blank"' : '';
							$i_nofollow = $data['insta_link']['nofollow'] ? ' rel="nofollow"' : '';
							echo '<div class="swiper-slide">';
								echo '<div class="th-team team-box3">';
									if( ! empty( $data['team_image']['url'] ) ){
										echo '<div class="team-img">';
											echo webteck_img_tag( array(
												'url'       => esc_url( $data['team_image']['url'] ),
											) );
										echo '</div>';
									}
									echo '<div class="team-content">';
										echo '<div class="media-body">';
											if( ! empty( $data['name']) ){
												echo '<h3 class="box-title title-selector"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $data['profile_link']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
											}
											if( ! empty( $data['designation']) ){
												echo '<span class="team-desig desig-selector">'.esc_html($data['designation']).'</span>';
											}
										echo '</div>';
										echo '<div class="team-social-wrap">';
											echo '<div class="th-social">';
												if( ! empty( $data['fb_link']['url']) ){
													echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['fb_link']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
												}
												if( ! empty( $data['twitter_link']['url']) ){
													echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_link']['url'] ).'"><i class="fab fa-twitter"></i></a>';
												}
												if( ! empty( $data['linkedin_link']['url']) ){
													echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
												}
												if( ! empty( $data['insta_link']['url']) ){
													echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['insta_link']['url'] ).'"><i class="fab fa-instagram"></i></a>';
												}
											echo '</div>';
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
				echo '<button data-slider-prev="#teamSlider10" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
				echo '<button data-slider-next="#teamSlider10" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_six' ){
			echo '<div class="row justify-content-lg-between justify-content-center align-items-end">';
				echo '<div class="col-xl-6">';
					echo '<div class="title-area text-center text-xl-start">';
						if(!empty($settings['subtitle'])){
							echo '<span class="sub-title">'.wp_kses_post($settings['subtitle']).'</span>';
						}
						if(!empty($settings['title'])){
							echo '<h2 class="sec-title">'.wp_kses_post($settings['title']).'</h2>';
						}
					echo '</div>';
				echo '</div>';
				echo '<div class="col-lg-auto d-none d-xl-block">';
					echo '<div class="sec-btn">';
						echo '<div class="icon-box">';
							echo '<button data-slider-prev="#teamSlider9" class="slider-arrow style2 default"><i class="far fa-arrow-left"></i></button>';
							echo '<button data-slider-next="#teamSlider9" class="slider-arrow style2 default"><i class="far fa-arrow-right"></i></button>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="teamSlider9" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"}}}\'>';
                    echo '<div class="swiper-wrapper">';
					foreach( $settings['team_members'] as $data ) {
						$target = $data['profile_link']['is_external'] ? ' target="_blank"' : '';
						$nofollow = $data['profile_link']['nofollow'] ? ' rel="nofollow"' : '';

						$f_target = $data['fb_link']['is_external'] ? ' target="_blank"' : '';
						$f_nofollow = $data['fb_link']['nofollow'] ? ' rel="nofollow"' : '';

						$t_target = $data['twitter_link']['is_external'] ? ' target="_blank"' : '';
						$t_nofollow = $data['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';

						$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
						$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';

						$i_target = $data['insta_link']['is_external'] ? ' target="_blank"' : '';
						$i_nofollow = $data['insta_link']['nofollow'] ? ' rel="nofollow"' : '';
                        echo '<div class="swiper-slide">';
                            echo '<div class="th-team team-box4">';
                                echo '<div class="team-img-wrap">';
									if( ! empty( $data['team_image']['url'] ) ){
										echo '<div class="team-img">';
											echo webteck_img_tag( array(
												'url'       => esc_url( $data['team_image']['url'] ),
											) );
										echo '</div>';
									}
                                    echo '<div class="th-social">';
										if( ! empty( $data['fb_link']['url']) ){
											echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['fb_link']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
										}
										if( ! empty( $data['twitter_link']['url']) ){
											echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_link']['url'] ).'"><i class="fab fa-twitter"></i></a>';
										}
										if( ! empty( $data['linkedin_link']['url']) ){
											echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
										}
										if( ! empty( $data['insta_link']['url']) ){
											echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['insta_link']['url'] ).'"><i class="fab fa-instagram"></i></a>';
										}
                                    echo '</div>';
                                echo '</div>';
                                echo '<div class="team-content">';
                                    echo '<div class="media-body">';
										if( ! empty( $data['name']) ){
											echo '<h3 class="box-title title-selector"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $data['profile_link']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
										}
										if( ! empty( $data['designation']) ){
											echo '<span class="team-desig desig-selector">'.esc_html($data['designation']).'</span>';
										}
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
					}
                    echo '</div>';
                echo '</div>';
            echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_seven' ){
			echo '<div class="slider-area">';
				echo '<div class="swiper th-slider has-shadow" id="teamSlider5" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"3"},"1300":{"slidesPerView":"4"}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['team_members'] as $data ) {
							$target = $data['profile_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $data['profile_link']['nofollow'] ? ' rel="nofollow"' : '';

							$f_target = $data['fb_link']['is_external'] ? ' target="_blank"' : '';
							$f_nofollow = $data['fb_link']['nofollow'] ? ' rel="nofollow"' : '';

							$t_target = $data['twitter_link']['is_external'] ? ' target="_blank"' : '';
							$t_nofollow = $data['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';

							$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
							$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';

							$i_target = $data['insta_link']['is_external'] ? ' target="_blank"' : '';
							$i_nofollow = $data['insta_link']['nofollow'] ? ' rel="nofollow"' : '';

							echo '<div class="swiper-slide">';
								echo '<div class="th-team team-box5">';
									echo '<div class="team-img-wrap">';
										if( ! empty( $data['team_image']['url'] ) ){
											echo '<div class="team-img">';
												echo webteck_img_tag( array(
													'url'       => esc_url( $data['team_image']['url'] ),
												) );
											echo '</div>';
										}
										echo '<div class="th-social">';
											if( ! empty( $data['fb_link']['url']) ){
												echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['fb_link']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
											}
											if( ! empty( $data['twitter_link']['url']) ){
												echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_link']['url'] ).'"><i class="fab fa-twitter"></i></a>';
											}
											if( ! empty( $data['linkedin_link']['url']) ){
												echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
											}
											if( ! empty( $data['insta_link']['url']) ){
												echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['insta_link']['url'] ).'"><i class="fab fa-instagram"></i></a>';
											}
										echo '</div>';
									echo '</div>';
									echo '<div class="team-content">';
										echo '<div class="media-body">';
											if( ! empty( $data['name']) ){
												echo '<h3 class="box-title title-selector"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $data['profile_link']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
											}
											if( ! empty( $data['designation']) ){
												echo '<span class="team-desig desig-selector">'.esc_html($data['designation']).'</span>';
											}
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
				echo '<button data-slider-prev="#teamSlider5" class="slider-arrow style2 slider-prev"><i class="far fa-arrow-left"></i></button>';
				echo '<button data-slider-next="#teamSlider5" class="slider-arrow style2 slider-next"><i class="far fa-arrow-right"></i></button>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_eight' ){
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="teamSlider11" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"3"},"1300":{"slidesPerView":"4"}}}\'>';
                    echo '<div class="swiper-wrapper">';
						foreach( $settings['team_members'] as $data ) {
							$target = $data['profile_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $data['profile_link']['nofollow'] ? ' rel="nofollow"' : '';

							$f_target = $data['fb_link']['is_external'] ? ' target="_blank"' : '';
							$f_nofollow = $data['fb_link']['nofollow'] ? ' rel="nofollow"' : '';

							$t_target = $data['twitter_link']['is_external'] ? ' target="_blank"' : '';
							$t_nofollow = $data['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';

							$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
							$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';

							$i_target = $data['insta_link']['is_external'] ? ' target="_blank"' : '';
							$i_nofollow = $data['insta_link']['nofollow'] ? ' rel="nofollow"' : '';

							echo '<div class="swiper-slide">';
								echo '<div class="th-team team-grid style2">';
									if( ! empty( $data['team_image']['url'] ) ){
										echo '<div class="team-img" data-mask-src="'.WEBTECK_PLUGDIRURI.'assets/img/team_shape.png">';
											echo webteck_img_tag( array(
												'url'       => esc_url( $data['team_image']['url'] ),
											) );
										echo '</div>';
									}
									echo '<div class="team-social">';
										echo '<div class="play-btn"><i class="fa-regular fa-share-nodes"></i></div>';
										echo '<div class="th-social">';
											if( ! empty( $data['fb_link']['url']) ){
												echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['fb_link']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
											}
											if( ! empty( $data['twitter_link']['url']) ){
												echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_link']['url'] ).'"><i class="fab fa-twitter"></i></a>';
											}
											if( ! empty( $data['linkedin_link']['url']) ){
												echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
											}
											if( ! empty( $data['insta_link']['url']) ){
												echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['insta_link']['url'] ).'"><i class="fab fa-instagram"></i></a>';
											}
										echo '</div>';
									echo '</div>';
									echo '<div class="box-content">';
										if( ! empty( $data['name']) ){
											echo '<h3 class="box-title title-selector"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $data['profile_link']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
										}
										if( ! empty( $data['designation']) ){
											echo '<span class="team-desig desig-selector">'.esc_html($data['designation']).'</span>';
										}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
                    echo '</div>';
                echo '</div>';
                echo '<button data-slider-prev="#teamSlider11" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#teamSlider11" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_nine' ){
			echo '<div class="slider-area">';
				echo '<div class="swiper th-slider has-shadow" id="teamSlider11" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['team_members'] as $data ) {
							$target = $data['profile_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $data['profile_link']['nofollow'] ? ' rel="nofollow"' : '';

							$f_target = $data['fb_link']['is_external'] ? ' target="_blank"' : '';
							$f_nofollow = $data['fb_link']['nofollow'] ? ' rel="nofollow"' : '';

							$t_target = $data['twitter_link']['is_external'] ? ' target="_blank"' : '';
							$t_nofollow = $data['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';

							$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
							$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';

							$i_target = $data['insta_link']['is_external'] ? ' target="_blank"' : '';
							$i_nofollow = $data['insta_link']['nofollow'] ? ' rel="nofollow"' : '';
							echo '<div class="swiper-slide">';
								echo '<div class="th-team team-box7">';
									echo '<div class="team-img-wrap">';
										if( ! empty( $data['team_image']['url'] ) ){
											echo '<div class="team-img" data-mask-src="'.WEBTECK_PLUGDIRURI.'assets/img/team_shape2.png">';
												echo webteck_img_tag( array(
													'url'       => esc_url( $data['team_image']['url'] ),
												) );
											echo '</div>';
										}
										echo '<div class="box-share"><a href="#" class="icon-btn"><i class="fa-regular fa-share-nodes"></i></a></div>';
										echo '<div class="th-social">';
											if( ! empty( $data['fb_link']['url']) ){
												echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['fb_link']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
											}
											if( ! empty( $data['twitter_link']['url']) ){
												echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_link']['url'] ).'"><i class="fab fa-twitter"></i></a>';
											}
											if( ! empty( $data['linkedin_link']['url']) ){
												echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
											}
											if( ! empty( $data['insta_link']['url']) ){
												echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['insta_link']['url'] ).'"><i class="fab fa-instagram"></i></a>';
											}
										echo '</div>';
									echo '</div>';
									echo '<div class="team-content">';
										echo '<div class="media-body">';
											if( ! empty( $data['name']) ){
												echo '<h3 class="box-title title-selector"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $data['profile_link']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
											}
											if( ! empty( $data['designation']) ){
												echo '<span class="team-desig desig-selector">'.esc_html($data['designation']).'</span>';
											}
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
				echo '<button data-slider-prev="#teamSlider11" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
				echo '<button data-slider-next="#teamSlider11" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_ten' ){
		echo '<div class="slider-area">';
			echo '<div class="swiper th-slider has-shadow" id="teamSlider13" data-slider-options=\'{"loop":true,"paginationType":"progressbar","breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"}}}\'>';
				echo '<div class="swiper-wrapper">';
					foreach( $settings['team_members2'] as $data ) {
						$target = $data['profile_link']['is_external'] ? ' target="_blank"' : '';
						$nofollow = $data['profile_link']['nofollow'] ? ' rel="nofollow"' : '';
						$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
						$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';
						echo '<div class="swiper-slide">';
							echo '<div class="th-team team-grid2">';
								if( ! empty( $data['team_image']['url'] ) ){
									echo '<div class="team-img">';
										echo webteck_img_tag( array(
											'url'       => esc_url( $data['team_image']['url'] ),
										) );
									echo '</div>'; 
								}
								echo '<div class="box-content">';
									if( ! empty( $data['name']) ){
										echo '<h3 class="box-title title-selector"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $data['profile_link']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
									}
									if( ! empty( $data['designation']) ){
										echo '<span class="box-desig desig-selector">'.esc_html($data['designation']).'</span>';
									}
								echo '</div>';
								if( ! empty( $data['linkedin_icon']) ){
									echo '<div class="th-social">';
										echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'">'.wp_kses_post( $data['linkedin_icon'] ).'</a>';
									echo '</div>';
								}
							echo '</div>';
						echo '</div>';
					}
				echo '</div>';
				echo '<div class="slider-controller">';
					echo '<div class="slider-pagination2"></div>';
					echo '<div class="slider-pagination" data-slider-id="#projectSlider12"></div>';
					echo '<div class="icon-box">';
						echo '<button data-slider-prev="#projectSlider12" class="slider-arrow default slider-prev"><i class="fa-sharp fa-solid fa-caret-left"></i></button>';
						echo '<button data-slider-next="#projectSlider12" class="slider-arrow default slider-next"><i class="fa-sharp fa-solid fa-caret-right"></i></button>';
					echo '</div>';
				echo '</div>';
			echo '</div>';
		echo '</div>';

		}


	}
}