<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Testimonials Box Widget .
 *
 */
class Webteck_Testimonials extends Widget_Base {

	public function get_name() {
		return 'webtecktestimonials';
	}
	public function get_title() {
		return __( 'Testimonials v2', 'webteck' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonialsd_section',
			[
				'label' 	=> __( 'Testimonials', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Testimonials Style', 'webteck' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'webteck' ),
					'layout_two'  		=> __( 'Style Two', 'webteck' ),
					'layout_three'  	=> __( 'Style Three', 'webteck' ),
					'layout_four'  		=> __( 'Style Four', 'webteck' ),
					'layout_five'  		=> __( 'Style Five', 'webteck' ),
					'layout_six'  		=> __( 'Style Six', 'webteck' ),
					'layout_seven'  	=> __( 'Style Seven', 'webteck' ),
					'layout_eight'  	=> __( 'Style Eight', 'webteck' ),
					'layout_nine'  		=> __( 'Style Nine', 'webteck' ),
					'layout_ten'  		=> __( 'Style Ten', 'webteck' ),
					'layout_eleven'  		=> __( 'Style Eleven', 'webteck' ),
					'layout_twelve'  		=> __( 'Style Twelve', 'webteck' ),
					'layout_thirteen'  		=> __( 'Style Thirteen', 'webteck' ),
				]
			]
		);
		
		$this->add_control(
			'subtitle', [
				'label' 		=> __( 'Subtitle', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'All Clients Review' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition'	=> ['layout_style' => ['layout_one', 'layout_four', 'layout_seven', 'layout_nine']]
			]
		);
		$this->add_control(
			'title', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Testimonial' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition'	=> ['layout_style' => ['layout_one', 'layout_four', 'layout_seven', 'layout_nine']]
			]
		);

		$this->add_control(
			'sub_img',
			[
				'label' 		=> esc_html__( 'Subtitle Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition'	=> ['layout_style' => ['layout_four']]
			]
		);
		$this->add_control(
			'bg',
			[
				'label' 		=> esc_html__( 'Background Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition'	=> ['layout_style' => ['layout_four']]
			]
		);
		$this->add_control(
			'bg2',
			[
				'label' 		=> esc_html__( 'Background Shape Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition'	=> ['layout_style' => ['layout_four']]
			]
		);
		$this->add_control(
			'image',
			[
				'label' 		=> esc_html__( 'Choose Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'condition'	=> ['layout_style' => ['layout_four']]
			]
		);
		$this->add_control(
			'quote',
			[
				'label' 		=> esc_html__( 'Quote Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'	=> ['layout_style' => ['layout_one', 'layout_six', 'layout_eight', 'layout_eleven']]
			]
		);


		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'name', [
				'label' 		=> __( 'Name', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'designation', [
				'label' 		=> __( 'Designation', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> __( 'Customer' , 'webteck' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'feedback', [
				'label' 		=> __( 'Feedback', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Customer' , 'webteck' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'client_image',
			[
				'label' 		=> esc_html__( 'Client Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'company_image',
			[
				'label' 		=> esc_html__( 'Company Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'2_testimonials',
			[
				'label' 		=> __( 'Testimonials', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'name' 		=> __( 'Your Name', 'webteck' ),
					],
				],
				'title_field' 	=> '{{{ name }}}',
				'condition'	=> ['layout_style' => ['layout_one']]
			]
		);

		//----------------------------------------------------------style 1----------------------------------------------------------//
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'name', [
				'label' 		=> __( 'Name', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'designation', [
				'label' 		=> __( 'Designation', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> __( 'Customer' , 'webteck' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'feedback', [
				'label' 		=> __( 'Feedback', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Customer' , 'webteck' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'client_image',
			[
				'label' 		=> esc_html__( 'Client Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'1_testimonials',
			[
				'label' 		=> __( 'Testimonials', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'name' 		=> __( 'Your Name', 'webteck' ),
					],
				],
				'title_field' 	=> '{{{ name }}}',
				'condition'	=> ['layout_style' => ['layout_two', 'layout_three', 'layout_four', 'layout_six', 'layout_seven', 'layout_eight', 'layout_nine']]
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'name', [
				'label' 		=> __( 'Name', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'designation', [
				'label' 		=> __( 'Designation', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> __( 'Customer' , 'webteck' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'feedback', [
				'label' 		=> __( 'Feedback', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Customer' , 'webteck' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'client_image',
			[
				'label' 		=> esc_html__( 'Client Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'client_rating',
			[
				'label' 	=> __( 'Client Rating', 'webteck' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> 'five',
				'options' 	=> [
					'one'  		=> __( 'One Star', 'webteck' ),
					'two' 		=> __( 'Two Star', 'webteck' ),
					'three' 	=> __( 'Three Star', 'webteck' ),
					'four' 		=> __( 'Four Star', 'webteck' ),
					'five' 	 	=> __( 'Five Star', 'webteck' ),
				],
			]
		);
		$this->add_control(
			'3_testimonials',
			[
				'label' 		=> __( 'Testimonials', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'name' 		=> __( 'Your Name', 'webteck' ),
					],
				],
				'title_field' 	=> '{{{ name }}}',
				'condition'	=> [
					'layout_style' => ['layout_five', 'layout_ten', 'layout_eleven', 'layout_twelve', 'layout_thirteen']
				]
			]
		);
		
        $this->end_controls_section();

        //-------------------------------------title styling-------------------------------------//
        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Style', 'webteck' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		webteck_elementor_color_style($this, 'Box BG', '{{WRAPPER}} .testi-box5', ['layout_one'],'--white-color' );

		webteck_all_elementor_style($this, 'Secion Subtitle', '{{WRAPPER}} .subtitle-selector',['layout_one'],'--white-color' );
		webteck_all_elementor_style($this, 'Secion Title', '{{WRAPPER}} .title-selector',['layout_one'],'--white-color' );

		webteck_all_elementor_style($this, 'Name', '{{WRAPPER}} .title-selector',['layout_one','layout_one'], '--title-color' );

		webteck_all_elementor_style($this, 'Designation ', '{{WRAPPER}} .desig-selector',['layout_one'], '--theme-color' );
		webteck_all_elementor_style($this, 'Feedback ', '{{WRAPPER}} .feedback-selector',['layout_one'], '--body-color' );

        $this->end_controls_section();

		webteck_common_style_fields($this, 'sub', 'Subtitle', '{{WRAPPER}} .sub-title', ['layout_four', 'layout_seven', 'layout_nine'] );
		webteck_common_style_fields($this, 'title2', 'Title', '{{WRAPPER}} .sec-title', ['layout_four', 'layout_seven', 'layout_nine'] );

		//-------Name Style-------
		webteck_common_style_fields( $this, 'name', 'Name', '{{WRAPPER}} .title-selector', ['layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight', 'layout_nine', 'layout_ten', 'layout_eleven', 'layout_twelve', 'layout_thirteen'] );
		//-------Designation Style-------
		webteck_common_style_fields( $this, 'designation', 'Designation', '{{WRAPPER}} .desig-selector', ['layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight', 'layout_nine', 'layout_ten', 'layout_eleven', 'layout_twelve', 'layout_thirteen']);
		//-------Feedback Style-------
		webteck_common_style_fields( $this, 'feedback', 'Feedback', '{{WRAPPER}} .feedback-selector', ['layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight', 'layout_nine', 'layout_ten', 'layout_eleven', 'layout_twelve', 'layout_thirteen'] );

       
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){
        	echo '<section class="overflow-hidden bg-top-center th-radius3 m-4 mt-0 mb-0 space arrow-wrap" id="testi-sec">';
		        echo '<div class="container th-container2">';
		            echo '<div class="row justify-content-lg-between justify-content-center align-items-end">';
		                echo '<div class="col-xxl-4 col-xl-6">';
		                    echo '<div class="title-area text-center text-lg-start">';
		                        echo '<span class="sub-title style1 text-white subtitle-selector">'.esc_html( $settings['title'] ).'</span>';
		                        echo '<h2 class="sec-title text-white title-selector">'.esc_html( $settings['subtitle'] ).'</h2>';
		                    echo '</div>';
		                echo '</div>';
		                echo '<div class="col-lg-auto d-none d-xl-block">';
		                    echo '<div class="sec-btn">';
		                        echo '<div class="icon-box">';
		                            echo '<button data-slider-prev="#testiSlider2" class="slider-arrow style2 default"><i class="far fa-arrow-left"></i></button>';
		                            echo '<button data-slider-next="#testiSlider2" class="slider-arrow style2 default"><i class="far fa-arrow-right"></i></button>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		            echo '<div class="slider-area">'; ?>
		                <div class="swiper th-slider has-shadow" id="testiSlider2" data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"}}}'> <?php
		                    echo '<div class="swiper-wrapper">';

		                    	foreach( $settings['2_testimonials'] as $data ) {
			                        echo '<div class="swiper-slide">';
			                            echo '<div class="testi-box5 th-ani">';
			                            	if( ! empty( $data['company_image']['url'] ) ){
				                                echo '<div class="testi-box5_image">';
				                                    echo webteck_img_tag( array(
							                            'url'       => esc_url( $data['company_image']['url'] ),
							                        ) );
				                                echo '</div>';
				                            }
				                            if( ! empty( $data['feedback']) ){
				                                echo '<p class="testi-box5_text feedback-selector">'.esc_html($data['feedback']).'</p>';
				                            }
			                                echo '<div class="testi-box5_wrapper">';
			                                    echo '<div class="testi-box5_profile">';
			                                    	if( ! empty( $data['client_image']['url'] ) ){
				                                        echo '<div class="testi-box5_author">';
				                                            echo webteck_img_tag( array(
									                            'url'       => esc_url( $data['client_image']['url'] ),
									                        ) );
				                                        echo '</div>';
				                                    }
			                                        echo '<div class="testi-box5_info">';
			                                            if( ! empty( $data['name']) ){
					                                        echo '<h3 class="box-title title-selector">'.esc_html($data['name']).'</h3>';
					                                    }
					                                    if( ! empty( $data['designation']) ){
					                                        echo '<span class="testi-box5_desig desig-selector">'.esc_html($data['designation']).'</span>';
					                                    }
			                                        echo '</div>';
			                                    echo '</div>';
			                                    if( ! empty( $settings['quote']['url'] ) ){
				                                    echo '<div class="testi-quote">';
				                                       	echo webteck_img_tag( array(
								                            'url'       => esc_url( $settings['quote']['url'] ),
								                        ) );
				                                    echo '</div>';
				                                }
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</section>';

	    }elseif( $settings['layout_style'] == 'layout_four' ){
			echo '<section class="testi-area11 th-radius3" data-bg-src="'.esc_url($settings['bg']['url']).'">';
				echo '<div class="container th-container4">';
					echo '<div class="row align-items-center">';
						if (!empty($settings['image']['url'])) {
						echo '<div class="col-xl-6">';
							echo '<div class="testi-image11">';
								echo '<div class="testi-img">';
									echo webteck_img_tag( array(
										'url'   => esc_url( $settings['image']['url'] ),
									));
								echo '</div>';
							echo '</div>';
						echo '</div>';
						}
						echo '<div class="col-xl-6">';
							echo '<div class="title-area mb-30">';
								if(!empty($settings['subtitle'])){
									echo '<span class="sub-title text-capitalize fs-20">';
										if (!empty($settings['sub_img']['url'])) {
											echo '<div class="icon-masking me-2">';
												echo '<span class="mask-icon" data-mask-src="'.esc_url( $settings['sub_img']['url'] ).'"></span>';
												echo webteck_img_tag( array(
													'url'   => esc_url( $settings['sub_img']['url'] ),
												));
											echo '</div>';
										}
										echo wp_kses_post($settings['subtitle']);
									echo '</span>';
								}
								if(!empty($settings['title'])){
									echo '<h2 class="sec-title">'.wp_kses_post($settings['title']).'</h2>';
								}
							echo '</div>';
							echo '<div class="swiper th-slider testiSlide8" id="testiSlide8" data-slider-options=\'{"effect":"slide","loop":true,"thumbs":{"swiper":".testi-grid2-thumb"},"breakpoints":{"0":{"autoHeight":true},"576":{"autoHeight":false}}}\'>';
								echo '<div class="swiper-wrapper">';
								foreach( $settings['1_testimonials'] as $data ) {
									echo '<div class="swiper-slide">';
										echo '<div class="testi-card3">';
											if( ! empty( $data['feedback']) ){
												echo '<p class="testi-card3_text feedback-selector">'.esc_html($data['feedback']).'</p>';
											}
											echo '<div class="testi-card3_profile">';
												if( ! empty( $data['client_image']['url'] ) ){
													echo '<div class="testi-card3_author">';
														echo webteck_img_tag( array(
															'url'       => esc_url( $data['client_image']['url'] ),
														) );
													echo '</div>';
												}
												echo '<div class="testi-card3_info">';
													if( ! empty( $data['name']) ){
														echo '<h3 class="box-title title-selector">'.esc_html($data['name']).'</h3>';
													}
													if( ! empty( $data['designation']) ){
														echo '<span class="testi-card3_desig desig-selector">'.esc_html($data['designation']).'</span>';
													}
												echo '</div>';
											echo '</div>';
										echo '</div>';

									echo '</div>';
								}
								echo '</div>';
								echo '<div class="slider-pagination"></div>';
								echo '<div class="icon-box">';
									echo '<button data-slider-prev="#testiSlide8" class="slider-arrow style2 default"><i class="far fa-arrow-left"></i></button>';
									echo '<button data-slider-next="#testiSlide8" class="slider-arrow style2 default"><i class="far fa-arrow-right"></i></button>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
				if (!empty($settings['bg2']['url'])) {
				echo '<div class="shape-mockup testi-shape" data-top="0" data-left="0">';
					echo webteck_img_tag( array(
						'url'   => esc_url( $settings['bg2']['url'] ),
					));
				echo '</div>';
				}
			echo '</section>';

	    }elseif( $settings['layout_style'] == 'layout_five' ){
			echo '<div class="slider-area">';
				echo '<div class="swiper th-slider has-shadow" id="testiSlider14" data-slider-options=\'{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"1"},"1200":{"slidesPerView":"2"}}}\'>';
					echo '<div class="swiper-wrapper">';
					foreach( $settings['3_testimonials'] as $data ) {
						echo '<div class="swiper-slide">';
							echo '<div class="testi-box3">';
								echo '<div class="testi-box3_content">';
									echo '<div class="testi-box3_review">';
											if( $data['client_rating'] == 'one' ){
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
											}elseif( $data['client_rating'] == 'two' ){
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
											}elseif( $data['client_rating'] == 'three' ){
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
											}elseif( $data['client_rating'] == 'four' ){
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
											}else{
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
											}
										echo '</div>';
									if( ! empty( $data['feedback']) ){
										echo '<p class="testi-box3_text feedback-selector">'.esc_html($data['feedback']).'</p>';
									}
									if( ! empty( $data['name']) ){
										echo '<h3 class="box-title title-selector">'.esc_html($data['name']).'</h3>';
									}
									if( ! empty( $data['designation']) ){
										echo '<span class="testi-box3_desig desig-selector">'.esc_html($data['designation']).'</span>';
									}
								echo '</div>';
								if( ! empty( $data['client_image']['url'] ) ){
									echo '<div class="testi-box3_img">';
										echo webteck_img_tag( array(
											'url'       => esc_url( $data['client_image']['url'] ),
										) );
									echo '</div>';
								}
							echo '</div>';
						echo '</div>';
					}
					echo '</div>';
				echo '</div>';
				echo '<button data-slider-prev="#testiSlider14" class="slider-arrow style3 slider-prev"><i class="far fa-arrow-left"></i></button>';
				echo '<button data-slider-next="#testiSlider14" class="slider-arrow style3 slider-next"><i class="far fa-arrow-right"></i></button>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_six' ){
			echo '<div class="container-fluid p-0">';
				echo '<div class="slider-area">';
					echo '<div class="swiper th-slider testiSlider8 has-shadow" id="testiSlide8" data-slider-options=\'{"thumbs":{"swiper":".testi-grid3-thumb"},"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1","centeredSlides":"true"},"768":{"slidesPerView":"2","centeredSlides":"true"},"992":{"slidesPerView":"2","centeredSlides":"true"},"1200":{"slidesPerView":"2","centeredSlides":"true"},"1400":{"slidesPerView":"3","centeredSlides":"true"}}}\'>';
						echo '<div class="swiper-wrapper">';
						foreach( $settings['1_testimonials'] as $data ) {
							echo '<div class="swiper-slide">';
								echo '<div class="testi-box8">';
									if( ! empty( $data['feedback']) ){
										echo '<p class="testi-box8_text feedback-selector">'.esc_html($data['feedback']).'</p>';
									}
									echo '<div class="testi-box8_wrapper">';
										echo '<div class="testi-box8_profile">';
											if( ! empty( $data['client_image']['url'] ) ){
												echo '<div class="testi-box8_author">';
													echo webteck_img_tag( array(
														'url'       => esc_url( $data['client_image']['url'] ),
													) );
												echo '</div>';
											}
											echo '<div class="testi-box8_info">';
												if( ! empty( $data['name']) ){
													echo '<h3 class="box-title title-selector">'.esc_html($data['name']).'</h3>';
												}
												if( ! empty( $data['designation']) ){
													echo '<span class="testi-box8_desig desig-selector">'.esc_html($data['designation']).'</span>';
												}
											echo '</div>';
										echo '</div>';
										if( ! empty( $settings['quote']['url'] ) ){
											echo '<div class="test-quote_wrapp">';
												echo '<div class="testi-quote">';
													echo webteck_img_tag( array(
														'url'       => esc_url( $settings['quote']['url'] ),
													) );
												echo '</div>';
											echo '</div>';
										}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_seven' ){
			echo '<div class="slider-area testi-grid3-area style4">';
				echo '<div class="title-area text-center">';
					if(!empty($settings['subtitle'])){
						echo '<span class="sub-title">'.wp_kses_post($settings['subtitle']).'</span>';
					}
					if(!empty($settings['title'])){
						echo '<h2 class="sec-title">'.wp_kses_post($settings['title']).'</h2>';
					}
				echo '</div>';
				echo '<div class="testi-indicator">';
					echo '<div class="swiper th-slider testi-grid2-thumb" data-slider-options=\'{"effect":"slide","slidesPerView":"5","spaceBetween":13,"loop":true,"breakpoints":{"0":{"slidesPerView":4},"576":{"slidesPerView":"5"}}}\' data-slider-tab="#testiSlide1">';
						echo '<div class="swiper-wrapper">';
							foreach( $settings['1_testimonials'] as $data ) {
								echo '<div class="swiper-slide">';
									if( ! empty( $data['client_image']['url'] ) ){
										echo '<div class="box-img">';
											echo webteck_img_tag( array(
												'url'       => esc_url( $data['client_image']['url'] ),
											) );
										echo '</div>';
									}
								echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
				echo '<div class="swiper th-slider" id="testiSlide7" data-slider-options=\'{"effect":"slide","loop":true,"thumbs":{"swiper":".testi-grid2-thumb"},"breakpoints":{"0":{"autoHeight":true},"576":{"autoHeight":false}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['1_testimonials'] as $data ) {
							echo '<div class="swiper-slide">';
								echo '<div class="testi-card4">';
									if( ! empty( $data['feedback']) ){
										echo '<p class="testi-card4_text feedback-selector">'.esc_html($data['feedback']).'</p>';
									}
									echo '<div class="testi-card4_profile">';
										echo '<div class="testi-card4_content">';
											if( ! empty( $data['name']) ){
												echo '<h3 class="box-title title-selector">'.esc_html($data['name']).'</h3>';
											}
											if( ! empty( $data['designation']) ){
												echo '<span class="testi-card4_desig desig-selector">'.esc_html($data['designation']).'</span>';
											}
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
					echo '<button data-slider-prev="#testiSlide7" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
					echo '<button data-slider-next="#testiSlide7" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
				echo '</div>';
				echo '<div class="testi-line"></div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_eight' ){
			echo '<div class="swiper th-slider testiSlide3" id="testiSlide3" data-slider-options=\'{"effect":"slide","loop":false,"thumbs":{"swiper":".testi-grid5-thumb"}}\'>';
				echo '<div class="swiper-wrapper">';
					foreach( $settings['1_testimonials'] as $data ) {
						echo '<div class="swiper-slide">';
							echo '<div class="testi-grid5">';
								if( ! empty( $data['client_image']['url'] ) ){
									echo '<div class="testi-grid5_img">';
										echo webteck_img_tag( array(
											'url'       => esc_url( $data['client_image']['url'] ),
										) );
									echo '</div>';
								}
								if( ! empty( $settings['quote']['url'] ) ){
									echo '<div class="testi-grid5_quote">';
										echo webteck_img_tag( array(
											'url'       => esc_url( $settings['quote']['url'] ),
										) );
									echo '</div>';
								}
								echo '<div class="testi-grid5_content">';
									if( ! empty( $data['feedback']) ){
										echo '<p class="testi-grid5_text feedback-selector">'.esc_html($data['feedback']).'</p>';
									}
									if( ! empty( $data['name']) ){
										echo '<h3 class="box-title title-selector">'.esc_html($data['name']).'</h3>';
									}
									if( ! empty( $data['designation']) ){
										echo '<span class="testi-grid5_desig desig-selector">'.esc_html($data['designation']).'</span>';
									}
								echo '</div>';
							echo '</div>';
						echo '</div>';
					}
				echo '</div>';
			echo '</div>';

			echo '<div class="swiper th-slider testi-grid5-thumb" data-slider-options=\'{"effect":"slide","slidesPerView":"6","spaceBetween":7,"loop":false}\'>';
				echo '<div class="swiper-wrapper">';
					foreach( $settings['1_testimonials'] as $data ) {
						echo '<div class="swiper-slide">';
							if( ! empty( $data['client_image']['url'] ) ){
								echo '<div class="box-img">';
									echo webteck_img_tag( array(
										'url'       => esc_url( $data['client_image']['url'] ),
									) );
								echo '</div>';
							}
						echo '</div>';
					}
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_nine' ){
			echo '<div class="slider-area testi-grid2-area style18">';
				echo '<div class="title-area text-center">';
					if(!empty($settings['subtitle'])){
						echo '<h2 class="sub-title">'.wp_kses_post($settings['subtitle']).'</h2>';
					}
					if(!empty($settings['title'])){
						echo '<h2 class="sec-title">'.wp_kses_post($settings['title']).'</h2>';
					}
				echo '</div>';
				echo '<div class="testi-indicator">';
					echo '<div class="swiper th-slider testi-grid2-thumb" data-slider-options=\'{"effect":"slide","slidesPerView":"3","spaceBetween":13,"breakpoints":{"0":{"slidesPerView":3},"576":{"slidesPerView":"3"}}}\' data-slider-tab="#testiSlide1">';
						echo '<div class="swiper-wrapper">';
							foreach( $settings['1_testimonials'] as $data ) {
								echo '<div class="swiper-slide">';
									if( ! empty( $data['client_image']['url'] ) ){
										echo '<div class="box-img">';
											echo webteck_img_tag( array(
												'url'       => esc_url( $data['client_image']['url'] ),
											) );
										echo '</div>';
									}
								echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
				echo '<div class="swiper th-slider" id="testiSlide18" data-slider-options=\'{"effect":"slide","thumbs":{"swiper":".testi-grid2-thumb"},"breakpoints":{"0":{"autoHeight":true},"576":{"autoHeight":false}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['1_testimonials'] as $data ) {
							echo '<div class="swiper-slide">';
								echo '<div class="testi-card2">';
									if( ! empty( $data['feedback']) ){
										echo '<p class="testi-card2_text feedback-selector">'.esc_html($data['feedback']).'</p>';
									}
									echo '<div class="testi-card2_profile">';
										echo '<div class="testi-card2_content">';
											if( ! empty( $data['name']) ){
												echo '<h3 class="box-title title-selector">'.esc_html($data['name']).'</h3>';
											}
											if( ! empty( $data['designation']) ){
												echo '<span class="testi-card2_desig desig-selector">'.esc_html($data['designation']).'</span>';
											}
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
					echo '<button data-slider-prev="#testiSlide18" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
					echo '<button data-slider-next="#testiSlide18" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_ten' ){
			echo '<div class="testi-card5-area slider-area">';
				echo '<div class="swiper th-slider" id="testiSlide19" data-slider-options=\'{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"1"},"1200":{"slidesPerView":"1"}}}\'>';
					echo '<div class="swiper-wrapper">';
					foreach( $settings['3_testimonials'] as $data ) {
						echo '<div class="swiper-slide">';
							echo '<div class="testi-card5">';
								echo '<div class="box-review">';
									if( $data['client_rating'] == 'one' ){
										echo '<i class="fa-solid fa-star-sharp"></i>';
										echo '<i class="fa-light fa-star-sharp"></i>';
										echo '<i class="fa-light fa-star-sharp"></i>';
										echo '<i class="fa-light fa-star-sharp"></i>';
										echo '<i class="fa-light fa-star-sharp"></i>';
									}elseif( $data['client_rating'] == 'two' ){
										echo '<i class="fa-solid fa-star-sharp"></i>';
										echo '<i class="fa-solid fa-star-sharp"></i>';
										echo '<i class="fa-light fa-star-sharp"></i>';
										echo '<i class="fa-light fa-star-sharp"></i>';
										echo '<i class="fa-light fa-star-sharp"></i>';
									}elseif( $data['client_rating'] == 'three' ){
										echo '<i class="fa-solid fa-star-sharp"></i>';
										echo '<i class="fa-solid fa-star-sharp"></i>';
										echo '<i class="fa-solid fa-star-sharp"></i>';
										echo '<i class="fa-light fa-star-sharp"></i>';
										echo '<i class="fa-light fa-star-sharp"></i>';
									}elseif( $data['client_rating'] == 'four' ){
										echo '<i class="fa-solid fa-star-sharp"></i>';
										echo '<i class="fa-solid fa-star-sharp"></i>';
										echo '<i class="fa-solid fa-star-sharp"></i>';
										echo '<i class="fa-solid fa-star-sharp"></i>';
										echo '<i class="fa-light fa-star-sharp"></i>';
									}else{
										echo '<i class="fa-solid fa-star-sharp"></i>';
										echo '<i class="fa-solid fa-star-sharp"></i>';
										echo '<i class="fa-solid fa-star-sharp"></i>';
										echo '<i class="fa-solid fa-star-sharp"></i>';
										echo '<i class="fa-solid fa-star-sharp"></i>';
									}
								echo '</div>';
								if( ! empty( $data['feedback']) ){
									echo '<p class="box-text feedback-selector">'.esc_html($data['feedback']).'</p>';
								}
								echo '<div class="box-profile">';
									if( ! empty( $data['client_image']['url'] ) ){
										echo '<div class="box-avater">';
											echo webteck_img_tag( array(
												'url'       => esc_url( $data['client_image']['url'] ),
											) );
										echo '</div>';
									}
									echo '<div class="media-body">';
										if( ! empty( $data['name']) ){
											echo '<h3 class="box-title title-selector">'.esc_html($data['name']).'</h3>';
										}
										if( ! empty( $data['designation']) ){
											echo '<span class="box-desig desig-selector">'.esc_html($data['designation']).'</span>';
										}
									echo '</div>';
								echo '</div>';
							echo '</div>';
						echo '</div>';
					}
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_eleven' ){
			echo '<div class="slider-area">';
				echo '<div class="swiper th-slider testiSlider20 has-shadow" id="testiSlide8" data-slider-options=\'{"thumbs":{"swiper":".testi-grid3-thumb"},"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1","centeredSlides":"true"},"768":{"slidesPerView":"2","centeredSlides":"true"},"992":{"slidesPerView":"2","centeredSlides":"true"},"1200":{"slidesPerView":"2","centeredSlides":"true"},"1600":{"slidesPerView":"3","centeredSlides":"true"}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['3_testimonials'] as $data ) {
							echo '<div class="swiper-slide">';
								echo '<div class="testi-box9">';
									if( ! empty( $data['client_image']['url'] ) ){
										echo '<div class="box-img">';
											echo webteck_img_tag( array(
												'url'       => esc_url( $data['client_image']['url'] ),
											) );
										echo '</div>';
									}
									echo '<div class="box-content">';
										echo '<div class="test-quote_wrapp">';
											if( ! empty( $settings['quote']['url'] ) ){
												echo '<div class="testi-quote">';
													   echo webteck_img_tag( array(
														'url'       => esc_url( $settings['quote']['url'] ),
													) );
												echo '</div>';
											}
											echo '<div class="box-review">';
												if( $data['client_rating'] == 'one' ){
													echo '<i class="fa-solid fa-star-sharp"></i>';
													echo '<i class="fa-light fa-star-sharp"></i>';
													echo '<i class="fa-light fa-star-sharp"></i>';
													echo '<i class="fa-light fa-star-sharp"></i>';
													echo '<i class="fa-light fa-star-sharp"></i>';
												}elseif( $data['client_rating'] == 'two' ){
													echo '<i class="fa-solid fa-star-sharp"></i>';
													echo '<i class="fa-solid fa-star-sharp"></i>';
													echo '<i class="fa-light fa-star-sharp"></i>';
													echo '<i class="fa-light fa-star-sharp"></i>';
													echo '<i class="fa-light fa-star-sharp"></i>';
												}elseif( $data['client_rating'] == 'three' ){
													echo '<i class="fa-solid fa-star-sharp"></i>';
													echo '<i class="fa-solid fa-star-sharp"></i>';
													echo '<i class="fa-solid fa-star-sharp"></i>';
													echo '<i class="fa-light fa-star-sharp"></i>';
													echo '<i class="fa-light fa-star-sharp"></i>';
												}elseif( $data['client_rating'] == 'four' ){
													echo '<i class="fa-solid fa-star-sharp"></i>';
													echo '<i class="fa-solid fa-star-sharp"></i>';
													echo '<i class="fa-solid fa-star-sharp"></i>';
													echo '<i class="fa-solid fa-star-sharp"></i>';
													echo '<i class="fa-light fa-star-sharp"></i>';
												}else{
													echo '<i class="fa-solid fa-star-sharp"></i>';
													echo '<i class="fa-solid fa-star-sharp"></i>';
													echo '<i class="fa-solid fa-star-sharp"></i>';
													echo '<i class="fa-solid fa-star-sharp"></i>';
													echo '<i class="fa-solid fa-star-sharp"></i>';
												}
											echo '</div>';
										echo '</div>';
										if( ! empty( $data['feedback']) ){
											echo '<p class="box-text feedback-selector">'.esc_html($data['feedback']).'</p>';
										}
										echo '<div class="testi-box9_info">';
											if( ! empty( $data['name']) ){
												echo '<h3 class="box-title title-selector">'.esc_html($data['name']).'</h3>';
											}
											if( ! empty( $data['designation']) ){
												echo '<span class="box-desig desig-selector">'.esc_html($data['designation']).'</span>';
											}
										echo '</div>';
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_twelve' ){
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="testiSlider21" data-slider-options=\'{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"1"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach( $settings['3_testimonials'] as $data ) {
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="testi-box3 style2">';
	                                echo '<div class="testi_overlay"></div>';
	                                if( ! empty( $data['client_image']['url'] ) ){
		                                echo '<div class="testi-box3_img">';
		                                    echo webteck_img_tag( array(
												'url'       => esc_url( $data['client_image']['url'] ),
											) );
		                                echo '</div>';
		                            }
	                                echo '<div class="testi-box3_content">';
	                                    echo '<div class="testi-box3_review">';
	                                        if( $data['client_rating'] == 'one' ){
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
											}elseif( $data['client_rating'] == 'two' ){
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
											}elseif( $data['client_rating'] == 'three' ){
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
											}elseif( $data['client_rating'] == 'four' ){
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
											}else{
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
											}

	                                    echo '</div>';
	                                    if( ! empty( $data['feedback']) ){
											echo '<p class="testi-box3_text feedback-selector">'.esc_html($data['feedback']).'</p>';
										}
										if( ! empty( $data['name']) ){
											echo '<h3 class="box-title title-selector">'.esc_html($data['name']).'</h3>';
										}
										if( ! empty( $data['designation']) ){
											echo '<p class="testi-box3_desig desig-selector">'.esc_html($data['designation']).'</p>';
										}
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                        
                    echo '</div>';
                    echo '<div class="slider-pagination text-center"></div>';
                echo '</div>';
                echo '<button data-slider-prev="#testiSlider21" class="slider-arrow style3 slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#testiSlider21" class="slider-arrow style3 slider-next"><i class="far fa-arrow-right"></i></button>';

            echo '</div>';

		}elseif( $settings['layout_style'] == 'layout_thirteen' ){
			echo '<div class="slider-area">';
				echo '<div class="swiper th-slider has-shadow" id="testiSlider22" data-slider-options=\'{"loop":true,"paginationType":"progressbar","breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"1200":{"slidesPerView":"2"}}}\'>';
					echo '<div class="swiper-wrapper">';
						foreach( $settings['3_testimonials'] as $data ) {
							echo '<div class="swiper-slide">';
								echo '<div class="testi-box3 style3">';
									echo '<div class="testi-box3_content">';
										echo '<div class="testi-box3_review">';
											if( $data['client_rating'] == 'one' ){
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
											}elseif( $data['client_rating'] == 'two' ){
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
											}elseif( $data['client_rating'] == 'three' ){
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
											}elseif( $data['client_rating'] == 'four' ){
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-light fa-star-sharp"></i>';
											}else{
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
												echo '<i class="fa-solid fa-star-sharp"></i>';
											}
										echo '</div>';
										if( ! empty( $data['feedback']) ){
											echo '<p class="testi-box3_text feedback-selector">'.esc_html($data['feedback']).'</p>';
										}
										echo '<div class="box-content">';
											if( ! empty( $data['name']) ){
												echo '<h3 class="box-title title-selector">'.esc_html($data['name']).'</h3>';
											}
											if( ! empty( $data['designation']) ){
												echo '<p class="testi-box3_desig desig-selector">'.esc_html($data['designation']).'</p>';
											}
										echo '</div>';
									echo '</div>';
									if( ! empty( $data['client_image']['url'] ) ){
										echo '<div class="testi-box3_img">';
											echo webteck_img_tag( array(
												'url'       => esc_url( $data['client_image']['url'] ),
											) );
										echo '</div>';
									}
								echo '</div>';
							echo '</div>';
						}
					echo '</div>'; 
					echo '<div class="slider-controller">';
						echo '<div class="slider-pagination2"></div>';
						echo '<div class="slider-pagination" data-slider-id="#projectSlider12"></div>';
						echo '<div class="icon-box">';
							echo '<button data-slider-prev="#projectSlider12" class="slider-arrow default slider-prev"><i class="fa-sharp fa-solid fa-caret-left"></i></button>';
							echo '<button data-slider-next="#projectSlider12" class="slider-arrow default slider-next"><i class="fa-sharp fa-solid fa-caret-right"></i></button>';
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}else{
			if( $settings['layout_style'] == 'layout_three' ){
				$style = 'style3';
			}else{
				$style = '';
			}
			echo '<div class="slider-area testi-grid2-area '.esc_attr($style).'">';
				echo '<div class="testi-indicator">'; ?>
					<div class="swiper th-slider testi-grid2-thumb" data-slider-options='{"effect":"slide","slidesPerView":"5","spaceBetween":13,"loop":true,"breakpoints":{"0":{"slidesPerView":4},"576":{"slidesPerView":"5"}}}' data-slider-tab="#testiSlide1"> <?php
						echo '<div class="swiper-wrapper">';
							foreach( $settings['1_testimonials'] as $data ) {
								echo '<div class="swiper-slide">';
									if( ! empty( $data['client_image']['url'] ) ){
										echo '<div class="box-img">';
											echo webteck_img_tag( array(
												'url'       => esc_url( $data['client_image']['url'] ),
											) );
										echo '</div>';
									}
								echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>'; ?>
				<div class="swiper th-slider" id="testiSlide7" data-slider-options='{"effect":"slide","loop":true,"thumbs":{"swiper":".testi-grid2-thumb"},"breakpoints":{"0":{"autoHeight":true},"576":{"autoHeight":false}}}'><?php
					echo '<div class="swiper-wrapper">';
						foreach( $settings['1_testimonials'] as $data ) {
							echo '<div class="swiper-slide">';
								echo '<div class="testi-card2">';
									if( ! empty( $data['feedback']) ){
										echo '<p class="testi-card2_text feedback-selector">'.esc_html($data['feedback']).'</p>';
									}
									echo '<div class="testi-card2_profile">';
										echo '<div class="testi-card2_content">';
											if( ! empty( $data['name']) ){
												echo '<h3 class="box-title title-selector">'.esc_html($data['name']).'</h3>';
											}
											if( ! empty( $data['designation']) ){
												echo '<span class="testi-card2_desig desig-selector">'.esc_html($data['designation']).'</span>';
											}
										echo '</div>';
									echo '</div>';
								echo '</div>';

							echo '</div>';
						}
					echo '</div>';
					echo '<button data-slider-prev="#testiSlide1" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
					echo '<button data-slider-next="#testiSlide1" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
				echo '</div>';
				echo '<div class="testi-line"></div>';
			echo '</div>';

		}


	}
}